/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.quals.ImplicitFor;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.visitors.AnnotatedTypeScanner;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ErrorReporter;
import javacutils.TypesUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;

public class TypeAnnotator
extends AnnotatedTypeScanner<Void, Void> {
    private final Map<TypeKind, Set<AnnotationMirror>> typeKinds = new EnumMap<TypeKind, Set<AnnotationMirror>>(TypeKind.class);
    private final Map<Class<? extends AnnotatedTypeMirror>, Set<AnnotationMirror>> typeClasses = new HashMap<Class<? extends AnnotatedTypeMirror>, Set<AnnotationMirror>>();
    private final Map<String, Set<AnnotationMirror>> typeNames = new IdentityHashMap<String, Set<AnnotationMirror>>();
    private final QualifierHierarchy qualHierarchy;

    public TypeAnnotator(AnnotatedTypeFactory atypeFactory) {
        this.qualHierarchy = atypeFactory.getQualifierHierarchy();
        Set<Class<? extends Annotation>> quals = atypeFactory.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            ImplicitFor implicit = qual.getAnnotation(ImplicitFor.class);
            if (implicit == null) continue;
            AnnotationMirror theQual = AnnotationUtils.fromClass(atypeFactory.elements, qual);
            for (TypeKind typeKind : implicit.types()) {
                this.addTypeKind(typeKind, theQual);
            }
            for (Class<? extends AnnotatedTypeMirror> clazz : implicit.typeClasses()) {
                this.addTypeClass(clazz, theQual);
            }
            for (Class<?> clazz : implicit.typeNames()) {
                this.addTypeName(clazz, theQual);
            }
        }
    }

    public void addTypeKind(TypeKind typeKind, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.typeKinds, typeKind, theQual);
        if (!res) {
            ErrorReporter.errorAbort("TypeAnnotator: invalid update of typeKinds " + this.typeKinds + " at " + (Object)((Object)typeKind) + " with " + theQual);
        }
    }

    public void addTypeClass(Class<? extends AnnotatedTypeMirror> typeClass, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.typeClasses, typeClass, theQual);
        if (!res) {
            ErrorReporter.errorAbort("TypeAnnotator: invalid update of typeClasses " + this.typeClasses + " at " + typeClass + " with " + theQual);
        }
    }

    public void addTypeName(Class<?> typeName, AnnotationMirror theQual) {
        String typeNameString = typeName.getCanonicalName().intern();
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.typeNames, typeNameString, theQual);
        if (!res) {
            ErrorReporter.errorAbort("TypeAnnotator: invalid update of typeNames " + this.typeNames + " at " + typeName + " with " + theQual);
        }
    }

    @Override
    protected Void scan(AnnotatedTypeMirror type, Void p) {
        Class<?> t;
        Set<AnnotationMirror> fnd;
        if (type == null) {
            return (Void)super.scan(type, p);
        }
        String qname = null;
        if (type.getKind() == TypeKind.DECLARED) {
            qname = TypesUtils.getQualifiedName((DeclaredType)type.getUnderlyingType()).toString();
        } else if (type.getKind().isPrimitive()) {
            qname = type.getUnderlyingType().toString();
        }
        String string = qname = qname == null ? null : qname.intern();
        if (qname != null && this.typeNames.containsKey(qname)) {
            fnd = this.typeNames.get(qname);
            type.addMissingAnnotations(fnd);
        }
        if (this.typeKinds.containsKey((Object)type.getKind())) {
            fnd = this.typeKinds.get((Object)type.getKind());
            type.addMissingAnnotations(fnd);
        } else if (!this.typeClasses.isEmpty() && this.typeClasses.containsKey(t = type.getClass())) {
            Set<AnnotationMirror> fnd2 = this.typeClasses.get(t);
            type.addMissingAnnotations(fnd2);
        }
        return (Void)super.scan(type, p);
    }

    @Override
    public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType t, Void p) {
        this.scan(t.getReturnType(), p);
        this.scanAndReduce(t.getParameterTypes(), p, null);
        this.scanAndReduce(t.getThrownTypes(), p, null);
        this.scanAndReduce(t.getTypeVariables(), p, null);
        return null;
    }
}

