/*
 * Decompiled with CFR 0.152.
 */
package checkers.reflection;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.quals.DefaultLocation;
import checkers.reflection.quals.ClassBound;
import checkers.reflection.quals.ClassVal;
import checkers.reflection.quals.MethodVal;
import checkers.reflection.quals.MethodValBottom;
import checkers.reflection.quals.UnknownMethod;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.util.AnnotationBuilder;
import checkers.util.MultiGraphQualifierHierarchy;
import checkers.value.quals.ArrayLen;
import checkers.value.quals.StringVal;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javacutils.AnnotationProvider;
import javacutils.AnnotationUtils;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;

public class MethodValAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror METHODVAL;
    private final AnnotationMirror METHODVAL_BOTTOM;
    private final AnnotationMirror UNKNOWN_METHOD;
    private final ExecutableElement getMethod;
    private final ExecutableElement getDeclaredMethod;
    private final ExecutableElement getConstructor;
    private final AnnotationProvider annotationProvider;

    public MethodValAnnotatedTypeFactory(BaseTypeChecker checker, AnnotationProvider annotationProvider) {
        super(checker);
        this.METHODVAL = AnnotationUtils.fromClass(this.elements, MethodVal.class);
        this.METHODVAL_BOTTOM = AnnotationUtils.fromClass(this.elements, MethodValBottom.class);
        this.UNKNOWN_METHOD = AnnotationUtils.fromClass(this.elements, UnknownMethod.class);
        this.getMethod = TreeUtils.getMethod("java.lang.Class", "getMethod", 2, this.processingEnv);
        this.getDeclaredMethod = TreeUtils.getMethod("java.lang.Class", "getDeclaredMethod", 2, this.processingEnv);
        this.getConstructor = TreeUtils.getMethod("java.lang.Class", "getConstructor", 1, this.processingEnv);
        this.annotationProvider = annotationProvider;
        if (this.getClass().equals(MethodValAnnotatedTypeFactory.class)) {
            this.postInit();
        }
        this.defaults.addAbsoluteDefault(AnnotationUtils.fromClass(this.elements, UnknownMethod.class), DefaultLocation.ALL);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        HashSet<Class<? extends Annotation>> supported = new HashSet<Class<? extends Annotation>>();
        supported.add(MethodVal.class);
        supported.add(MethodValBottom.class);
        supported.add(UnknownMethod.class);
        return supported;
    }

    private AnnotationMirror createMethodVal(List<String> classNames, List<String> methodNames, List<Integer> params) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MethodVal.class.getCanonicalName());
        builder.setValue((CharSequence)"className", classNames);
        builder.setValue((CharSequence)"methodName", methodNames);
        builder.setValue((CharSequence)"params", params);
        return builder.build();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy() {
        MultiGraphQualifierHierarchy.MultiGraphFactory factory = this.createQualifierHierarchyFactory();
        factory.addQualifier(this.METHODVAL_BOTTOM);
        factory.addQualifier(this.METHODVAL);
        factory.addQualifier(this.UNKNOWN_METHOD);
        factory.addSubtype(this.METHODVAL, this.UNKNOWN_METHOD);
        factory.addSubtype(this.METHODVAL_BOTTOM, this.METHODVAL);
        return new MethodValQualifierHierarchy(factory, this.METHODVAL_BOTTOM);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new MethodValTreeAnnotator(this);
    }

    protected class MethodValTreeAnnotator
    extends TreeAnnotator {
        protected MethodValTreeAnnotator(MethodValAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            type.addAnnotation(MethodValAnnotatedTypeFactory.this.UNKNOWN_METHOD);
            return super.visitLiteral(tree, type);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            List<Integer> params;
            List<String> methodNames;
            if (!(TreeUtils.isMethodInvocation(tree, MethodValAnnotatedTypeFactory.this.getMethod, MethodValAnnotatedTypeFactory.this.processingEnv) || TreeUtils.isMethodInvocation(tree, MethodValAnnotatedTypeFactory.this.getDeclaredMethod, MethodValAnnotatedTypeFactory.this.processingEnv) || TreeUtils.isMethodInvocation(tree, MethodValAnnotatedTypeFactory.this.getConstructor, MethodValAnnotatedTypeFactory.this.processingEnv))) {
                return (Void)super.visitMethodInvocation(tree, type);
            }
            List<? extends ExpressionTree> args = tree.getArguments();
            ExpressionTree methodNameArg = tree.getArguments().get(0);
            ExpressionTree classReceiver = TreeUtils.getReceiverTree(tree);
            if (TreeUtils.isMethodInvocation(tree, MethodValAnnotatedTypeFactory.this.getConstructor, MethodValAnnotatedTypeFactory.this.processingEnv)) {
                methodNames = Arrays.asList("<init>");
                params = this.getConstructorParamsLen(tree, args);
            } else {
                methodNames = this.getMethodNames(methodNameArg);
                params = this.getMethodParamsLen(tree, args);
            }
            List<String> classNames = this.getClassNames(classReceiver, TreeUtils.isMethodInvocation(tree, MethodValAnnotatedTypeFactory.this.getConstructor, MethodValAnnotatedTypeFactory.this.processingEnv));
            ArrayList<String> finalMethodNames = new ArrayList<String>();
            ArrayList<String> finalClassNames = new ArrayList<String>();
            ArrayList<Integer> finalParams = new ArrayList<Integer>();
            for (String methodName : methodNames) {
                for (String className : classNames) {
                    for (Integer param : params) {
                        finalMethodNames.add(methodName);
                        finalClassNames.add(className);
                        finalParams.add(param);
                    }
                }
            }
            AnnotationMirror newQual = MethodValAnnotatedTypeFactory.this.createMethodVal(finalClassNames, finalMethodNames, finalParams);
            type.replaceAnnotation(newQual);
            return null;
        }

        private List<Integer> getMethodParamsLen(MethodInvocationTree tree, List<? extends ExpressionTree> args) {
            List<Integer> params = new ArrayList<Integer>();
            ExpressionTree paramsListArg = null;
            if (args.size() == 1 || args.get(1).getKind() == Tree.Kind.NULL_LITERAL) {
                params.add(0);
            } else if (args.size() == 2) {
                paramsListArg = tree.getArguments().get(1);
                AnnotationMirror annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(paramsListArg, ArrayLen.class);
                if (annotation != null) {
                    params = AnnotationUtils.getElementValueArray(annotation, "value", Integer.class, true);
                } else {
                    annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(paramsListArg, ClassVal.class);
                    if (annotation != null) {
                        params.add(1);
                    } else {
                        params.add(-1);
                    }
                }
            } else if (args.size() > 2) {
                boolean allAreClasses = true;
                for (int i = 1; i < args.size() && allAreClasses; ++i) {
                    if (MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(args.get(i), ClassVal.class) != null) continue;
                    allAreClasses = false;
                    break;
                }
                if (allAreClasses) {
                    params.add(args.size() - 1);
                } else {
                    params.add(-1);
                }
            } else {
                params.add(-1);
            }
            return params;
        }

        private List<Integer> getConstructorParamsLen(MethodInvocationTree tree, List<? extends ExpressionTree> args) {
            AnnotationMirror annotation;
            List<Integer> params = new ArrayList<Integer>();
            Tree paramsListArg = null;
            if (args.size() == 1) {
                paramsListArg = tree.getArguments().get(0);
            }
            if (paramsListArg == null || paramsListArg.getKind() == Tree.Kind.NULL_LITERAL) {
                params.add(0);
            } else {
                annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(paramsListArg, ArrayLen.class);
                if (annotation != null) {
                    params = AnnotationUtils.getElementValueArray(annotation, "value", Integer.class, true);
                } else {
                    params.add(0);
                }
            }
            if (params.size() == 0) {
                annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(paramsListArg, ClassVal.class);
                if (annotation != null) {
                    params.add(1);
                } else {
                    params.add(-1);
                }
            }
            return params;
        }

        private List<String> getClassNames(ExpressionTree classReceiver, boolean mustBeExact) {
            List<String> classNames = new ArrayList<String>();
            if (classReceiver.getKind() == Tree.Kind.METHOD_INVOCATION) {
                if (TreeUtils.getReceiverTree(classReceiver) == null) {
                    classNames.add(MethodValAnnotatedTypeFactory.this.visitorState.getClassTree().toString());
                } else if (mustBeExact) {
                    classNames.add("Upper Bound: " + classReceiver.toString());
                } else {
                    classNames.add(InternalUtils.typeOf(TreeUtils.getReceiverTree(classReceiver)).toString());
                }
            } else if (classReceiver.getKind() == Tree.Kind.IDENTIFIER) {
                AnnotationMirror annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(classReceiver, ClassVal.class);
                if (annotation != null) {
                    classNames = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
                } else {
                    annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(classReceiver, ClassBound.class);
                    if (annotation != null) {
                        if (mustBeExact) {
                            classNames.add("Upper Bound: " + classReceiver.toString());
                        } else {
                            classNames = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
                        }
                    } else {
                        classNames.add("Unannotated Class: " + classReceiver.toString());
                    }
                }
            } else if (classReceiver.getKind() == Tree.Kind.MEMBER_SELECT) {
                if ("class".equals(((MemberSelectTree)classReceiver).getIdentifier().toString())) {
                    classNames.add(((MemberSelectTree)classReceiver).getExpression().toString());
                } else assert (false) : "Unknown Member Select call (not '.class')";
            }
            return classNames;
        }

        private List<String> getMethodNames(ExpressionTree arg) {
            ArrayList<String> methodNames = new ArrayList<String>();
            AnnotationMirror annotation = MethodValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(arg, StringVal.class);
            if (annotation != null) {
                methodNames = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
            } else {
                methodNames.add("Unannotated Method: " + arg.toString());
            }
            return methodNames;
        }
    }

    protected class MethodValQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        protected MethodValQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory, AnnotationMirror bottom) {
            super(factory, bottom);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                List<String> a1MethodNames = AnnotationUtils.getElementValueArray(a1, "methodName", String.class, true);
                List<String> a2MethodNames = AnnotationUtils.getElementValueArray(a2, "methodName", String.class, true);
                ArrayList<String> newMethodNames = new ArrayList<String>();
                newMethodNames.addAll(a1MethodNames);
                List<String> a1ClassNames = AnnotationUtils.getElementValueArray(a1, "className", String.class, true);
                List<String> a2ClassNames = AnnotationUtils.getElementValueArray(a2, "className", String.class, true);
                ArrayList<String> newClassNames = new ArrayList<String>();
                newClassNames.addAll(a1ClassNames);
                List<Integer> a1Params = AnnotationUtils.getElementValueArray(a1, "params", Integer.class, true);
                List<Integer> a2Params = AnnotationUtils.getElementValueArray(a2, "params", Integer.class, true);
                ArrayList<Integer> newParams = new ArrayList<Integer>();
                newParams.addAll(a1Params);
                for (int i = 0; i < a2MethodNames.size(); ++i) {
                    if (!newMethodNames.contains(a2MethodNames.get(i))) {
                        newMethodNames.add(a2MethodNames.get(i));
                        newClassNames.add(a2ClassNames.get(i));
                        newParams.add(a2Params.get(i));
                        continue;
                    }
                    if (!newClassNames.contains(a2ClassNames.get(i))) {
                        newMethodNames.add(a2MethodNames.get(i));
                        newClassNames.add(a2ClassNames.get(i));
                        newParams.add(a2Params.get(i));
                        continue;
                    }
                    if (newParams.contains(a2Params.get(i))) continue;
                    newMethodNames.add(a2MethodNames.get(i));
                    newClassNames.add(a2ClassNames.get(i));
                    newParams.add(a2Params.get(i));
                }
                AnnotationMirror result = MethodValAnnotatedTypeFactory.this.createMethodVal(newClassNames, newMethodNames, newParams);
                return result;
            }
            return a1;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, MethodValAnnotatedTypeFactory.this.METHODVAL) && AnnotationUtils.areSameIgnoringValues(rhs, MethodValAnnotatedTypeFactory.this.METHODVAL)) {
                if (AnnotationUtils.areSame(rhs, lhs)) {
                    lhs = MethodValAnnotatedTypeFactory.this.METHODVAL;
                    rhs = MethodValAnnotatedTypeFactory.this.METHODVAL;
                    return true;
                }
                List<String> lhsMethodNames = AnnotationUtils.getElementValueArray(lhs, "methodName", String.class, true);
                List<String> rhsMethodNames = AnnotationUtils.getElementValueArray(rhs, "methodName", String.class, true);
                List<String> lhsClassNames = AnnotationUtils.getElementValueArray(lhs, "className", String.class, true);
                List<String> rhsClassNames = AnnotationUtils.getElementValueArray(rhs, "className", String.class, true);
                List<Integer> lhsParams = AnnotationUtils.getElementValueArray(lhs, "params", Integer.class, true);
                List<Integer> rhsParams = AnnotationUtils.getElementValueArray(rhs, "params", Integer.class, true);
                assert (lhsMethodNames.size() == lhsClassNames.size() && lhsMethodNames.size() == lhsParams.size()) : "Method, Class, and Param annotations are of differing lengths";
                assert (rhsMethodNames.size() == rhsClassNames.size() && rhsMethodNames.size() == rhsParams.size()) : "Method, Class, and Param annotations are of differing lengths";
                boolean matching = true;
                for (int i = 0; i < rhsMethodNames.size() && matching; ++i) {
                    int lhsIndex = lhsMethodNames.indexOf(rhsMethodNames.get(i));
                    matching = lhsIndex >= 0 ? lhsClassNames.get(lhsIndex).equals(rhsClassNames.get(i)) && lhsParams.get(lhsIndex).equals(rhsParams.get(i)) : false;
                }
                return matching;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, MethodValAnnotatedTypeFactory.this.METHODVAL)) {
                lhs = MethodValAnnotatedTypeFactory.this.METHODVAL;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, MethodValAnnotatedTypeFactory.this.METHODVAL)) {
                rhs = MethodValAnnotatedTypeFactory.this.METHODVAL;
            }
            return super.isSubtype(rhs, lhs);
        }
    }
}

