/*
 * Decompiled with CFR 0.152.
 */
package checkers.reflection;

import checkers.reflection.ReflectionResolver;
import checkers.reflection.quals.MethodVal;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import javacutils.AnnotationProvider;
import javacutils.AnnotationUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public class DefaultReflectionResolver
implements ReflectionResolver {
    public static final String MSG_PREFEX_REFLECTION = "[Reflection] ";
    private final AnnotationProvider provider;
    private final ProcessingEnvironment processingEnv;
    private final Trees trees;
    private final boolean debug;
    private final ExecutableElement invoke;
    private final ExecutableElement newInstance;

    public DefaultReflectionResolver(AnnotationProvider provider, boolean debug, ProcessingEnvironment processingEnv) {
        this.provider = provider;
        this.processingEnv = processingEnv;
        this.trees = Trees.instance(processingEnv);
        this.debug = debug;
        this.invoke = TreeUtils.getMethod("java.lang.reflect.Method", "invoke", 2, processingEnv);
        this.newInstance = TreeUtils.getMethod("java.lang.reflect.Constructor", "newInstance", 1, processingEnv);
    }

    @Override
    public boolean shouldResolveReflection(MethodInvocationTree tree) {
        return (TreeUtils.isMethodInvocation(tree, this.invoke, this.processingEnv) || TreeUtils.isMethodInvocation(tree, this.newInstance, this.processingEnv)) && this.provider.getAnnotationMirror(TreeUtils.getReceiverTree(tree), MethodVal.class) != null;
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> resolveReflectiveCall(AnnotatedTypeFactory factory, MethodInvocationTree tree, Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> origResult) {
        assert (this.shouldResolveReflection(tree));
        if (TreeUtils.isMethodInvocation(tree, this.newInstance, this.processingEnv)) {
            return this.resolveConstructorCall(factory, tree, origResult);
        }
        AnnotationMirror estimate = this.provider.getAnnotationMirror(TreeUtils.getReceiverTree(tree), MethodVal.class);
        java.util.List<String> listMethodNames = AnnotationUtils.getElementValueArray(estimate, "methodName", String.class, true);
        if ("<init>".equals(listMethodNames.get(0))) {
            return this.resolveConstructorCall(factory, tree, origResult);
        }
        return this.resolveMethodCall(factory, tree, origResult);
    }

    private Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> resolveMethodCall(AnnotatedTypeFactory factory, MethodInvocationTree tree, Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> origResult) {
        this.debugReflection("Try to resolve reflective method call: " + tree);
        java.util.List<MethodInvocationTree> possibleMethods = this.resolveReflectiveMethod(tree, factory);
        if (possibleMethods.size() == 0) {
            return origResult;
        }
        Set<? extends AnnotationMirror> returnLub = null;
        Set<? extends AnnotationMirror> receiverGlb = null;
        Set<? extends AnnotationMirror> paramsGlb = null;
        for (MethodInvocationTree resolvedTree : possibleMethods) {
            this.debugReflection("Resolved method invocation: " + resolvedTree);
            Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> resolvedResult = factory.methodFromUse(resolvedTree);
            returnLub = this.lub(returnLub, ((AnnotatedTypeMirror.AnnotatedExecutableType)resolvedResult.first).getReturnType().getAnnotations(), factory);
            receiverGlb = ((AnnotatedTypeMirror.AnnotatedExecutableType)resolvedResult.first).getReceiverType() == null ? this.glb(receiverGlb, factory.getQualifierHierarchy().getBottomAnnotations(), factory) : this.glb(receiverGlb, ((AnnotatedTypeMirror.AnnotatedExecutableType)resolvedResult.first).getReceiverType().getAnnotations(), factory);
            for (AnnotatedTypeMirror mirror : ((AnnotatedTypeMirror.AnnotatedExecutableType)resolvedResult.first).getParameterTypes()) {
                paramsGlb = this.glb(paramsGlb, mirror.getAnnotations(), factory);
            }
        }
        ((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getReturnType().clearAnnotations();
        ((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getReturnType().addAnnotations(returnLub);
        ((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getParameterTypes().get(0).clearAnnotations();
        ((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getParameterTypes().get(0).addAnnotations(receiverGlb);
        if (paramsGlb != null) {
            AnnotatedTypeMirror.AnnotatedArrayType origArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getParameterTypes().get(1);
            origArrayType.getComponentType().clearAnnotations();
            origArrayType.getComponentType().addAnnotations(paramsGlb);
        }
        this.debugReflection("Resolved annotations: " + origResult.first);
        return origResult;
    }

    private Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> resolveConstructorCall(AnnotatedTypeFactory factory, MethodInvocationTree tree, Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> origResult) {
        this.debugReflection("Try to resolve reflective constructor call: " + tree);
        java.util.List<JCTree.JCNewClass> possibleConstructors = this.resolveReflectiveConstructor(tree, factory);
        if (possibleConstructors.size() == 0) {
            return origResult;
        }
        Set<? extends AnnotationMirror> returnLub = null;
        Set<? extends AnnotationMirror> paramsGlb = null;
        for (JCTree.JCNewClass resolvedTree : possibleConstructors) {
            this.debugReflection("Resolved constructor invocation: " + resolvedTree);
            Pair<AnnotatedTypeMirror.AnnotatedExecutableType, java.util.List<AnnotatedTypeMirror>> resolvedResult = factory.constructorFromUse(resolvedTree);
            returnLub = this.lub(returnLub, ((AnnotatedTypeMirror.AnnotatedExecutableType)resolvedResult.first).getReturnType().getAnnotations(), factory);
            for (AnnotatedTypeMirror mirror : ((AnnotatedTypeMirror.AnnotatedExecutableType)resolvedResult.first).getParameterTypes()) {
                paramsGlb = this.glb(paramsGlb, mirror.getAnnotations(), factory);
            }
        }
        ((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getReturnType().clearAnnotations();
        ((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getReturnType().addAnnotations(returnLub);
        if (paramsGlb != null) {
            AnnotatedTypeMirror.AnnotatedArrayType origArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)((AnnotatedTypeMirror.AnnotatedExecutableType)origResult.first).getParameterTypes().get(0);
            origArrayType.getComponentType().clearAnnotations();
            origArrayType.getComponentType().addAnnotations(paramsGlb);
        }
        this.debugReflection("Resolved annotations: " + origResult.first);
        return origResult;
    }

    private java.util.List<MethodInvocationTree> resolveReflectiveMethod(MethodInvocationTree tree, AnnotatedTypeFactory reflectionFactory) {
        assert (this.shouldResolveReflection(tree));
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
        ArrayList<MethodInvocationTree> methods = new ArrayList<MethodInvocationTree>();
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker make = TreeMaker.instance(context);
        TreePath path = reflectionFactory.getPath(tree);
        JavacScope scope = (JavacScope)this.trees.getScope(path);
        Env<AttrContext> env = scope.getEnv();
        AnnotationMirror estimate = this.provider.getAnnotationMirror(TreeUtils.getReceiverTree(tree), MethodVal.class);
        this.debugReflection("MethodVal type system annotations: " + estimate);
        java.util.List<String> listClassNames = AnnotationUtils.getElementValueArray(estimate, "className", String.class, true);
        java.util.List<String> listMethodNames = AnnotationUtils.getElementValueArray(estimate, "methodName", String.class, true);
        java.util.List<Integer> listParamLenghts = AnnotationUtils.getElementValueArray(estimate, "params", Integer.class, true);
        assert (listClassNames.size() == listMethodNames.size() && listClassNames.size() == listParamLenghts.size());
        for (int i = 0; i < listClassNames.size(); ++i) {
            String className = listClassNames.get(i);
            String methodName = listMethodNames.get(i);
            int paramLength = listParamLenghts.get(i);
            JCTree.JCExpression receiver = (JCTree.JCExpression)methodInvocation.args.head;
            List<JCTree.JCExpression> args = methodInvocation.args.tail;
            for (Symbol symbol : this.getMethodSymbolsfor(className, methodName, paramLength, env)) {
                this.debugReflection("Resolved method: " + symbol.owner + "." + symbol);
                JCTree.JCExpression method = make.Select(receiver, symbol);
                JCTree.JCMethodInvocation syntTree = paramLength > 0 ? make.App(method, args) : make.App(method);
                methods.add(syntTree);
            }
        }
        return methods;
    }

    private java.util.List<JCTree.JCNewClass> resolveReflectiveConstructor(MethodInvocationTree tree, AnnotatedTypeFactory reflectionFactory) {
        assert (this.shouldResolveReflection(tree));
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker make = TreeMaker.instance(context);
        TreePath path = reflectionFactory.getPath(tree);
        JavacScope scope = (JavacScope)this.trees.getScope(path);
        Env<AttrContext> env = scope.getEnv();
        AnnotationMirror estimate = this.provider.getAnnotationMirror(TreeUtils.getReceiverTree(tree), MethodVal.class);
        this.debugReflection("MethodVal type system annotations: " + estimate);
        java.util.List<String> listClassNames = AnnotationUtils.getElementValueArray(estimate, "className", String.class, true);
        java.util.List<Integer> listParamLenghts = AnnotationUtils.getElementValueArray(estimate, "params", Integer.class, true);
        ArrayList<JCTree.JCNewClass> constructors = new ArrayList<JCTree.JCNewClass>();
        assert (listClassNames.size() == listParamLenghts.size());
        for (int i = 0; i < listClassNames.size(); ++i) {
            String className = listClassNames.get(i);
            int paramLength = listParamLenghts.get(i);
            for (Symbol symbol : this.getConstructorSymbolsfor(className, paramLength, env)) {
                this.debugReflection("Resolved constructor: " + symbol.owner + "." + symbol);
                JCTree.JCNewClass syntTree = (JCTree.JCNewClass)make.Create(symbol, methodInvocation.args);
                constructors.add(syntTree);
            }
        }
        return constructors;
    }

    private java.util.List<Symbol> getMethodSymbolsfor(String className, String methodName, int paramLength, Env<AttrContext> env) {
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Resolve resolve = Resolve.instance(context);
        Names names = Names.instance(context);
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        try {
            Method loadClass = Resolve.class.getDeclaredMethod("loadClass", Env.class, Name.class);
            loadClass.setAccessible(true);
            Symbol sym = (Symbol)loadClass.invoke((Object)resolve, env, names.fromString(className));
            if (!sym.exists()) {
                this.debugReflection("Unable to resolve class: " + className);
                return Collections.emptyList();
            }
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)sym;
            while (classSym != null) {
                Type t;
                for (Symbol s2 : classSym.getEnclosedElements()) {
                    if (s2.getKind() != ElementKind.METHOD || !names.fromString(methodName).equals(s2.name) || ((List)((Symbol.MethodSymbol)s2).getParameters()).size() != paramLength) continue;
                    result.add(s2);
                }
                if (result.size() != 0 || !(t = classSym.getSuperclass()).hasTag(TypeTag.CLASS) || t.isErroneous()) break;
                classSym = (Symbol.ClassSymbol)t.tsym;
            }
            if (result.size() == 0) {
                this.debugReflection("Unable to resolve method: " + methodName);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.debugReflection("Exception during resolution of reflective method: " + e.getMessage());
            return Collections.emptyList();
        }
        return result;
    }

    private java.util.List<Symbol> getConstructorSymbolsfor(String className, int paramLength, Env<AttrContext> env) {
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Resolve resolve = Resolve.instance(context);
        Names names = Names.instance(context);
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        try {
            Method loadClass = Resolve.class.getDeclaredMethod("loadClass", Env.class, Name.class);
            loadClass.setAccessible(true);
            Symbol symClass = (Symbol)loadClass.invoke((Object)resolve, env, names.fromString(className));
            if (!symClass.exists()) {
                this.debugReflection("Unable to resolve class: " + className);
                return Collections.emptyList();
            }
            ElementFilter.constructorsIn(symClass.getEnclosedElements());
            for (Symbol s2 : symClass.getEnclosedElements()) {
                if (s2.getKind() != ElementKind.CONSTRUCTOR || ((List)((Symbol.MethodSymbol)s2).getParameters()).size() != paramLength) continue;
                result.add(s2);
            }
            if (result.size() == 0) {
                this.debugReflection("Unable to resolve constructor!");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.debugReflection("Exception during resolution of reflective constructor: " + e.getMessage());
            return Collections.emptyList();
        }
        return result;
    }

    private Set<? extends AnnotationMirror> lub(Set<? extends AnnotationMirror> set1, Set<? extends AnnotationMirror> set2, AnnotatedTypeFactory factory) {
        if (set1 == null || set1.size() == 0) {
            return set2;
        }
        return factory.getQualifierHierarchy().greatestLowerBounds(set1, set2);
    }

    private Set<? extends AnnotationMirror> glb(Set<? extends AnnotationMirror> set1, Set<? extends AnnotationMirror> set2, AnnotatedTypeFactory factory) {
        if (set1 == null || set1.size() == 0) {
            return set2;
        }
        return factory.getQualifierHierarchy().greatestLowerBounds(set1, set2);
    }

    private void debugReflection(String msg) {
        if (this.debug) {
            if (this.processingEnv.getMessager() != null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, MSG_PREFEX_REFLECTION + msg);
            } else {
                System.err.println(MSG_PREFEX_REFLECTION + msg);
            }
        }
    }
}

