/*
 * Decompiled with CFR 0.152.
 */
package checkers.reflection;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.quals.DefaultLocation;
import checkers.quals.TypeQualifiers;
import checkers.reflection.quals.ClassBound;
import checkers.reflection.quals.ClassVal;
import checkers.reflection.quals.ClassValBottom;
import checkers.reflection.quals.UnknownClass;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.util.AnnotationBuilder;
import checkers.util.MultiGraphQualifierHierarchy;
import checkers.value.quals.StringVal;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javacutils.AnnotationProvider;
import javacutils.AnnotationUtils;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;

@TypeQualifiers(value={UnknownClass.class, ClassVal.class, ClassBound.class, ClassValBottom.class})
public class ClassValAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror CLASSVAL;
    private final AnnotationMirror CLASSBOUND;
    private final AnnotationMirror CLASSVAL_BOTTOM;
    private final AnnotationMirror UNKNOWN_CLASS;
    private final ExecutableElement forName;
    private final ExecutableElement loadClass;
    private final ExecutableElement getClass;
    private final AnnotationProvider annotationProvider;

    public ClassValAnnotatedTypeFactory(BaseTypeChecker checker, AnnotationProvider annotationProvider) {
        super(checker);
        this.CLASSVAL = AnnotationUtils.fromClass(this.elements, ClassVal.class);
        this.CLASSBOUND = AnnotationUtils.fromClass(this.elements, ClassBound.class);
        this.CLASSVAL_BOTTOM = AnnotationUtils.fromClass(this.elements, ClassValBottom.class);
        this.UNKNOWN_CLASS = AnnotationUtils.fromClass(this.elements, UnknownClass.class);
        this.forName = TreeUtils.getMethod("java.lang.Class", "forName", 1, this.processingEnv);
        this.loadClass = TreeUtils.getMethod("java.lang.ClassLoader", "loadClass", 1, this.processingEnv);
        this.getClass = TreeUtils.getMethod("java.lang.Object", "getClass", 0, this.processingEnv);
        this.annotationProvider = annotationProvider;
        if (this.getClass().equals(ClassValAnnotatedTypeFactory.class)) {
            this.postInit();
        }
        this.defaults.addAbsoluteDefault(AnnotationUtils.fromClass(this.elements, UnknownClass.class), DefaultLocation.ALL);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ClassValTreeAnnotator(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy() {
        MultiGraphQualifierHierarchy.MultiGraphFactory factory = this.createQualifierHierarchyFactory();
        factory.addQualifier(this.CLASSVAL_BOTTOM);
        factory.addQualifier(this.CLASSVAL);
        factory.addQualifier(this.CLASSBOUND);
        factory.addQualifier(this.UNKNOWN_CLASS);
        factory.addSubtype(this.CLASSVAL, this.UNKNOWN_CLASS);
        factory.addSubtype(this.CLASSVAL_BOTTOM, this.CLASSVAL);
        factory.addSubtype(this.CLASSBOUND, this.UNKNOWN_CLASS);
        factory.addSubtype(this.CLASSVAL_BOTTOM, this.CLASSBOUND);
        return new ClassValQualifierHierarchy(factory, this.CLASSVAL_BOTTOM);
    }

    private AnnotationMirror createClassVal(List<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ClassVal.class.getCanonicalName());
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    private AnnotationMirror createClassBound(List<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, ClassBound.class.getCanonicalName());
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    protected class ClassValTreeAnnotator
    extends TreeAnnotator {
        protected ClassValTreeAnnotator(ClassValAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            if ("class".equals(tree.getIdentifier().toString()) && TreeUtils.getReceiverTree(tree) != null) {
                Type clType = (Type)InternalUtils.typeOf(TreeUtils.getReceiverTree(tree));
                String className = this.getClassname(clType);
                AnnotationMirror newQual = ClassValAnnotatedTypeFactory.this.createClassVal(Arrays.asList(className));
                type.replaceAnnotation(newQual);
                return null;
            }
            return (Void)super.visitMemberSelect(tree, type);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            type.addAnnotation(ClassValAnnotatedTypeFactory.this.UNKNOWN_CLASS);
            return super.visitLiteral(tree, type);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isMethodInvocation(tree, ClassValAnnotatedTypeFactory.this.forName, ClassValAnnotatedTypeFactory.this.processingEnv) || TreeUtils.isMethodInvocation(tree, ClassValAnnotatedTypeFactory.this.loadClass, ClassValAnnotatedTypeFactory.this.processingEnv)) {
                ExpressionTree arg = tree.getArguments().get(0);
                AnnotationMirror annotation = ClassValAnnotatedTypeFactory.this.annotationProvider.getAnnotationMirror(arg, StringVal.class);
                if (annotation != null) {
                    List<String> argValues = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
                    AnnotationMirror newQual = ClassValAnnotatedTypeFactory.this.createClassVal(argValues);
                    type.replaceAnnotation(newQual);
                    return null;
                }
            } else if (TreeUtils.isMethodInvocation(tree, ClassValAnnotatedTypeFactory.this.getClass, ClassValAnnotatedTypeFactory.this.processingEnv)) {
                if (TreeUtils.getReceiverTree(tree) != null) {
                    Type clType = (Type)InternalUtils.typeOf(TreeUtils.getReceiverTree(tree));
                    String className = this.getClassname(clType);
                    AnnotationMirror newQual = ClassValAnnotatedTypeFactory.this.createClassBound(Arrays.asList(className));
                    type.replaceAnnotation(newQual);
                }
                return null;
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        private String getClassname(Type classType) {
            StringBuilder className = new StringBuilder(classType.tsym.name);
            if (classType.getEnclosingType() == null) {
                return "No class name found! ClassValAnnotatedTypeFactory.java::266";
            }
            while (classType.getEnclosingType().getKind() != TypeKind.NONE) {
                classType = classType.getEnclosingType();
                className.insert(0, classType.tsym.name.toString() + "$");
            }
            return className.toString();
        }
    }

    protected class ClassValQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        protected ClassValQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory, AnnotationMirror bottom) {
            super(factory, bottom);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                List<String> a1Values = AnnotationUtils.getElementValueArray(a1, "value", String.class, true);
                List<String> a2Values = AnnotationUtils.getElementValueArray(a2, "value", String.class, true);
                ArrayList<String> newValues = new ArrayList<String>();
                for (String s2 : a1Values) {
                    if (newValues.contains(s2)) continue;
                    newValues.add(s2);
                }
                for (String s2 : a2Values) {
                    if (newValues.contains(s2)) continue;
                    newValues.add(s2);
                }
                AnnotationMirror result = ClassValAnnotatedTypeFactory.this.createClassVal(newValues);
                return result;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, ClassValAnnotatedTypeFactory.this.CLASSBOUND) && AnnotationUtils.areSameIgnoringValues(a2, ClassValAnnotatedTypeFactory.this.CLASSVAL)) {
                List<String> a1Values = AnnotationUtils.getElementValueArray(a1, "value", String.class, true);
                List<String> a2Values = AnnotationUtils.getElementValueArray(a2, "value", String.class, true);
                ArrayList<String> newValues = new ArrayList<String>();
                for (String s3 : a1Values) {
                    if (newValues.contains(s3)) continue;
                    newValues.add(s3);
                }
                for (String s3 : a2Values) {
                    if (newValues.contains(s3)) continue;
                    newValues.add(s3);
                }
                AnnotationMirror result = ClassValAnnotatedTypeFactory.this.createClassBound(newValues);
                return result;
            }
            return a1;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, ClassValAnnotatedTypeFactory.this.CLASSVAL) && AnnotationUtils.areSameIgnoringValues(rhs, ClassValAnnotatedTypeFactory.this.CLASSVAL)) {
                if (AnnotationUtils.areSame(rhs, lhs)) {
                    lhs = ClassValAnnotatedTypeFactory.this.CLASSVAL;
                    rhs = ClassValAnnotatedTypeFactory.this.CLASSVAL;
                    return true;
                }
                List<String> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", String.class, true);
                List<String> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", String.class, true);
                return lhsValues.containsAll(rhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, ClassValAnnotatedTypeFactory.this.CLASSBOUND) && AnnotationUtils.areSameIgnoringValues(rhs, ClassValAnnotatedTypeFactory.this.CLASSVAL)) {
                if (AnnotationUtils.areSame(rhs, lhs)) {
                    return true;
                }
                List<String> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", String.class, true);
                List<String> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", String.class, true);
                return lhsValues.containsAll(rhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, ClassValAnnotatedTypeFactory.this.CLASSBOUND) && AnnotationUtils.areSameIgnoringValues(rhs, ClassValAnnotatedTypeFactory.this.CLASSBOUND)) {
                if (AnnotationUtils.areSame(rhs, lhs)) {
                    return true;
                }
                List<String> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", String.class, true);
                List<String> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", String.class, true);
                return lhsValues.containsAll(rhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, ClassValAnnotatedTypeFactory.this.CLASSVAL)) {
                lhs = ClassValAnnotatedTypeFactory.this.CLASSVAL;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, ClassValAnnotatedTypeFactory.this.CLASSVAL)) {
                rhs = ClassValAnnotatedTypeFactory.this.CLASSVAL;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, ClassValAnnotatedTypeFactory.this.CLASSBOUND)) {
                lhs = ClassValAnnotatedTypeFactory.this.CLASSBOUND;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, ClassValAnnotatedTypeFactory.this.CLASSBOUND)) {
                rhs = ClassValAnnotatedTypeFactory.this.CLASSBOUND;
            }
            return super.isSubtype(rhs, lhs);
        }
    }
}

