/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.nullness.quals.EnsuresNonNull;
import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.Nullable;

public final class NullnessUtils {
    private NullnessUtils() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr) {
        return NullnessUtils.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr) {
        return (Object[][])NullnessUtils.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][])NullnessUtils.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][])NullnessUtils.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][][])NullnessUtils.castNonNullArray(arr);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] arr) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument";
        for (int i = 0; i < arr.length; ++i) {
            assert (arr[i] != null) : "Misuse of castNonNull: called with a null array element";
            NullnessUtils.checkIfArray(arr[i]);
        }
        return arr;
    }

    private static void checkIfArray(@NonNull Object ref) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument";
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtils.castNonNullArray((Object[])ref);
        }
    }
}

