/*
 * Decompiled with CFR 0.152.
 */
package checkers.interning;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.interning.quals.Interned;
import checkers.interning.quals.UnknownInterned;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public class InterningAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    final AnnotationMirror INTERNED;
    final AnnotationMirror TOP;

    public InterningAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.INTERNED = AnnotationUtils.fromClass(this.elements, Interned.class);
        this.TOP = AnnotationUtils.fromClass(this.elements, UnknownInterned.class);
        this.addAliasedAnnotation(com.sun.istack.Interned.class, this.INTERNED);
        this.postInit();
        this.typeAnnotator.addTypeName(Void.class, this.INTERNED);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new InterningTreeAnnotator(this);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new InterningTypeAnnotator(this);
    }

    @Override
    public void annotateImplicit(Element element, AnnotatedTypeMirror type) {
        if (!type.isAnnotatedInHierarchy(this.INTERNED) && ElementUtils.isCompileTimeConstant(element)) {
            type.addAnnotation(this.INTERNED);
        }
        super.annotateImplicit(element, type);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType primitive = super.getUnboxedType(type);
        primitive.replaceAnnotation(this.INTERNED);
        return primitive;
    }

    private class InterningTypeAnnotator
    extends TypeAnnotator {
        InterningTypeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType t, Void p) {
            Element elt = t.getUnderlyingType().asElement();
            assert (elt != null);
            if (elt.getKind() == ElementKind.ENUM) {
                t.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else if (InterningAnnotatedTypeFactory.this.fromElement(elt).hasAnnotation(InterningAnnotatedTypeFactory.this.INTERNED)) {
                t.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            }
            return (Void)super.visitDeclared(t, p);
        }
    }

    private class InterningTreeAnnotator
    extends TreeAnnotator {
        InterningTreeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            if (TreeUtils.isCompileTimeString(node)) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else if (TreeUtils.isStringConcatenation(node)) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            } else if (type.getKind().isPrimitive() || node.getKind() == Tree.Kind.EQUAL_TO || node.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            }
            return super.visitBinary(node, type);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            return super.visitCompoundAssignment(node, type);
        }
    }
}

