/*
 * Decompiled with CFR 0.152.
 */
package checkers.guieffects;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import checkers.guieffects.Effect;
import checkers.guieffects.quals.AlwaysSafe;
import checkers.guieffects.quals.PolyUI;
import checkers.guieffects.quals.PolyUIEffect;
import checkers.guieffects.quals.PolyUIType;
import checkers.guieffects.quals.SafeEffect;
import checkers.guieffects.quals.SafeType;
import checkers.guieffects.quals.UI;
import checkers.guieffects.quals.UIEffect;
import checkers.guieffects.quals.UIPackage;
import checkers.guieffects.quals.UIType;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javacutils.ElementUtils;
import javacutils.TypesUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class GUIEffectsTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final boolean debugSpew;

    public GUIEffectsTypeFactory(BaseTypeChecker checker, boolean spew) {
        super(checker, false);
        this.debugSpew = spew;
        this.postInit();
    }

    public ExecutableElement findJavaOverride(ExecutableElement overrider, TypeMirror parentType) {
        if (parentType.getKind() != TypeKind.NONE) {
            if (this.debugSpew) {
                System.err.println("Searching for overridden methods from " + parentType);
            }
            TypeElement overriderClass = (TypeElement)overrider.getEnclosingElement();
            TypeElement elem = (TypeElement)((DeclaredType)parentType).asElement();
            if (this.debugSpew) {
                System.err.println("necessary TypeElements acquired: " + elem);
            }
            for (Element element : elem.getEnclosedElements()) {
                ExecutableElement ex;
                boolean overrides;
                if (this.debugSpew) {
                    System.err.println("Considering element " + element);
                }
                if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR || !(overrides = this.elements.overrides(overrider, ex = (ExecutableElement)element, overriderClass))) continue;
                return ex;
            }
            if (this.debugSpew) {
                System.err.println("Done considering elements of " + parentType);
            }
        }
        return null;
    }

    public boolean isPolymorphicType(TypeElement cls) {
        assert (cls != null);
        return this.getDeclAnnotation(cls, PolyUIType.class) != null || this.fromElement(cls).hasAnnotation(PolyUI.class);
    }

    public boolean isUIType(TypeElement cls) {
        boolean hasUITypeDirectly;
        if (this.debugSpew) {
            System.err.println(" isUIType(" + cls + ")");
        }
        boolean targetClassUIP = this.fromElement(cls).hasAnnotation(UI.class);
        AnnotationMirror targetClassUITypeP = this.getDeclAnnotation(cls, UIType.class);
        AnnotationMirror targetClassSafeTypeP = this.getDeclAnnotation(cls, SafeType.class);
        if (targetClassSafeTypeP != null) {
            return false;
        }
        boolean bl = hasUITypeDirectly = targetClassUIP || targetClassUITypeP != null;
        if (hasUITypeDirectly) {
            return true;
        }
        if (GUIEffectsTypeFactory.isAnonymousType(cls)) {
            return false;
        }
        boolean targetClassSafeP = this.fromElement(cls).hasAnnotation(AlwaysSafe.class);
        if (targetClassSafeP) {
            return false;
        }
        PackageElement packageP = ElementUtils.enclosingPackage(cls);
        if (packageP != null) {
            if (this.debugSpew) {
                System.err.println("Found package " + packageP);
            }
            if (this.getDeclAnnotation(packageP, UIPackage.class) != null) {
                if (this.debugSpew) {
                    System.err.println("Package " + packageP + " is annotated @UIPackage");
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isAnonymousType(TypeElement elem) {
        return elem.getSimpleName().length() == 0;
    }

    public Effect getDeclaredEffect(ExecutableElement methodElt) {
        if (this.debugSpew) {
            System.err.println("begin mayHaveUIEffect(" + methodElt + ")");
        }
        AnnotationMirror targetUIP = this.getDeclAnnotation(methodElt, UIEffect.class);
        AnnotationMirror targetSafeP = this.getDeclAnnotation(methodElt, SafeEffect.class);
        AnnotationMirror targetPolyP = this.getDeclAnnotation(methodElt, PolyUIEffect.class);
        TypeElement targetClassElt = (TypeElement)methodElt.getEnclosingElement();
        if (this.debugSpew) {
            System.err.println("targetClassElt found");
        }
        if (targetSafeP != null) {
            if (this.debugSpew) {
                System.err.println("Method marked @SafeEffect");
            }
            return new Effect(SafeEffect.class);
        }
        if (targetUIP != null) {
            if (this.debugSpew) {
                System.err.println("Method marked @UIEffect");
            }
            return new Effect(UIEffect.class);
        }
        if (targetPolyP != null) {
            if (this.debugSpew) {
                System.err.println("Method marked @PolyUIEffect");
            }
            return new Effect(PolyUIEffect.class);
        }
        if (this.isUIType(targetClassElt)) {
            return new Effect(UIEffect.class);
        }
        if (GUIEffectsTypeFactory.isAnonymousType(targetClassElt)) {
            boolean canInheritParentEffects = true;
            DeclaredType directSuper = (DeclaredType)targetClassElt.getSuperclass();
            TypeElement superElt = (TypeElement)directSuper.asElement();
            if (this.getDeclAnnotation(superElt, PolyUIType.class) != null && !TypesUtils.isObject(directSuper)) {
                canInheritParentEffects = false;
            } else {
                for (TypeMirror typeMirror : targetClassElt.getInterfaces()) {
                    DeclaredType iface = (DeclaredType)typeMirror;
                    TypeElement ifaceElt = (TypeElement)iface.asElement();
                    if (this.getDeclAnnotation(ifaceElt, PolyUIType.class) == null) continue;
                    canInheritParentEffects = false;
                }
            }
            if (canInheritParentEffects) {
                Effect.EffectRange r = this.findInheritedEffectRange(targetClassElt, methodElt);
                return r != null ? Effect.min(r.min, r.max) : new Effect(SafeEffect.class);
            }
        }
        return new Effect(SafeEffect.class);
    }

    public Effect.EffectRange findInheritedEffectRange(TypeElement declaringType, ExecutableElement overridingMethod) {
        return this.findInheritedEffectRange(declaringType, overridingMethod, false, null);
    }

    public Effect.EffectRange findInheritedEffectRange(TypeElement declaringType, ExecutableElement overridingMethod, boolean issueConflictWarning, Tree errorNode) {
        Effect max;
        Effect min2;
        assert (declaringType != null);
        ExecutableElement ui_override = null;
        ExecutableElement safe_override = null;
        ExecutableElement poly_override = null;
        boolean isUI = (this.getDeclAnnotation(overridingMethod, UIEffect.class) != null || this.isUIType(declaringType)) && this.getDeclAnnotation(overridingMethod, SafeEffect.class) == null;
        boolean isPolyUI = this.getDeclAnnotation(overridingMethod, PolyUIEffect.class) != null;
        TypeMirror superclass = declaringType.getSuperclass();
        while (superclass != null && superclass.getKind() != TypeKind.NONE) {
            ExecutableElement overrides = this.findJavaOverride(overridingMethod, superclass);
            if (overrides != null) {
                Effect eff = this.getDeclaredEffect(overrides);
                assert (eff != null);
                if (eff.isSafe()) {
                    safe_override = overrides;
                    if (isUI && issueConflictWarning) {
                        this.checker.report(Result.failure("conflicts.override", superclass + "." + safe_override), errorNode);
                    }
                    if (isPolyUI && issueConflictWarning) {
                        this.checker.report(Result.failure("conflicts.override.polymorphic", superclass + "." + safe_override), errorNode);
                    }
                } else if (eff.isUI()) {
                    ui_override = overrides;
                } else {
                    assert (eff.isPoly());
                    poly_override = overrides;
                }
            }
            DeclaredType decl = (DeclaredType)superclass;
            superclass = ((TypeElement)decl.asElement()).getSuperclass();
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType annoDecl = this.fromElement(declaringType);
        for (AnnotatedTypeMirror.AnnotatedDeclaredType ty : annoDecl.directSuperTypes()) {
            ExecutableElement overrides = this.findJavaOverride(overridingMethod, ty.getUnderlyingType());
            if (overrides == null) continue;
            Effect eff = this.getDeclaredEffect(overrides);
            if (eff.isSafe()) {
                safe_override = overrides;
                if (isUI && issueConflictWarning) {
                    this.checker.report(Result.failure("conflicts.override", ty + "." + safe_override), errorNode);
                }
                if (!isPolyUI || !issueConflictWarning) continue;
                this.checker.report(Result.failure("conflicts.override.polymorphic", ty + "." + safe_override), errorNode);
                continue;
            }
            if (eff.isUI()) {
                ui_override = overrides;
                continue;
            }
            assert (eff.isPoly());
            poly_override = overrides;
            if (!isUI || !issueConflictWarning) continue;
            AnnotatedTypeMirror.AnnotatedDeclaredType supdecl = ty;
            boolean isAnonInstantiation = GUIEffectsTypeFactory.isAnonymousType(declaringType) && this.fromElement(declaringType).hasAnnotation(UI.class);
            if (isAnonInstantiation || supdecl.hasAnnotation(UI.class)) continue;
            this.checker.report(Result.failure("conflicts.override", "non-UI instantiation of " + supdecl), errorNode);
        }
        if (ui_override != null && safe_override != null && issueConflictWarning) {
            this.checker.report(Result.warning("conflicts.inheritance", ui_override.getEnclosingElement().asType().toString() + "." + ui_override.toString(), safe_override.getEnclosingElement().asType().toString() + "." + safe_override.toString()), errorNode);
        }
        Effect effect = safe_override != null ? new Effect(SafeEffect.class) : (poly_override != null ? new Effect(PolyUIEffect.class) : (min2 = ui_override != null ? new Effect(UIEffect.class) : null));
        Effect effect2 = ui_override != null ? new Effect(UIEffect.class) : (poly_override != null ? new Effect(PolyUIEffect.class) : (max = safe_override != null ? new Effect(SafeEffect.class) : null));
        if (this.debugSpew) {
            System.err.println("Found " + declaringType + "." + overridingMethod + " to have inheritance pair (" + min2 + "," + max + ")");
        }
        if (min2 == null && max == null) {
            return null;
        }
        return new Effect.EffectRange(min2, max);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new GUIEffectsTreeAnnotator();
    }

    private class GUIEffectsTreeAnnotator
    extends TreeAnnotator {
        GUIEffectsTreeAnnotator() {
            super(GUIEffectsTypeFactory.this);
        }

        public boolean hasExplicitUIEffect(ExecutableElement methElt) {
            return GUIEffectsTypeFactory.this.getDeclAnnotation(methElt, UIEffect.class) != null;
        }

        public boolean hasExplicitSafeEffect(ExecutableElement methElt) {
            return GUIEffectsTypeFactory.this.getDeclAnnotation(methElt, SafeEffect.class) != null;
        }

        public boolean hasExplicitPolyUIEffect(ExecutableElement methElt) {
            return GUIEffectsTypeFactory.this.getDeclAnnotation(methElt, PolyUIEffect.class) != null;
        }

        public boolean hasExplicitEffect(ExecutableElement methElt) {
            return this.hasExplicitUIEffect(methElt) || this.hasExplicitSafeEffect(methElt) || this.hasExplicitPolyUIEffect(methElt);
        }

        @Override
        public Void visitMethod(MethodTree node, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror.AnnotatedDeclaredType receiverType;
            AnnotatedTypeMirror.AnnotatedExecutableType methType = (AnnotatedTypeMirror.AnnotatedExecutableType)type;
            Effect e = GUIEffectsTypeFactory.this.getDeclaredEffect(methType.getElement());
            TypeElement cls = (TypeElement)methType.getElement().getEnclosingElement();
            if (!this.hasExplicitEffect(methType.getElement())) {
                methType.addAnnotation(e.getAnnot());
            }
            if ((receiverType = methType.getReceiverType()) != null && receiverType.getAnnotations().isEmpty()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType receiver = receiverType;
                receiver.clearAnnotations();
                receiver.addAnnotation(GUIEffectsTypeFactory.this.isPolymorphicType(cls) ? PolyUI.class : (GUIEffectsTypeFactory.this.fromElement(cls).hasAnnotation(UI.class) ? UI.class : AlwaysSafe.class));
            }
            return (Void)super.visitMethod(node, type);
        }
    }
}

