/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.util.script.Alternative;
import gov.nasa.jpf.util.script.ESParser;
import gov.nasa.jpf.util.script.Script;
import gov.nasa.jpf.util.script.ScriptElement;
import gov.nasa.jpf.util.script.ScriptElementContainer;
import java.io.StringReader;

public class SequenceInterpreter
implements Cloneable {
    ScriptElementContainer.SECIterator top;

    public SequenceInterpreter(ScriptElementContainer seq) {
        this.top = seq.iterator();
    }

    void push(ScriptElementContainer.SECIterator it) {
        it.prev = this.top;
        this.top = it;
    }

    ScriptElementContainer.SECIterator pop() {
        if (this.top != null) {
            this.top = this.top.getPrev();
        }
        return this.top;
    }

    public ScriptElement getNext() {
        if (this.top != null) {
            ScriptElement e = this.top.next();
            if (e != null) {
                if (e instanceof ScriptElementContainer && !(e instanceof Alternative)) {
                    this.push(((ScriptElementContainer)e).iterator());
                    return this.getNext();
                }
                return e;
            }
            this.pop();
            return this.top != null ? this.getNext() : null;
        }
        return null;
    }

    public Object clone() {
        try {
            SequenceInterpreter si = (SequenceInterpreter)super.clone();
            if (this.top != null) {
                si.top = (ScriptElementContainer.SECIterator)this.top.clone();
            }
            return si;
        }
        catch (CloneNotSupportedException nonsense) {
            return null;
        }
    }

    public boolean isDone() {
        return this.top == null;
    }

    public static void main(String[] args) {
        String s = "REPEAT 2 { start, ANY {a1,a2}, REPEAT 2 {r}, end }";
        StringReader r = new StringReader(s);
        try {
            ESParser parser = new ESParser("test", r);
            Script script = parser.parse();
            SequenceInterpreter si = new SequenceInterpreter(script);
            ScriptElement e = si.getNext();
            while (e != null) {
                System.out.println(e);
                e = si.getNext();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

