/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.StateExtensionClient;
import gov.nasa.jpf.util.StateExtensionListener;
import gov.nasa.jpf.util.script.Alternative;
import gov.nasa.jpf.util.script.ESParser;
import gov.nasa.jpf.util.script.Event;
import gov.nasa.jpf.util.script.Script;
import gov.nasa.jpf.util.script.ScriptElement;
import gov.nasa.jpf.util.script.Section;
import gov.nasa.jpf.util.script.SequenceInterpreter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;

public abstract class ScriptEnvironment<CG extends ChoiceGenerator<?>>
implements StateExtensionClient<ActiveSnapshot> {
    static final String DEFAULT = "default";
    String scriptName;
    Reader scriptReader;
    Script script;
    ActiveSnapshot cur;
    HashMap<String, Section> sections = new HashMap();
    Section defaultSection;
    static final String[] ACTIVE_DEFAULT = new String[]{"default"};

    public ScriptEnvironment(String fname) throws FileNotFoundException {
        this(fname, new FileReader(fname));
    }

    public ScriptEnvironment(String name, Reader r) {
        this.scriptName = name;
        this.scriptReader = r;
    }

    public void parseScript() throws ESParser.Exception {
        ESParser parser = new ESParser(this.scriptName, this.scriptReader);
        this.script = parser.parse();
        this.initSections();
        this.cur = new ActiveSnapshot();
    }

    void initSections() {
        Section defSec = new Section((ScriptElement)this.script, DEFAULT);
        for (ScriptElement e : this.script) {
            if (e instanceof Section) {
                Section sec = (Section)e;
                List<String> secIds = sec.getIds();
                if (secIds.size() > 0) {
                    for (String id : secIds) {
                        this.sections.put(id, (Section)sec.clone());
                    }
                    continue;
                }
                this.sections.put(secIds.get(0), sec);
                continue;
            }
            defSec.add(e.clone());
        }
        if (defSec.getNumberOfChildren() > 0) {
            this.defaultSection = defSec;
        }
    }

    Section getSection(String id) {
        Section sec = null;
        while (id != null) {
            sec = this.sections.get(id);
            if (sec != null) {
                return sec;
            }
            int idx = id.lastIndexOf(46);
            if (idx > 0) {
                id = id.substring(0, idx);
                continue;
            }
            id = null;
        }
        return this.defaultSection;
    }

    void addExpandedEvent(ArrayList<Event> events, Event se) {
        for (Event e : se.expand()) {
            if (events.contains(e)) continue;
            events.add(e);
        }
    }

    public CG getNext() {
        return this.getNext(ACTIVE_DEFAULT, null);
    }

    public CG getNext(String[] activeStates) {
        return this.getNext(activeStates, null);
    }

    public CG getNext(String[] activeStates, BitSet isReEntered) {
        this.cur = this.cur.advance(activeStates, isReEntered);
        ArrayList<Event> events = new ArrayList<Event>(this.cur.actives.length);
        block0: for (ActiveSequence as : this.cur.actives) {
            ScriptElement se;
            while ((se = as.intrp.getNext()) != null) {
                if (se instanceof Event) {
                    this.addExpandedEvent(events, (Event)se);
                    continue block0;
                }
                if (!(se instanceof Alternative)) continue;
                for (ScriptElement ase : (Alternative)se) {
                    if (!(ase instanceof Event)) continue;
                    this.addExpandedEvent(events, (Event)ase);
                }
            }
        }
        return this.createCGFromEvents(events);
    }

    protected abstract CG createCGFromEvents(List<Event> var1);

    @Override
    public ActiveSnapshot getStateExtension() {
        return this.cur;
    }

    @Override
    public void restore(ActiveSnapshot stateExtension) {
        this.cur = stateExtension;
    }

    @Override
    public void registerListener(JPF jpf) {
        StateExtensionListener<ActiveSnapshot> sel = new StateExtensionListener<ActiveSnapshot>(this);
        jpf.addSearchListener(sel);
    }

    public static void main(String[] args) {
        ScriptEnvironment.testMoveSequence();
    }

    static void testNoMoveSequence() {
        String s = "SECTION A {\n  start, ANY {a1,a2}, REPEAT 2 {r}, end \n}\nSECTION B {\n  foo, bar, baz \n}";
        String[][] a = new String[][]{{"A", "B"}, {"A", "B"}, {"A", "B"}, {"A", "B"}, {"A", "B"}, {"A", "B"}};
        try {
            EventEnv env = new EventEnv("test", new StringReader(s));
            env.parseScript();
            for (Object[] objectArray : a) {
                Object cg = env.getNext((String[])objectArray);
                System.out.println(Misc.toString(objectArray, "[", ",", "]") + " => " + cg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void testMoveSequence() {
        String s = "SECTION A {\n  start, ANY {a1,a2}, REPEAT 2 {r}, end \n}\nSECTION B {\n  foo, bar, baz \n}\nSECTION C {\n  du, da \n}";
        String[][] a = new String[][]{{"A", "B"}, {"A", "B"}, {"A", "C"}, {"B"}};
        try {
            EventEnv env = new EventEnv("test", new StringReader(s));
            env.parseScript();
            for (Object[] objectArray : a) {
                Object cg = env.getNext((String[])objectArray);
                System.out.println(Misc.toString(objectArray, "[", ",", "]") + " => " + cg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void testBacktrack() {
        String s = "SECTION A {\n  start, ANY {a1,a2}, REPEAT 2 {r}, end \n}\nSECTION B {\n  foo, bar, baz \n}";
        String[][] a = new String[][]{{"A", "B"}, {"A", "B"}, {"A", "B"}, {"A", "B"}, {"A", "B"}, {"A", "B"}};
        try {
            EventEnv env = new EventEnv("test", new StringReader(s));
            env.parseScript();
            Object cg = null;
            int i = 0;
            cg = env.getNext(a[i]);
            System.out.println(Misc.toString(a[i], "[", ",", "]") + " => " + cg);
            cg = env.getNext(a[++i]);
            System.out.println(Misc.toString(a[i], "[", ",", "]") + " => " + cg);
            Object snap = env.getStateExtension();
            cg = env.getNext(a[++i]);
            System.out.println(Misc.toString(a[i], "[", ",", "]") + " => " + cg);
            env.restore((ActiveSnapshot)snap);
            cg = env.getNext(a[i]);
            System.out.println(Misc.toString(a[i], "[", ",", "]") + " => " + cg);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class EventEnv
    extends ScriptEnvironment<EventChoice> {
        public EventEnv(String fname) throws FileNotFoundException {
            super(fname);
        }

        public EventEnv(String name, Reader r) {
            super(name, r);
        }

        @Override
        protected EventChoice createCGFromEvents(List<Event> events) {
            if (events.isEmpty()) {
                return null;
            }
            if (events.size() == 1) {
                return new EventChoice(events.get(0));
            }
            EventChoiceSet cg = new EventChoiceSet();
            for (Event e : events) {
                cg.add(e);
            }
            return cg;
        }
    }

    static class EventChoiceSet
    extends EventChoice {
        ArrayList<Event> list = new ArrayList();

        public void add(Event e) {
            this.list.add(e);
        }

        @Override
        public boolean hasMoreChoices() {
            return this.cur < this.list.size();
        }

        @Override
        public Event getNextChoice() {
            return this.cur >= 0 && this.cur < this.list.size() ? this.list.get(this.cur) : null;
        }

        @Override
        public int getTotalNumberOfChoices() {
            return this.list.size();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append("[id=\"");
            sb.append(this.id);
            sb.append("\",");
            for (int i = 0; i < this.list.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                if (i == this.cur) {
                    sb.append('>');
                }
                sb.append(this.list.get(i).toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    static class EventChoice
    extends ChoiceGenerator<Event> {
        int cur = -1;
        Event e;

        protected EventChoice() {
        }

        EventChoice(Event e) {
            this.e = e;
        }

        @Override
        public void advance() {
            ++this.cur;
        }

        @Override
        public boolean hasMoreChoices() {
            return this.cur < 0;
        }

        @Override
        public Class<Event> getChoiceType() {
            return Event.class;
        }

        @Override
        public Event getNextChoice() {
            return this.cur == 0 ? this.e : null;
        }

        @Override
        public int getProcessedNumberOfChoices() {
            return this.cur + 1;
        }

        @Override
        public int getTotalNumberOfChoices() {
            return 1;
        }

        @Override
        public ChoiceGenerator randomize() {
            return null;
        }

        @Override
        public void reset() {
            this.cur = -1;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append("[id=\"");
            sb.append(this.id);
            sb.append("\",");
            if (this.cur >= 0) {
                sb.append('>');
            }
            sb.append(this.e.toString());
            sb.append(']');
            return sb.toString();
        }
    }

    class ActiveSnapshot
    implements Cloneable {
        ActiveSequence[] actives;

        ActiveSnapshot() {
            this.actives = new ActiveSequence[0];
        }

        ActiveSnapshot(ActiveSequence[] as) {
            this.actives = as;
        }

        public ActiveSequence get(String stateName) {
            for (ActiveSequence as : this.actives) {
                if (!as.stateName.equals(stateName)) continue;
                return as;
            }
            return null;
        }

        public Object clone() {
            try {
                ActiveSnapshot ss = (ActiveSnapshot)super.clone();
                for (int i = 0; i < this.actives.length; ++i) {
                    ActiveSequence as = this.actives[i];
                    ss.actives[i] = (ActiveSequence)as.clone();
                }
                return ss;
            }
            catch (CloneNotSupportedException nonsense) {
                return null;
            }
        }

        ActiveSnapshot advance(String[] activeStates, BitSet isReEntered) {
            ActiveSequence[] newActives = new ActiveSequence[activeStates.length];
            for (int i = 0; i < activeStates.length; ++i) {
                String sn = activeStates[i];
                for (ActiveSequence as : this.actives) {
                    if (!as.stateName.equals(sn)) continue;
                    newActives[i] = (ActiveSequence)as.clone();
                }
            }
            int skipped = 0;
            block2: for (int i = 0; i < activeStates.length; ++i) {
                if (newActives[i] != null) continue;
                Section sec = ScriptEnvironment.this.getSection(activeStates[i]);
                if (sec != null) {
                    ActiveSequence as;
                    int j;
                    for (j = 0; j < newActives.length; ++j) {
                        if (newActives[j] == null || newActives[j].section != sec) continue;
                        ++skipped;
                        continue block2;
                    }
                    for (j = 0; j < this.actives.length; ++j) {
                        ActiveSequence as2;
                        if (this.actives[j].section != sec) continue;
                        newActives[i] = as2 = new ActiveSequence(activeStates[i], sec, this.actives[j].intrp);
                        continue block2;
                    }
                    newActives[i] = as = new ActiveSequence(activeStates[i], sec, new SequenceInterpreter(sec));
                    continue;
                }
                ++skipped;
            }
            if (skipped > 0) {
                int n = activeStates.length - skipped;
                ActiveSequence[] na = new ActiveSequence[n];
                int i = 0;
                int j = 0;
                while (j < n) {
                    if (newActives[i] != null) {
                        na[j++] = newActives[i];
                    }
                    ++i;
                }
                newActives = na;
            }
            return new ActiveSnapshot(newActives);
        }
    }

    static class ActiveSequence
    implements Cloneable {
        String stateName;
        Section section;
        SequenceInterpreter intrp;

        public ActiveSequence(String stateName, Section section, SequenceInterpreter intrp) {
            this.stateName = stateName;
            this.section = section;
            this.intrp = intrp;
        }

        public Object clone() {
            try {
                ActiveSequence as = (ActiveSequence)super.clone();
                as.intrp = (SequenceInterpreter)this.intrp.clone();
                return as;
            }
            catch (CloneNotSupportedException nonsense) {
                return null;
            }
        }

        public boolean isDone() {
            return this.intrp.isDone();
        }
    }
}

