/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.DynamicObjectArray;
import gov.nasa.jpf.util.script.ESParser;
import gov.nasa.jpf.util.script.ElementProcessor;
import gov.nasa.jpf.util.script.EventFactory;
import gov.nasa.jpf.util.script.EventGenerator;
import gov.nasa.jpf.util.script.Script;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

public abstract class EventGeneratorFactory
extends ListenerAdapter
implements ElementProcessor,
Iterable<EventGenerator> {
    static final String DEFAULT = "default";
    protected int cur;
    DynamicObjectArray<Memento> states;
    protected String scriptFileName;
    protected Script script;
    protected Config conf;
    protected LinkedHashMap<String, ArrayList<EventGenerator>> sections;
    protected ArrayList<EventGenerator> queue;
    EventFactory efact;

    protected EventGeneratorFactory() {
        this.efact = null;
    }

    protected EventGeneratorFactory(EventFactory efact) {
        this.efact = efact;
    }

    protected void init(String fname) throws ESParser.Exception {
        this.cur = 0;
        this.states = new DynamicObjectArray();
        this.sections = new LinkedHashMap();
        this.queue = new ArrayList();
        this.sections.put(DEFAULT, this.queue);
        ESParser parser = new ESParser(fname, this.efact);
        this.script = parser.parse();
        this.scriptFileName = fname;
        this.script.process(this);
    }

    @Override
    public Iterator<EventGenerator> iterator() {
        return this.queue.iterator();
    }

    protected void addLoop(int startPos) {
        this.queue.add(new Loop(startPos, this.queue.size() - 1));
    }

    public abstract Class<?> getEventType();

    public void reset() {
        this.cur = 0;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public Script getScript() {
        return this.script;
    }

    public boolean hasSection(String id) {
        return this.sections.containsKey(id);
    }

    public ArrayList<EventGenerator> getSection(String id) {
        return this.sections.get(id);
    }

    public ArrayList<EventGenerator> getDefaultSection() {
        return this.sections.get(DEFAULT);
    }

    protected void setQueue(ArrayList<EventGenerator> q) {
        if (this.queue != q) {
            this.queue = q;
            this.cur = 0;
        }
    }

    protected EventGenerator getNextEventGenerator() {
        int n = this.queue.size();
        if (n == 0) {
            return null;
        }
        if (this.cur < n) {
            EventGenerator cg = this.getQueueItem(this.cur);
            if (cg instanceof Loop) {
                int tgtPos = ((Loop)cg).getStartPos();
                if (!(cg = this.queue.get(tgtPos)).hasMoreChoices()) {
                    for (int i = tgtPos; i < this.cur; ++i) {
                        this.queue.get(i).reset();
                    }
                }
                this.cur = tgtPos;
            }
            cg.setId(Integer.toString(this.cur));
            ++this.cur;
            return cg;
        }
        return null;
    }

    protected EventGenerator getQueueItem(int i) {
        return this.queue.get(i);
    }

    public int getTotalNumberOfEvents() {
        int total = 0;
        int last = 1;
        for (EventGenerator cg : this.queue) {
            int level = cg.getTotalNumberOfChoices() * last;
            total += level;
            last = level;
        }
        return total;
    }

    public void printOn(PrintWriter pw) {
        for (EventGenerator eg : this.queue) {
            pw.println(eg);
        }
    }

    @Override
    public void searchStarted(Search search) {
        this.cur = 0;
    }

    @Override
    public void stateAdvanced(Search search) {
        int idx = search.getStateNumber();
        if (idx >= 0) {
            Memento m = new Memento(this);
            this.states.set(idx, m);
        }
    }

    @Override
    public void stateBacktracked(Search search) {
        Memento m = this.states.get(search.getStateNumber());
        m.restore(this);
    }

    @Override
    public void stateRestored(Search search) {
        Memento m = this.states.get(search.getStateNumber());
        m.restore(this);
        SystemState ss = search.getVM().getSystemState();
        ChoiceGenerator<?> cgNext = ss.getNextChoiceGenerator();
        cgNext.reset();
    }

    static class Loop
    extends EventGenerator {
        int startPos;
        int endPos;

        Loop(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        int getStartPos() {
            return this.startPos;
        }

        @Override
        public void advance() {
        }

        @Override
        public Class getChoiceType() {
            return null;
        }

        @Override
        public Object getNextChoice() {
            return null;
        }

        @Override
        public int getProcessedNumberOfChoices() {
            return 0;
        }

        @Override
        public int getTotalNumberOfChoices() {
            return 0;
        }

        @Override
        public boolean hasMoreChoices() {
            return false;
        }

        @Override
        public ChoiceGenerator randomize() {
            return null;
        }

        @Override
        public void reset() {
        }
    }

    static class Memento {
        ArrayList<EventGenerator> queue;
        int cur;

        Memento(EventGeneratorFactory fact) {
            this.queue = fact.queue;
            this.cur = fact.cur;
        }

        void restore(EventGeneratorFactory fact) {
            fact.queue = this.queue;
            fact.cur = this.cur;
        }
    }
}

