/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.util.StringExpander;
import gov.nasa.jpf.util.script.ElementProcessor;
import gov.nasa.jpf.util.script.ScriptElement;
import java.util.ArrayList;
import java.util.List;

public class Event
extends ScriptElement {
    public static final String NONE = "NONE";
    protected String id;
    protected String[] arguments;

    public Event(ScriptElement parent, String id, String[] args, int line) {
        super(parent, line);
        this.id = id;
        if (args != null && args.length > 0) {
            this.arguments = (String[])args.clone();
        }
    }

    public boolean isNone() {
        return NONE.equals(this.id);
    }

    public static boolean isNone(String id) {
        return NONE.equals(id);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public String toString() {
        if (this.arguments == null) {
            return this.id;
        }
        StringBuilder sb = new StringBuilder(this.id);
        sb.append('(');
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.arguments[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] args) {
        this.arguments = args;
    }

    @Override
    public void process(ElementProcessor p) {
        p.process(this);
    }

    String[] expandArgument(String a) {
        ArrayList<String> list = new ArrayList<String>();
        StringExpander ex = new StringExpander();
        List<String> l = ex.expand(a);
        list.addAll(l);
        return list.toArray(new String[list.size()]);
    }

    public List<Event> expand() {
        StringExpander ex = new StringExpander();
        List<String> ids = ex.expand(this.id);
        ArrayList<Event> list = new ArrayList<Event>();
        if (this.arguments != null) {
            String[] a = new String[this.arguments.length];
            String[][] args = new String[this.arguments.length][];
            int[] argIdx = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.expandArgument(this.arguments[i]);
            }
            int n = args.length - 1;
            block1: for (String id : ids) {
                int i;
                for (i = 0; i <= n; ++i) {
                    argIdx[i] = 0;
                }
                i = n;
                while (true) {
                    if (argIdx[i] >= args[i].length) {
                        int l;
                        for (l = i - 1; l >= 0; --l) {
                            int n2 = l;
                            argIdx[n2] = argIdx[n2] + 1;
                            argIdx[l + 1] = 0;
                            if (argIdx[l] < args[l].length) break;
                        }
                        if (l < 0) continue block1;
                        i = n;
                        continue;
                    }
                    for (int k = 0; k < args.length; ++k) {
                        a[k] = args[k][argIdx[k]];
                    }
                    Event ee = new Event(this.parent, id, a, this.line);
                    list.add(ee);
                    int n3 = i;
                    argIdx[n3] = argIdx[n3] + 1;
                }
            }
        } else if (ids.size() == 1) {
            list.add(this);
        } else {
            for (String id : ids) {
                list.add(new Event(this.parent, id, this.arguments, this.line));
            }
        }
        return list;
    }

    public Object[] getConcreteArguments() {
        if (this.arguments == null) {
            return null;
        }
        if (this.arguments.length == 0) {
            return new Object[0];
        }
        Object[] a = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            a[i] = this.getConcreteArgument(this.arguments[i]);
        }
        return a;
    }

    Object getConcreteArgument(String s) {
        char c = s.charAt(0);
        if (c == '\"' || c == '\'') {
            return s.substring(1, s.length() - 1);
        }
        if (Character.isDigit(c)) {
            if (s.indexOf(46) >= 0) {
                return Double.parseDouble(s);
            }
            return Integer.parseInt(s);
        }
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("unsupported event argument type of value=" + s);
    }

    public static Object[][] getBooleanArgVariations(int nArgs) {
        int n = 1 << nArgs;
        Object[][] args = new Object[n][];
        for (int i = 0; i < n; ++i) {
            args[i] = new Boolean[nArgs];
            for (int j = 0; j < nArgs; ++j) {
                args[i][j] = (i & 1 << j) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return args;
    }
}

