/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.util.script.Alternative;
import gov.nasa.jpf.util.script.CG;
import gov.nasa.jpf.util.script.Event;
import gov.nasa.jpf.util.script.EventFactory;
import gov.nasa.jpf.util.script.Repetition;
import gov.nasa.jpf.util.script.Script;
import gov.nasa.jpf.util.script.ScriptElement;
import gov.nasa.jpf.util.script.ScriptElementContainer;
import gov.nasa.jpf.util.script.Section;
import gov.nasa.jpf.util.script.StringSetGenerator;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ESParser {
    public static final String K_REPEAT = "REPEAT";
    public static final String K_ANY = "ANY";
    public static final String K_SECTION = "SECTION";
    String file;
    StreamTokenizer scanner;
    boolean done = false;
    EventFactory eventFactory;

    public ESParser(String fname, EventFactory eFact) throws Exception {
        this.eventFactory = eFact != null ? eFact : new DefaultEventFactory();
        try {
            this.file = fname;
            FileReader r = new FileReader(fname);
            this.scanner = this.createScanner(r);
            this.scanner.nextToken();
        }
        catch (FileNotFoundException fnfx) {
            throw new Exception("file not found:", fname);
        }
        catch (IOException iox) {
            throw new Exception("error reading: ", fname);
        }
    }

    public ESParser(String fname) throws Exception {
        this(fname, new DefaultEventFactory());
    }

    public ESParser(String name, Reader r) throws Exception {
        this(name, r, new DefaultEventFactory());
    }

    public ESParser(String name, Reader r, EventFactory eFact) throws Exception {
        this.eventFactory = eFact;
        try {
            this.file = name;
            this.scanner = this.createScanner(r);
            this.scanner.nextToken();
        }
        catch (IOException iox) {
            throw new Exception("error reading: ", name);
        }
    }

    StreamTokenizer createScanner(Reader r) {
        StreamTokenizer s = new StreamTokenizer(r);
        s.ordinaryChars(48, 57);
        s.wordChars(48, 57);
        s.wordChars(91, 91);
        s.wordChars(93, 93);
        s.wordChars(124, 124);
        s.wordChars(45, 45);
        s.wordChars(95, 95);
        s.wordChars(35, 35);
        s.wordChars(42, 42);
        s.wordChars(64, 64);
        s.wordChars(36, 36);
        s.wordChars(58, 58);
        s.wordChars(126, 126);
        s.quoteChar(34);
        s.slashSlashComments(true);
        s.slashStarComments(true);
        s.whitespaceChars(44, 44);
        s.whitespaceChars(59, 59);
        return s;
    }

    void nextToken() throws Exception {
        try {
            if (this.scanner.nextToken() == -1) {
                this.done = true;
            }
        }
        catch (IOException iox) {
            throw new Exception("could not read input", iox.toString());
        }
    }

    void match(char c) throws Exception {
        if (this.scanner.ttype != c) {
            throw new Exception("char '" + c + "' expected");
        }
        this.nextToken();
    }

    boolean isMatch(char c) throws Exception {
        if (this.scanner.ttype == c) {
            this.nextToken();
            return true;
        }
        return false;
    }

    boolean isMatch(String word) throws Exception {
        if (this.scanner.ttype == -3 && this.scanner.sval.equals(word)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    String matchKeyword(String key) throws Exception {
        String s = this.matchWord();
        if (!s.equals(key)) {
            throw new Exception("expected keyword: " + key);
        }
        return s;
    }

    String matchWord() throws Exception {
        if (this.scanner.ttype == -3) {
            String s = this.scanner.sval;
            this.nextToken();
            return s;
        }
        throw new Exception("id or keyword expected");
    }

    boolean isInt(String s) {
        char c = s.charAt(0);
        return c >= '0' && c <= '9';
    }

    int isIntMatch(int defaultValue) throws Exception {
        if (this.scanner.ttype == -3 && this.isInt(this.scanner.sval)) {
            int n = Integer.parseInt(this.scanner.sval);
            this.nextToken();
            return n;
        }
        return defaultValue;
    }

    int matchIntNumber() throws Exception {
        if (this.scanner.ttype == -3 && this.isInt(this.scanner.sval)) {
            int n = Integer.parseInt(this.scanner.sval);
            this.nextToken();
            return n;
        }
        throw new Exception("number expected");
    }

    public Script parse() throws Exception {
        Script s = new Script();
        while (!this.done) {
            if (this.isMatch(K_SECTION)) {
                this.section(s);
                continue;
            }
            this.sequence(s);
        }
        return s;
    }

    protected void section(ScriptElementContainer parent) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        String id = this.matchWord();
        ids.add(id);
        while (this.isMatch(',')) {
            id = this.matchWord();
            ids.add(id);
        }
        Section sec = new Section(parent, ids, this.scanner.lineno());
        parent.add(sec);
        this.match('{');
        while (!this.done && this.scanner.ttype != 125) {
            this.sequence(sec);
        }
        this.match('}');
    }

    protected void sequence(ScriptElementContainer parent) throws Exception {
        if (this.isMatch(K_REPEAT)) {
            this.repetition(parent);
        } else if (this.isMatch(K_ANY)) {
            this.alternative(parent);
        } else if (this.scanner.ttype == -3) {
            this.event(parent);
        } else if (this.scanner.ttype == -1) {
            this.done = true;
        } else {
            throw new Exception("repetition, alternative or event expected");
        }
    }

    protected void repetition(ScriptElementContainer parent) throws Exception {
        int n = this.isIntMatch(-1);
        Repetition r = new Repetition(parent, n, this.scanner.lineno());
        parent.add(r);
        this.match('{');
        while (!this.done && this.scanner.ttype != 125) {
            this.sequence(r);
        }
        this.match('}');
    }

    protected void alternative(ScriptElementContainer parent) throws Exception {
        Alternative a = new Alternative(parent, this.scanner.lineno());
        parent.add(a);
        this.match('{');
        while (!this.done && this.scanner.ttype != 125) {
            this.event(a);
        }
        this.match('}');
    }

    protected void event(ScriptElementContainer parent) throws Exception {
        String id = this.matchWord();
        ArrayList<String> args = new ArrayList<String>();
        if (this.isMatch('(')) {
            while (!this.isMatch(')')) {
                if (this.scanner.ttype == -3) {
                    args.add(this.scanner.sval);
                } else if (this.scanner.ttype == 34) {
                    args.add("\"" + this.scanner.sval + '\"');
                }
                this.nextToken();
            }
        }
        Event e = this.eventFactory.createEvent(parent, id, args, this.scanner.lineno());
        parent.add(e);
    }

    public static void tokenize(String fname) {
        try {
            ESParser parser = new ESParser(fname);
            StreamTokenizer s = parser.scanner;
            while (s.ttype != -1) {
                switch (s.ttype) {
                    case -3: {
                        System.out.println("WORD: " + s.sval);
                        break;
                    }
                    case -2: {
                        System.out.println("NUM:  " + s.nval);
                        break;
                    }
                    default: {
                        char c = (char)s.ttype;
                        if (c == '\"') {
                            System.out.println("STRING: \"" + s.sval + '\"');
                            break;
                        }
                        System.out.println("CHAR: " + (char)s.ttype);
                    }
                }
                s.nextToken();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void showScript(String fname) {
        try {
            ESParser parser = new ESParser(fname);
            Script script = parser.parse();
            PrintWriter pw = new PrintWriter(System.out, true);
            pw.println("------------------ script AST:");
            script.dump(pw);
            pw.println("------------------ generated CG sequence:");
            StringSetGenerator p = new StringSetGenerator();
            script.process(p);
            LinkedHashMap<String, ArrayList<CG>> sections = p.getSections();
            for (Map.Entry<String, ArrayList<CG>> e : sections.entrySet()) {
                ArrayList<CG> queue = e.getValue();
                System.out.println(e.getKey() + " {");
                for (CG cg : queue) {
                    System.out.print("  ");
                    System.out.println(cg);
                }
                System.out.println("}");
                System.out.println();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ESParser.showScript(args[0]);
    }

    public static class DefaultEventFactory
    implements EventFactory {
        @Override
        public Event createEvent(ScriptElement parent, String id, List<String> args, int line) {
            return new Event(parent, id, args.toArray(new String[args.size()]), line);
        }
    }

    public class Exception
    extends java.lang.Exception {
        Exception(String details) {
            super("parse error: " + details + ", found: " + ESParser.this.scanner);
        }

        Exception(String msg, String param) {
            super(msg + ' ' + param);
        }
    }
}

