/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import java.lang.ref.WeakReference;

public class WeakPool<E> {
    private static final boolean DEBUG = false;
    static final double MAX_LOAD_WIPE = 0.6;
    static final double MAX_LOAD_REHASH = 0.4;
    static final int DEFAULT_POW = 10;
    WeakReference<E>[] table;
    int count;
    int pow;
    int mask;
    int nextWipe;
    int nextRehash;

    public WeakPool() {
        this(10);
    }

    public WeakPool(int pow) {
        this.pow = pow;
        this.newTable();
        this.count = 0;
        this.mask = this.table.length - 1;
        this.nextWipe = (int)(0.6 * (double)this.mask);
        this.nextRehash = (int)(0.4 * (double)this.mask);
    }

    protected void newTable() {
        this.table = new WeakReference[1 << this.pow];
    }

    public boolean isPooled(E e) {
        return e == null || this.query(e) != null;
    }

    public E query(E e) {
        WeakReference<E> r;
        if (e == null) {
            return null;
        }
        int code = e.hashCode();
        int idx = code & this.mask;
        int delta = code >> this.pow - 1 | 1;
        int oidx = idx;
        while ((r = this.table[idx]) != null) {
            Object o = r.get();
            if (o != null && e.equals(o)) {
                return (E)o;
            }
            idx = idx + delta & this.mask;
            assert (idx != oidx);
        }
        return null;
    }

    public E pool(E e) {
        WeakReference<E> r;
        if (e == null) {
            return null;
        }
        int code = e.hashCode();
        int idx = code & this.mask;
        int delta = code >> this.pow - 1 | 1;
        int oidx = idx;
        while ((r = this.table[idx]) != null) {
            Object o = r.get();
            if (o != null && e.equals(o)) {
                return (E)o;
            }
            idx = idx + delta & this.mask;
            assert (idx != oidx);
        }
        assert (this.table[idx] == null);
        ++this.count;
        if (this.count >= this.nextWipe) {
            int oldCount = this.count;
            this.count = 0;
            for (int i = 0; i < this.table.length; ++i) {
                if (this.table[i] == null || this.table[i].get() == null) continue;
                ++this.count;
            }
            if (this.count >= this.nextRehash) {
                ++this.pow;
            }
            WeakReference<E>[] oldTable = this.table;
            this.newTable();
            this.mask = this.table.length - 1;
            this.nextWipe = (int)(0.6 * (double)this.mask);
            this.nextRehash = (int)(0.4 * (double)this.mask);
            for (WeakReference<E> r2 : oldTable) {
                Object o;
                if (r2 == null || (o = r2.get()) == null) continue;
                code = o.hashCode();
                idx = code & this.mask;
                delta = code >> this.pow - 1 | 1;
                while (this.table[idx] != null) {
                    idx = idx + delta & this.mask;
                }
                this.table[idx] = r2;
            }
            code = e.hashCode();
            idx = code & this.mask;
            delta = code >> this.pow - 1 | 1;
            while (this.table[idx] != null) {
                idx = idx + delta & this.mask;
            }
        }
        this.table[idx] = new WeakReference<E>(e);
        return e;
    }

    public boolean isMember(E e) {
        return this.query(e) != null;
    }

    public void add(E e) {
        this.pool(e);
    }

    public static void main(String[] args) {
        Integer p;
        Integer o;
        int i;
        WeakPool<Integer> pool = new WeakPool<Integer>(4);
        for (i = 0; i < 1000000; i += 42) {
            o = new Integer(i);
            p = pool.pool(o);
            if (o != p) {
                throw new RuntimeException();
            }
            Integer q = pool.pool(p);
            if (q == p) continue;
            throw new RuntimeException();
        }
        for (i = 0; i < 1000000; i += 42) {
            o = new Integer(i);
            p = pool.pool(o);
            if (o == p) {
                throw new RuntimeException();
            }
            if (o.equals(p)) continue;
            throw new RuntimeException();
        }
        for (i = 1; i < 1000000; i += 42) {
            o = new Integer(i);
            p = pool.pool(o);
            if (o == p) continue;
            throw new RuntimeException();
        }
    }
}

