/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class Source {
    static Logger logger = JPF.getLogger("gov.nasa.jpf.util.Source");
    static List<SourceRoot> sourceRoots;
    static Hashtable<String, Source> sources;
    protected SourceRoot root;
    protected String fname;
    protected String[] lines;

    public static void init(Config config) {
        String[] specs = config.getStringArray("vm.sourcepath");
        ArrayList<SourceRoot> roots = new ArrayList<SourceRoot>();
        for (String spec : specs) {
            SourceRoot sr = null;
            try {
                String pn;
                int i = spec.indexOf(".jar");
                if (i >= 0) {
                    pn = config.asPlatformPath(spec.substring(0, i + 4));
                    File jar = new File(pn);
                    if (jar.exists()) {
                        int i0 = i + 5;
                        String ep = spec.length() > i0 ? config.asCanonicalUnixPath(spec.substring(i0)) : null;
                        sr = new JarRoot(pn, ep);
                    }
                } else {
                    pn = config.asPlatformPath(spec);
                    File dir = new File(pn);
                    if (dir.exists()) {
                        sr = new DirRoot(pn);
                    }
                }
            }
            catch (IOException iox) {
                // empty catch block
            }
            if (sr != null) {
                roots.add(sr);
                continue;
            }
            logger.info("not a valid source root: " + spec);
        }
        sourceRoots = roots;
        sources.clear();
    }

    public static Source getSource(String fname) {
        Source s = sources.get(fname);
        if (s == null) {
            for (SourceRoot root : sourceRoots) {
                InputStream is = root.getInputStream(fname);
                if (is == null) continue;
                try {
                    s = new Source(root, fname);
                    s.loadLines(is);
                    is.close();
                    sources.put(fname, s);
                    return s;
                }
                catch (IOException iox) {
                    logger.warning("error reading " + fname + " from" + root);
                    return null;
                }
            }
        } else {
            return s;
        }
        return null;
    }

    protected Source(SourceRoot root, String fname) {
        this.root = root;
        this.fname = fname;
    }

    protected void loadLines(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> l = new ArrayList<String>();
        String line = in.readLine();
        while (line != null) {
            l.add(line);
            line = in.readLine();
        }
        in.close();
        if (l.size() > 0) {
            this.lines = l.toArray(new String[l.size()]);
        }
    }

    public String getLine(int i) {
        if (this.lines == null || i <= 0 || i > this.lines.length) {
            return null;
        }
        return this.lines[i - 1];
    }

    public String getPath() {
        return this.root.toString() + File.separatorChar + this.fname;
    }

    static {
        sources = new Hashtable();
    }

    static class JarRoot
    extends SourceRoot {
        JarFile jar;
        String entryPrefix;

        JarRoot(String path, String ep) throws IOException {
            this.jar = new JarFile(path);
            if (ep == null) {
                this.entryPrefix = null;
            } else {
                this.entryPrefix = ep;
                if (ep.charAt(ep.length() - 1) != '/') {
                    this.entryPrefix = this.entryPrefix + '/';
                }
            }
        }

        @Override
        InputStream getInputStream(String fname) {
            String en = this.entryPrefix != null ? this.entryPrefix + fname : fname;
            JarEntry entry = this.jar.getJarEntry(en);
            if (entry != null) {
                try {
                    return this.jar.getInputStream(entry);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        public String toString() {
            return this.jar.getName();
        }
    }

    static class DirRoot
    extends SourceRoot {
        String path;

        DirRoot(String path) {
            this.path = path;
        }

        @Override
        InputStream getInputStream(String fname) {
            File f = new File(this.path, fname);
            if (f.exists()) {
                try {
                    return new FileInputStream(f);
                }
                catch (FileNotFoundException fnfx) {
                    return null;
                }
            }
            return null;
        }

        public String toString() {
            return this.path;
        }
    }

    static abstract class SourceRoot {
        SourceRoot() {
        }

        abstract InputStream getInputStream(String var1);
    }
}

