/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;
import gov.nasa.jpf.util.IntVector;

public final class Permutation {
    public static final int defaultInitCap = 40;
    protected int[] data;
    protected Growth growth;
    protected final IntVector inverse;

    public Permutation(Growth initGrowth, int initCap) {
        this.inverse = new IntVector(initGrowth, initCap);
        this.growth = initGrowth;
        this.data = new int[initCap];
    }

    public Permutation(Growth initGrowth) {
        this(initGrowth, 40);
    }

    public Permutation(int initCap) {
        this(Growth.defaultGrowth, initCap);
    }

    public Permutation() {
        this(Growth.defaultGrowth, 40);
    }

    public void add(int x) {
        if (x < 0) {
            return;
        }
        this.ensureCapacity(x + 1);
        if (this.data[x] < 0) {
            this.data[x] = this.inverse.size;
            this.inverse.add(x);
        }
    }

    public int get(int x) {
        if (x >= this.data.length) {
            return -1;
        }
        return this.data[x];
    }

    public int inverseGet(int v) {
        if (v >= this.inverse.size) {
            return -1;
        }
        return this.inverse.get(v);
    }

    public void set(int x, int v) {
        this.ensureCapacity(x + 1);
        this.data[x] = v;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -1;
        }
        this.inverse.clear();
    }

    public int rangeSize() {
        return this.inverse.size;
    }

    public void ensureCapacity(int desiredCap) {
        if (this.data.length < desiredCap) {
            int[] newData = new int[this.growth.grow(this.data.length, desiredCap)];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            for (int i = this.data.length; i < newData.length; ++i) {
                newData[i] = -1;
            }
            this.data = newData;
        }
    }
}

