/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.ReadOnlyObjList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ObjArray<E>
implements ReadOnlyObjList<E>,
Iterable<E> {
    final Object[] data;
    static final ObjArray<Object> zero = new ObjArray(0);

    public ObjArray(int size) {
        this.data = new Object[size];
    }

    public ObjArray(E[] data) {
        this.data = data;
    }

    public E[] toArray(E[] a) {
        if (a.length >= this.data.length) {
            System.arraycopy(this.data, 0, a, 0, this.data.length);
            return a;
        }
        return null;
    }

    @Override
    public E get(int idx) {
        return (E)this.data[idx];
    }

    public void set(int idx, E e) {
        this.data[idx] = e;
    }

    @Override
    public int length() {
        return this.data.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjArray)) {
            return false;
        }
        Object[] thisData = this.data;
        Object[] thatData = ((ObjArray)o).data;
        if (thisData == thatData) {
            return true;
        }
        if (thisData.length != thatData.length) {
            return false;
        }
        for (int i = 0; i < thisData.length; ++i) {
            if (Misc.equal(thisData[i], thatData[i])) continue;
            return false;
        }
        return true;
    }

    public void fill(E e) {
        Arrays.fill(this.data, e);
    }

    public void nullify() {
        Arrays.fill(this.data, null);
    }

    public static <T> void copy(ObjArray<? extends T> src, int srcPos, ObjArray<T> dst, int dstPos, int len) {
        System.arraycopy(src.data, srcPos, dst.data, dstPos, len);
    }

    public static <T> ObjArray<T> zeroLength() {
        return zero;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ObjArray.this.data.length;
            }

            @Override
            public E next() {
                if (this.idx >= ObjArray.this.data.length) {
                    throw new NoSuchElementException();
                }
                return ObjArray.this.data[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

