/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.ElementCreator;
import gov.nasa.jpf.util.TwoTypeComparator;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Misc {
    public static final Object[] emptyObjectArray = new Object[0];
    public static final Iterator<?> emptyIterator = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new NoSuchElementException();
        }
    };
    public static final Iterable<?> emptyIterable = new Iterable<Object>(){

        @Override
        public Iterator<Object> iterator() {
            return emptyIterator;
        }
    };

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static <E> Iterator<E> emptyIterator() {
        return emptyIterator;
    }

    public static <E> Iterable<E> emptyIterable() {
        return emptyIterable;
    }

    public static <E> Iterable<E> iterableFromIterator(Iterator<E> iter) {
        return new Iteratorable<E>(iter);
    }

    public static <E> void addAll(Collection<E> target, Iterable<? extends E> src) {
        for (E e : src) {
            target.add(e);
        }
    }

    public static <T> T[] getAddedElements(T[] oldArray, T[] newArray) {
        if (newArray == null || newArray.length == 0) {
            return oldArray;
        }
        if (oldArray == null || oldArray.length == 0) {
            return newArray;
        }
        Object[] na = (Object[])newArray.clone();
        int n = na.length;
        block0: for (int i = 0; i < na.length; ++i) {
            Object eNew = na[i];
            if (eNew != null) {
                for (int j = 0; j < oldArray.length; ++j) {
                    if (!eNew.equals(oldArray[j])) continue;
                    na[i] = null;
                    --n;
                    continue block0;
                }
                continue;
            }
            --n;
        }
        Class<?> ct = newArray.getClass().getComponentType();
        Object[] addedElements = (Object[])Array.newInstance(ct, n);
        int j = 0;
        for (int i = 0; i < na.length; ++i) {
            if (na[i] == null) continue;
            addedElements[j++] = na[i];
        }
        return addedElements;
    }

    public static <T> T[] getRemovedElements(T[] oldArray, T[] newArray) {
        if (newArray == null || newArray.length == 0 || oldArray == null || oldArray.length == 0) {
            return null;
        }
        Object[] oa = (Object[])oldArray.clone();
        int n = oa.length;
        block0: for (int i = 0; i < oa.length; ++i) {
            Object eOld = oa[i];
            if (eOld != null) {
                for (int j = 0; j < newArray.length; ++j) {
                    if (!eOld.equals(newArray[j])) continue;
                    oa[i] = null;
                    --n;
                    continue block0;
                }
                continue;
            }
            --n;
        }
        Class<?> ct = oldArray.getClass().getComponentType();
        Object[] addedElements = (Object[])Array.newInstance(ct, n);
        int j = 0;
        for (int i = 0; i < oa.length; ++i) {
            if (oa[i] == null) continue;
            addedElements[j++] = oa[i];
        }
        return addedElements;
    }

    public static <K, V> ArrayList<String> getSortedKeyStrings(HashMap<K, V> map) {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (K key : map.keySet()) {
            String ks = key.toString();
            for (int i = 0; i < list.size(); ++i) {
                String k = list.get(i);
                if (ks.compareTo(k) <= 0) continue;
                list.add(i, ks);
                continue block0;
            }
            list.add(ks);
        }
        return list;
    }

    public static <K, V> ArrayList<Map.Entry<K, V>> createSortedEntryList(HashMap<K, V> map, Comparator<Map.Entry<K, V>> comparer) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>();
        block0: for (Map.Entry<K, V> e : map.entrySet()) {
            for (int i = 0; i < list.size(); ++i) {
                if (comparer.compare(e, list.get(i)) <= 0) continue;
                list.add(i, e);
                continue block0;
            }
            list.add(e);
        }
        return list;
    }

    public static <K, V, E> ArrayList<E> createSortedList(HashMap<K, V> map, TwoTypeComparator<Map.Entry<K, V>, E> comparer, ElementCreator<Map.Entry<K, V>, E> creator) {
        ArrayList<E> list = new ArrayList<E>();
        block0: for (Map.Entry<K, V> e : map.entrySet()) {
            for (int i = 0; i < list.size(); ++i) {
                if (comparer.compare(e, list.get(i)) <= 0) continue;
                list.add(i, creator.create(e));
                continue block0;
            }
            list.add(creator.create(e));
        }
        return list;
    }

    public static int compare(Integer i1, Integer i2) {
        return Integer.signum(i1 - i2);
    }

    public static <E, T> HashMap<E, Integer> createOccurrenceMap(Collection<T> collection, ElementCreator<T, E> creator) {
        HashMap<E, Integer> map = new HashMap<E, Integer>();
        for (T o : collection) {
            E e = creator.create(o);
            Integer nE = (Integer)map.get(e);
            if (nE == null) {
                map.put(e, 1);
                continue;
            }
            map.put(e, nE + 1);
        }
        return map;
    }

    public static <T> T createObject(Class<T> cls, Class<?>[] argTypes, Object[] args) {
        if (argTypes.length != args.length) {
            return null;
        }
        while (argTypes.length >= 0) {
            try {
                Constructor<T> ctor = cls.getConstructor(argTypes);
                return ctor.newInstance(args);
            }
            catch (NoSuchMethodException nsmx) {
                Class[] at = new Class[argTypes.length - 1];
                System.arraycopy(argTypes, 1, at, 0, at.length);
                argTypes = at;
                Object[] a = new Object[at.length];
                System.arraycopy(args, 1, a, 0, a.length);
                args = a;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public static String toString(Iterable<?> collection, String prefix, String separator, String postfix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        int i = 0;
        for (Object e : collection) {
            if (i++ > 0) {
                sb.append(separator);
            }
            sb.append(e);
        }
        if (postfix != null) {
            sb.append(postfix);
        }
        return sb.toString();
    }

    public static String toString(Object[] array, String prefix, String separator, String postfix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(array[i]);
        }
        if (postfix != null) {
            sb.append(postfix);
        }
        return sb.toString();
    }

    private static final class Iteratorable<E>
    implements Iterable<E> {
        Iterator<E> iter;

        public Iteratorable(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public Iterator<E> iterator() {
            Iterator<E> ret = this.iter;
            this.iter = null;
            return ret;
        }
    }
}

