/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;

public class MethodInfoRegistry {
    final int NREG = 10;
    MethodInfo[] registered = new MethodInfo[10];
    int nRegistered = 0;

    public int registerMethodInfo(MethodInfo mi) {
        int idx;
        for (idx = 0; idx < this.nRegistered; ++idx) {
            if (this.registered[idx] != mi) continue;
            return idx;
        }
        if (idx == this.registered.length) {
            MethodInfo[] newReg = new MethodInfo[this.registered.length + 10];
            System.arraycopy(this.registered, 0, newReg, 0, this.registered.length);
            this.registered = newReg;
        }
        this.registered[idx] = mi;
        ++this.nRegistered;
        return idx;
    }

    public MethodInfo getRegisteredFieldInfo(int idx) {
        return this.registered[idx];
    }

    public MethodInfo getMethodInfo(MJIEnv env, int objRef, String fieldName) {
        int idx = env.getIntField(objRef, fieldName);
        assert (idx >= 0 || idx < this.nRegistered) : "illegal MethodInfo request: " + idx + ", " + this.nRegistered;
        return this.registered[idx];
    }
}

