/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;

public final class LongVector {
    public static final int defaultInitCap = 40;
    protected int size;
    protected long[] data;
    protected Growth growth;

    public LongVector(Growth initGrowth, int initCap) {
        this.growth = initGrowth;
        this.data = new long[initCap];
        this.size = 0;
    }

    public LongVector(Growth initGrowth) {
        this(initGrowth, 40);
    }

    public LongVector(int initCap) {
        this(Growth.defaultGrowth, initCap);
    }

    public LongVector() {
        this(Growth.defaultGrowth, 40);
    }

    public void add(long x) {
        if (this.size + 1 > this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size] = x;
        ++this.size;
    }

    public long get(int idx) {
        if (idx >= this.size) {
            return 0L;
        }
        return this.data[idx];
    }

    public void set(int idx, long x) {
        this.ensureSize(idx + 1);
        this.data[idx] = x;
    }

    public void squeeze() {
        while (this.size > 0 && this.data[this.size - 1] == 0L) {
            --this.size;
        }
    }

    public void setSize(int sz) {
        if (sz > this.size) {
            this.ensureCapacity(sz);
            this.size = sz;
        } else {
            while (this.size > sz) {
                --this.size;
                this.data[this.size] = 0L;
            }
        }
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return this.size;
    }

    public void ensureSize(int sz) {
        if (this.size < sz) {
            this.ensureCapacity(sz);
            this.size = sz;
        }
    }

    public void ensureCapacity(int desiredCap) {
        if (this.data.length < desiredCap) {
            long[] newData = new long[this.growth.grow(this.data.length, desiredCap)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public static void copy(LongVector src, int srcPos, LongVector dst, int dstPos, int len) {
        if (len == 0) {
            return;
        }
        src.ensureCapacity(srcPos + len);
        dst.ensureSize(dstPos + len);
        System.arraycopy(src.data, srcPos, dst.data, dstPos, len);
    }
}

