/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;

public final class IntVector
implements Comparable<IntVector> {
    public static final int defaultInitCap = 40;
    protected int size;
    protected int[] data;
    protected Growth growth;

    public IntVector(Growth initGrowth, int initCap) {
        this.growth = initGrowth;
        this.data = new int[initCap];
        this.size = 0;
    }

    public IntVector(int[] init) {
        this(Growth.defaultGrowth, init.length);
        this.size = init.length;
        System.arraycopy(init, 0, this.data, 0, this.size);
    }

    public IntVector(Growth initGrowth) {
        this(initGrowth, 40);
    }

    public IntVector(int initCap) {
        this(Growth.defaultGrowth, initCap);
    }

    public IntVector() {
        this(Growth.defaultGrowth, 40);
    }

    public void add(int x) {
        if (this.size + 1 > this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size] = x;
        ++this.size;
    }

    public void add2(int x1, int x2) {
        if (this.size + 2 > this.data.length) {
            this.ensureCapacity(this.size + 2);
        }
        this.data[this.size] = x1;
        ++this.size;
        this.data[this.size] = x2;
        ++this.size;
    }

    public void add3(int x1, int x2, int x3) {
        if (this.size + 3 > this.data.length) {
            this.ensureCapacity(this.size + 3);
        }
        this.data[this.size] = x1;
        ++this.size;
        this.data[this.size] = x2;
        ++this.size;
        this.data[this.size] = x3;
        ++this.size;
    }

    public void addZeros(int length) {
        int newSize = this.size + length;
        if (newSize > this.data.length) {
            this.ensureCapacity(this.size + length);
        }
        for (int i = this.size; i < newSize; ++i) {
            this.data[i] = 0;
        }
        this.size = newSize;
    }

    public void append(int[] x) {
        if (this.size + x.length > this.data.length) {
            this.ensureCapacity(this.size + x.length);
        }
        System.arraycopy(x, 0, this.data, this.size, x.length);
        this.size += x.length;
    }

    public void append(int[] x, int pos, int len) {
        if (this.size + len > this.data.length) {
            this.ensureCapacity(this.size + len);
        }
        System.arraycopy(x, pos, this.data, this.size, len);
        this.size += len;
    }

    public void append(IntVector x) {
        if (x == null) {
            return;
        }
        if (this.size + x.size > this.data.length) {
            this.ensureCapacity(this.size + x.size);
        }
        System.arraycopy(x.data, 0, this.data, this.size, x.size);
        this.size += x.size;
    }

    public int get(int idx) {
        if (idx >= this.size) {
            return 0;
        }
        return this.data[idx];
    }

    public void set(int idx, int x) {
        this.ensureSize(idx + 1);
        this.data[idx] = x;
    }

    public int[] toArray(int[] dst) {
        System.arraycopy(this.data, 0, dst, 0, this.size);
        return dst;
    }

    public int dumpTo(int[] dst, int pos) {
        System.arraycopy(this.data, 0, dst, pos, this.size);
        return pos + this.size;
    }

    public void squeeze() {
        while (this.size > 0 && this.data[this.size - 1] == 0) {
            --this.size;
        }
    }

    public void setSize(int sz) {
        if (sz > this.size) {
            this.ensureCapacity(sz);
            this.size = sz;
        } else {
            while (this.size > sz) {
                --this.size;
                this.data[this.size] = 0;
            }
        }
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int[] out = new int[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void ensureSize(int sz) {
        if (this.size < sz) {
            this.ensureCapacity(sz);
            this.size = sz;
        }
    }

    public void ensureCapacity(int desiredCap) {
        if (this.data.length < desiredCap) {
            int[] newData = new int[this.growth.grow(this.data.length, desiredCap)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public static void copy(IntVector src, int srcPos, IntVector dst, int dstPos, int len) {
        if (len == 0) {
            return;
        }
        src.ensureCapacity(srcPos + len);
        dst.ensureSize(dstPos + len);
        System.arraycopy(src.data, srcPos, dst.data, dstPos, len);
    }

    public static void copy(int[] src, int srcPos, IntVector dst, int dstPos, int len) {
        if (len == 0) {
            return;
        }
        dst.ensureSize(dstPos + len);
        System.arraycopy(src, srcPos, dst.data, dstPos, len);
    }

    public static void copy(IntVector src, int srcPos, int[] dst, int dstPos, int len) {
        if (len == 0) {
            return;
        }
        src.ensureCapacity(srcPos + len);
        System.arraycopy(src.data, srcPos, dst, dstPos, len);
    }

    @Override
    public int compareTo(IntVector that) {
        if (that == null) {
            return this.size;
        }
        int smaller = Math.min(this.size, that.size);
        for (int i = 0; i < smaller; ++i) {
            int comp = this.data[i] - that.data[i];
            if (comp == 0) continue;
            return comp;
        }
        return this.size - that.size;
    }
}

