/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.ObjArray;
import java.util.Iterator;

public final class IntTable<E>
implements Iterable<Entry<E>> {
    static final int INIT_TBL_POW = 7;
    static final double MAX_LOAD = 0.8;
    protected ObjArray<Entry<E>> table;
    protected int tblPow;
    protected int mask;
    protected int nextRehash;
    protected int size;
    protected Entry<E> nullEntry = null;

    public IntTable() {
        this(7);
    }

    public IntTable(int pow) {
        this.newTable(pow);
        this.size = 0;
    }

    protected void newTable(int pow) {
        this.tblPow = pow;
        this.table = new ObjArray(1 << this.tblPow);
        this.mask = this.table.length() - 1;
        this.nextRehash = (int)Math.ceil(0.8 * (double)this.table.length());
    }

    protected int getTableIndex(E key) {
        int hc = key.hashCode();
        int ret = hc ^ 0x2EE39CA3;
        return ((ret += hc >>> this.tblPow) ^ 0x5CE33652) & this.mask;
    }

    protected boolean maybeRehash() {
        if (this.size < this.nextRehash) {
            return false;
        }
        ObjArray<Entry<E>> old = this.table;
        this.newTable(this.tblPow + 1);
        int len = old.length();
        for (int i = 0; i < len; ++i) {
            this.addList(old.get(i));
        }
        return true;
    }

    private void addList(Entry<E> e) {
        Entry<E> cur = e;
        while (cur != null) {
            Entry<E> tmp = cur;
            cur = cur.next;
            this.doAdd(tmp, this.getTableIndex(tmp.key));
        }
    }

    private void doAdd(Entry<E> e, int idx) {
        e.next = this.table.get(idx);
        this.table.set(idx, e);
    }

    protected Entry<E> getHelper(E key, int idx) {
        Entry<E> cur = this.table.get(idx);
        while (cur != null) {
            if (cur.key.equals(key)) {
                return cur;
            }
            cur = cur.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void add(E key, int val) {
        Entry<E> e = new Entry<E>(key, val);
        if (key == null) {
            this.nullEntry = e;
        } else {
            this.maybeRehash();
            this.doAdd(e, this.getTableIndex(key));
        }
        ++this.size;
    }

    public Entry<E> get(E key) {
        return this.getHelper(key, this.getTableIndex(key));
    }

    public void put(E key, int val) {
        if (key == null) {
            if (this.nullEntry == null) {
                this.nullEntry = new Entry<Object>(null, val);
                ++this.size;
            } else {
                this.nullEntry.val = val;
            }
            return;
        }
        int idx = this.getTableIndex(key);
        Entry<E> e = this.getHelper(key, idx);
        if (e == null) {
            this.maybeRehash();
            this.doAdd(new Entry<E>(key, val), idx);
            ++this.size;
        } else {
            e.val = val;
        }
    }

    public Entry<E> remove(E key) {
        int idx = this.getTableIndex(key);
        Entry<E> prev = null;
        Entry<E> cur = this.table.get(idx);
        while (cur != null) {
            if (cur.key.equals(key)) {
                if (prev == null) {
                    this.table.set(idx, cur.next);
                } else {
                    prev.next = cur.next;
                }
                cur.next = null;
                --this.size;
                return cur;
            }
            prev = cur;
            cur = cur.next;
        }
        return null;
    }

    public void clear() {
        this.table.nullify();
        this.nullEntry = null;
        this.size = 0;
    }

    public int nextPoolVal() {
        return this.size;
    }

    public Entry<E> pool(E key) {
        if (key == null) {
            if (this.nullEntry == null) {
                this.nullEntry = new Entry<Object>(null, this.size);
                ++this.size;
            }
            return this.nullEntry;
        }
        int idx = this.getTableIndex(key);
        Entry<E> e = this.getHelper(key, idx);
        if (e == null) {
            if (this.maybeRehash()) {
                idx = this.getTableIndex(key);
            }
            e = new Entry<E>(key, this.size);
            this.doAdd(e, idx);
            ++this.size;
        }
        return e;
    }

    public int poolIndex(E key) {
        return this.pool(key).val;
    }

    public E poolKey(E key) {
        return this.pool(key).key;
    }

    public boolean hasEntry(E key) {
        return this.get(key) != null;
    }

    @Override
    public Iterator<Entry<E>> iterator() {
        return new TblIterator();
    }

    public static void main(String[] args) {
        int i;
        IntTable<String> tbl = new IntTable<String>(4);
        int max = Integer.parseInt(args[0]);
        for (i = 0; i < max; ++i) {
            tbl.add("foo" + i, i + 3);
        }
        for (i = 0; i < max; ++i) {
            if (tbl.get(new StringBuilder().append((String)"foo").append((int)i).toString()).val == i + 3) continue;
            throw new RuntimeException();
        }
    }

    protected class TblIterator
    implements Iterator<Entry<E>> {
        int idx = -1;
        Entry<E> cur = null;

        public TblIterator() {
            this.advance();
        }

        void advance() {
            if (this.cur != null) {
                this.cur = this.cur.next;
            }
            int len = IntTable.this.table.length();
            while (this.idx < len && this.cur == null) {
                ++this.idx;
                if (this.idx >= len) continue;
                this.cur = IntTable.this.table.get(this.idx);
            }
        }

        @Override
        public boolean hasNext() {
            return this.idx < IntTable.this.table.length();
        }

        @Override
        public Entry<E> next() {
            Entry e = this.cur;
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry<E> {
        public final E key;
        public int val;
        protected Entry<E> next;

        protected Entry(E k, int v) {
            this.key = k;
            this.val = v;
            this.next = null;
        }

        protected Entry(E k, int v, Entry<E> n) {
            this.key = k;
            this.val = v;
            this.next = n;
        }

        public String toString() {
            return this.key.toString() + " => " + this.val;
        }
    }
}

