/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DefaultInstructionFactory;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.StringSetMatcher;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.InstructionHandle;

public abstract class GenericInstructionFactory
extends DefaultInstructionFactory {
    protected static final String BCEL_PACKAGE = "org.apache.bcel.generic.";
    static Logger log = JPF.getLogger("gov.nasa.jpf.bytecode");
    protected String[] bcNames;
    protected String bcPrefix;
    protected StringSetMatcher includes;
    protected StringSetMatcher excludes;
    ClassInfo ciLeaf;
    ClassInfo ciRoot;
    protected HashMap<Class<?>, Class<? extends Instruction>> ownBcel2jpf;
    protected HashMap<String, Class<? extends Instruction>> ownMap;

    protected GenericInstructionFactory(Config conf, String bcPrefix, String[] bcNames, String[] includeCls, String[] excludeCls) {
        super(conf);
        this.bcPrefix = bcPrefix;
        this.bcNames = bcNames;
        this.includes = StringSetMatcher.getNonEmpty(includeCls);
        this.excludes = StringSetMatcher.getNonEmpty(excludeCls);
        this.createMaps();
    }

    public void setLeafClassInfo(ClassInfo ciLeaf) {
        this.ciLeaf = ciLeaf;
    }

    public void setRootClassInfo(ClassInfo ciRoot) {
        this.ciRoot = ciRoot;
    }

    protected void createMaps() {
        this.ownBcel2jpf = new HashMap(this.bcNames.length);
        this.ownMap = new HashMap(this.bcNames.length);
        for (String cls : this.bcNames) {
            Class<?> bcelCls = null;
            Class<?> extCls = null;
            try {
                extCls = this.loader.loadClass(this.bcPrefix + cls);
            }
            catch (ClassNotFoundException cnfx) {
                log.warning("could not load overridden instruction class: " + cnfx.getMessage());
            }
            try {
                bcelCls = this.loader.loadClass(BCEL_PACKAGE + cls);
            }
            catch (ClassNotFoundException x1) {
                // empty catch block
            }
            this.ownBcel2jpf.put(bcelCls, extCls);
            this.ownMap.put(cls, extCls);
        }
    }

    public boolean isInstrumentedClass(ClassInfo ci) {
        if (ci == null) {
            return true;
        }
        String clsName = ci.getName();
        return !(!StringSetMatcher.isMatch(clsName, this.includes, this.excludes) || this.ciLeaf != null && !this.ciLeaf.isInstanceOf(ci) || this.ciRoot != null && !ci.isInstanceOf(this.ciRoot));
    }

    @Override
    public Instruction create(InstructionHandle h, int offset, MethodInfo m, ConstantPool cp) {
        try {
            Class<? extends Instruction> insnCls;
            if (this.isInstrumentedClass(m.getClassInfo()) && (insnCls = this.ownBcel2jpf.get(h.getInstruction().getClass())) != null) {
                Instruction insn = insnCls.newInstance();
                insn.init(h, offset, m, cp);
                return insn;
            }
            return super.create(h, offset, m, cp);
        }
        catch (Throwable e) {
            throw new JPFException("creation of instruction " + h.getInstruction() + " failed: " + e);
        }
    }

    @Override
    public Instruction create(ClassInfo ciMth, String insnClsName) {
        try {
            Class<? extends Instruction> insnCls;
            if (this.isInstrumentedClass(ciMth) && (insnCls = this.ownMap.get(insnClsName)) != null) {
                return insnCls.newInstance();
            }
            return super.create(ciMth, insnClsName);
        }
        catch (Throwable e) {
            throw new JPFException("creation of instruction " + insnClsName + " failed: " + e);
        }
    }
}

