/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;
import java.util.Iterator;

public final class DynamicObjectArray<E>
implements Iterable<E> {
    static final int DEFAULT_CHUNKBITS = 8;
    static final int INIT_CHUNKS = 16;
    Growth growth;
    int chunkBits;
    int nPerChunk;
    int chunkMask;
    Object[][] data;
    int maxIndex = -1;

    public DynamicObjectArray() {
        this(Growth.defaultGrowth, 8, 16);
    }

    public DynamicObjectArray(int chunkBits, int initChunks) {
        this(Growth.defaultGrowth, chunkBits, initChunks);
    }

    public DynamicObjectArray(Growth strategy, int chunkBits, int initChunks) {
        if (chunkBits > 20) {
            throw new IllegalArgumentException();
        }
        this.chunkBits = chunkBits;
        this.nPerChunk = 1 << chunkBits;
        this.chunkMask = this.nPerChunk - 1;
        this.data = new Object[initChunks][];
        this.growth = strategy;
    }

    @Override
    public Iterator<E> iterator() {
        return new DynIterator();
    }

    public E get(int index) {
        int i = index >> this.chunkBits;
        if (i < this.data.length && this.data[i] != null) {
            int j = index & this.chunkMask;
            return (E)this.data[i][j];
        }
        return null;
    }

    public int size() {
        return this.data.length * this.nPerChunk;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void set(int index, E value) {
        if (index > this.maxIndex) {
            this.maxIndex = index;
        }
        int i = index >> this.chunkBits;
        int j = index & this.chunkMask;
        if (i >= this.data.length) {
            int nChunks = this.growth.grow(this.data.length, i + 1);
            Object[][] newChunks = new Object[nChunks][];
            System.arraycopy(this.data, 0, newChunks, 0, this.data.length);
            this.data = newChunks;
        }
        if (this.data[i] == null) {
            this.data[i] = new Object[1 << this.chunkBits];
        }
        this.data[i][j] = value;
    }

    public String toString() {
        int length;
        for (length = this.data.length * (1 << this.chunkBits); length > 1 && this.get(length - 1) == null; --length) {
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append('{');
        int l = length - 1;
        for (int i = 0; i < l; ++i) {
            sb.append(this.get(i));
            sb.append(',');
        }
        sb.append(this.get(l));
        sb.append('}');
        return sb.toString();
    }

    class DynIterator
    implements Iterator<E> {
        int i;

        DynIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < DynamicObjectArray.this.size();
        }

        @Override
        public E next() {
            return DynamicObjectArray.this.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

