/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Printable;
import java.io.PrintWriter;

public class Debug {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int MESSAGE = 2;
    public static final int DEBUG = 3;
    private static final int LAST_LEVEL = 4;
    public static final int DEFAULT = 0;
    public static final int RACE = 1;
    public static final int LOCK_ORDER = 2;
    public static final int DEPEND = 3;
    public static final int DISTRIBUTED = 4;
    public static final int SEARCH = 5;
    public static final int TRACE = 6;
    private static final int LAST_KIND = 7;
    private static int[] enabled = new int[7];
    private static String[] levels = new String[]{"error", "warning", "message", "debug"};
    private static String[] kinds = new String[]{"default", "race", "lock-order", "depend", "distributed", "search", "trace"};

    public static void setDebugLevel(int l) {
        if (l < 0 || l >= 4) {
            throw new IllegalArgumentException("0 <= level < 4");
        }
        Debug.enabled[0] = l;
    }

    public static void setDebugLevel(String ls) {
        int l = Debug.mapLevel(ls);
        if (l == -1) {
            throw new IllegalArgumentException(ls + " is not a valid level");
        }
        Debug.enabled[0] = l;
    }

    public static void setDebugLevel(int l, int k) {
        if (l < 0 || l >= 4) {
            throw new IllegalArgumentException("0 <= level < 4");
        }
        if (k < 0 || k >= 7) {
            throw new IllegalArgumentException("0 <= kind < 7");
        }
        Debug.enabled[k] = l;
    }

    public static void setDebugLevel(int l, String ks) {
        if (l < 0 || l >= 4) {
            throw new IllegalArgumentException("0 <= level < 4");
        }
        int k = Debug.mapKind(ks);
        if (k == -1) {
            throw new IllegalArgumentException(ks + " is not a valid kind");
        }
        Debug.enabled[k] = l;
    }

    public static void setDebugLevel(String ls, int k) {
        if (k < 0 || k >= 7) {
            throw new IllegalArgumentException("0 <= kind < 7");
        }
        int l = Debug.mapLevel(ls);
        if (l == -1) {
            throw new IllegalArgumentException(ls + " is not a valid level");
        }
        Debug.enabled[k] = l;
    }

    public static void setDebugLevel(String ls, String ks) {
        int l = Debug.mapLevel(ls);
        if (l == -1) {
            throw new IllegalArgumentException(ls + " is not a valid level");
        }
        int k = Debug.mapKind(ks);
        if (k == -1) {
            throw new IllegalArgumentException(ks + " is not a valid kind");
        }
        Debug.enabled[k] = l;
    }

    public static int getDebugLevel() {
        return enabled[0];
    }

    public static int getDebugLevel(int k) {
        return enabled[k];
    }

    public static int getDebugLevel(String ks) {
        int k = Debug.mapKind(ks);
        if (k == -1) {
            throw new IllegalArgumentException(ks + " is not a valid kind");
        }
        return enabled[k];
    }

    public static int mapKind(String ks) {
        for (int k = 0; k < 7; ++k) {
            if (!ks.equals(kinds[k])) continue;
            return k;
        }
        return -1;
    }

    public static int mapLevel(String ls) {
        for (int l = 0; l < 4; ++l) {
            if (!ls.equals(levels[l])) continue;
            return l;
        }
        return -1;
    }

    public static void print(int l, Object o) {
        if (l <= enabled[0]) {
            System.err.print(o);
        }
    }

    public static void print(int l, String s) {
        if (l <= enabled[0]) {
            System.err.print(s);
        }
    }

    public static void print(int l, int k, Object o) {
        if (l <= enabled[k]) {
            System.err.print(o);
        }
    }

    public static void print(int l, int k, String s) {
        if (l <= enabled[k]) {
            System.err.print(s);
        }
    }

    public static void print(int l, int k, Printable p) {
        if (l <= enabled[k]) {
            PrintWriter pw = new PrintWriter(System.err, true);
            p.printOn(pw);
        }
    }

    public static void print(int l, Printable p) {
        Debug.print(l, 0, p);
    }

    public static void println(int l, int k, Printable p) {
        if (l <= enabled[k]) {
            PrintWriter pw = new PrintWriter(System.err, true);
            p.printOn(pw);
            System.err.println();
        }
    }

    public static void println(int l, Printable p) {
        Debug.println(l, 0, p);
    }

    public static void println(int l) {
        if (l <= enabled[0]) {
            System.err.println();
        }
    }

    public static void println(int l, Object o) {
        if (l <= enabled[0]) {
            System.err.println(o);
        }
    }

    public static void println(int l, String s) {
        if (l <= enabled[0]) {
            System.err.println(s);
        }
    }

    public static void println(int l, int k) {
        if (l <= enabled[k]) {
            System.err.println();
        }
    }

    public static void println(int l, int k, Object o) {
        if (l <= enabled[k]) {
            System.err.println(o);
        }
    }

    public static void println(int l, int k, String s) {
        if (l <= enabled[k]) {
            System.err.println(s);
        }
    }

    public static String status() {
        StringBuilder sb = new StringBuilder();
        for (int k = 1; k < 7; ++k) {
            int l = enabled[k];
            if (l == 0) continue;
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(kinds[k]);
            sb.append('=');
            sb.append(levels[l]);
        }
        return sb.toString();
    }
}

