/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;

public class ConstGrowth
implements Growth {
    final int v;

    public ConstGrowth(int v) {
        if (v < 1 || v > 1000000000) {
            throw new IllegalArgumentException();
        }
        this.v = v;
    }

    @Override
    public int grow(int oldSize, int minNewSize) {
        int newSize = oldSize + this.v;
        if (newSize < minNewSize) {
            newSize = minNewSize + (this.v >> 1);
        }
        return newSize;
    }
}

