/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import java.util.Arrays;
import java.util.BitSet;

public class BitArray {
    public final int length;
    final byte[] data;
    public static final BitArray empty = new BitArray(0);

    public BitArray(int len) {
        this.length = len;
        this.data = new byte[len + 7 >> 3];
    }

    public void fromBitSet(BitSet in) {
        int max = Math.min(this.data.length, in.length() + 7 >> 3);
        for (int i = 0; i < max; ++i) {
            int j = i << 3;
            this.data[i] = (byte)((in.get(j + 0) ? 1 : 0) | (in.get(j + 1) ? 2 : 0) | (in.get(j + 2) ? 4 : 0) | (in.get(j + 3) ? 8 : 0) | (in.get(j + 4) ? 16 : 0) | (in.get(j + 5) ? 32 : 0) | (in.get(j + 6) ? 64 : 0) | (in.get(j + 7) ? 128 : 0));
        }
        Arrays.fill(this.data, max, this.data.length, (byte)0);
    }

    public final void set(int idx, boolean val) {
        if (idx >= this.length) {
            throw new ArrayIndexOutOfBoundsException("" + idx + " >= " + this.length);
        }
        if (val) {
            int n = idx >> 3;
            this.data[n] = (byte)(this.data[n] | 1 << (idx & 7));
        } else {
            int n = idx >> 3;
            this.data[n] = (byte)(this.data[n] & ~(1 << (idx & 7)));
        }
    }

    public final void set(int idx, int val) {
        this.set(idx, val != 0);
    }

    public final void set(int idx) {
        if (idx >= this.length) {
            throw new ArrayIndexOutOfBoundsException("" + idx + " >= " + this.length);
        }
        int n = idx >> 3;
        this.data[n] = (byte)(this.data[n] | 1 << (idx & 7));
    }

    public final void clear(int idx) {
        if (idx >= this.length) {
            throw new ArrayIndexOutOfBoundsException("" + idx + " >= " + this.length);
        }
        int n = idx >> 3;
        this.data[n] = (byte)(this.data[n] & ~(1 << (idx & 7)));
    }

    public final void setAll() {
        Arrays.fill(this.data, (byte)-1);
        this.cleanup();
    }

    public final void clearAll() {
        Arrays.fill(this.data, (byte)0);
    }

    public final void invert() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = ~this.data[i];
        }
        this.cleanup();
    }

    final void cleanup() {
        if ((this.length & 7) != 0) {
            int idx;
            int n = idx = this.data.length - 1;
            this.data[n] = (byte)(this.data[n] & ~(255 << (this.length & 7)));
        }
    }

    public final boolean get(int idx) {
        int a = idx >> 3;
        return a < this.data.length && a >= 0 && (this.data[a] & 1 << (idx & 7)) != 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitArray)) {
            return false;
        }
        byte[] thatData = ((BitArray)o).data;
        byte[] thisData = this.data;
        return Arrays.equals(thisData, thatData);
    }
}

