/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadChoiceGenerator;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.MONITORENTER;
import gov.nasa.jpf.jvm.bytecode.MONITOREXIT;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.report.ConsolePublisher;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.PublisherExtension;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.ElementCreator;
import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.TwoTypeComparator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StateSpaceAnalyzer
extends ListenerAdapter
implements PublisherExtension {
    int maxStates;
    long maxTime;
    long maxMemory;
    long startTime;
    ArrayList<ChoiceGenerator> cgs;
    int nEndStates;
    int nVisitedStates;
    int nNewStates;
    int nTotalInsn;
    int nNewStateInsn;
    int nMaxInsnPerNewState = -1;
    int nMinInsnPerNewState = Integer.MAX_VALUE;
    int nInsn;
    int maxInsns;

    public StateSpaceAnalyzer(Config config, JPF jpf) {
        this.maxStates = config.getInt("ssa.max_states", Integer.MAX_VALUE);
        this.maxTime = config.getDuration("ssa.max_time", Long.MAX_VALUE);
        this.maxMemory = config.getMemorySize("ssa.max_memory", Long.MAX_VALUE);
        this.maxInsns = config.getInt("ssa.max_insn", 10);
        this.cgs = new ArrayList();
        jpf.addPublisherExtension(ConsolePublisher.class, this);
    }

    HashMap<Instruction, ArrayList<ChoiceGenerator>> getCGInsnMap() {
        HashMap<Instruction, ArrayList<ChoiceGenerator>> map = new HashMap<Instruction, ArrayList<ChoiceGenerator>>();
        for (ChoiceGenerator cg : this.cgs) {
            Instruction insn = cg.getInsn();
            ArrayList<ChoiceGenerator<Object>> list = map.get(insn);
            if (list == null) {
                list = new ArrayList();
                map.put(insn, list);
            }
            list.add(cg);
        }
        return map;
    }

    static int getChoiceCount(ArrayList<ChoiceGenerator> list) {
        int n = 0;
        for (ChoiceGenerator cg : list) {
            n += cg.getTotalNumberOfChoices();
        }
        return n;
    }

    ArrayList<InsnInfo> getSortedCGInsnList(HashMap<Instruction, ArrayList<ChoiceGenerator>> map) {
        return Misc.createSortedList(map, new TwoTypeComparator<Map.Entry<Instruction, ArrayList<ChoiceGenerator>>, InsnInfo>(){

            @Override
            public int compare(Map.Entry<Instruction, ArrayList<ChoiceGenerator>> e, InsnInfo ii) {
                return Integer.signum(e.getValue().size() - ii.cgList.size());
            }
        }, new ElementCreator<Map.Entry<Instruction, ArrayList<ChoiceGenerator>>, InsnInfo>(){

            @Override
            public InsnInfo create(Map.Entry<Instruction, ArrayList<ChoiceGenerator>> e) {
                return new InsnInfo(e.getKey(), e.getValue());
            }
        });
    }

    ArrayList<InsnInfo> getSortedChoiceInsnList(HashMap<Instruction, ArrayList<ChoiceGenerator>> map) {
        return Misc.createSortedList(map, new TwoTypeComparator<Map.Entry<Instruction, ArrayList<ChoiceGenerator>>, InsnInfo>(){

            @Override
            public int compare(Map.Entry<Instruction, ArrayList<ChoiceGenerator>> e, InsnInfo ii) {
                return Integer.signum(StateSpaceAnalyzer.getChoiceCount(e.getValue()) - ii.nChoices);
            }
        }, new ElementCreator<Map.Entry<Instruction, ArrayList<ChoiceGenerator>>, InsnInfo>(){

            @Override
            public InsnInfo create(Map.Entry<Instruction, ArrayList<ChoiceGenerator>> e) {
                return new InsnInfo(e.getKey(), e.getValue());
            }
        });
    }

    void printSortedCGThreadsOn(PrintWriter pw, InsnInfo ii) {
        HashMap<ThreadInfo, Integer> tiMap = Misc.createOccurrenceMap(ii.cgList, new ElementCreator<ChoiceGenerator, ThreadInfo>(){

            @Override
            public ThreadInfo create(ChoiceGenerator cg) {
                return cg.getThreadInfo();
            }
        });
        ArrayList<Map.Entry<ThreadInfo, Integer>> list = Misc.createSortedEntryList(tiMap, new Comparator<Map.Entry<ThreadInfo, Integer>>(){

            @Override
            public int compare(Map.Entry<ThreadInfo, Integer> e1, Map.Entry<ThreadInfo, Integer> e2) {
                return Integer.signum(e1.getValue() - e2.getValue());
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry<ThreadInfo, Integer> e = list.get(i);
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(e.getKey().getName());
            pw.print(": ");
            pw.print(e.getValue());
        }
    }

    void printSortedCGInsnListOn(PrintWriter pw) {
        HashMap<Instruction, ArrayList<ChoiceGenerator>> map = this.getCGInsnMap();
        ArrayList<InsnInfo> insns = this.getSortedChoiceInsnList(map);
        for (int i = 0; i < insns.size(); ++i) {
            InsnInfo ii = (InsnInfo)insns.get(i);
            pw.println("  loc:     " + ii.insn.getFileLocation());
            pw.println("  src:     \"" + ii.insn.getSourceLine().trim() + '\"');
            pw.println("  insn:    " + ii.insn);
            pw.print("  cg:      " + ii.cgList.get(0).getClass().getName());
            pw.println(": " + ii.cgList.size() + ", choices: " + ii.nChoices);
            pw.print("  threads: ");
            this.printSortedCGThreadsOn(pw, ii);
            pw.println();
            pw.println();
            if (i < this.maxInsns - 1) continue;
            pw.println("  ...");
            break;
        }
    }

    void printCGStatisticsOn(PrintWriter pw) {
        int nWait = 0;
        int nNotify = 0;
        int nSyncCall = 0;
        int nSyncReturn = 0;
        int nSyncEnter = 0;
        int nSyncExit = 0;
        int nTerminate = 0;
        int nStart = 0;
        int nField = 0;
        for (ChoiceGenerator cg : this.cgs) {
            if (!(cg instanceof ThreadChoiceGenerator)) continue;
            Instruction insn = cg.getInsn();
            if (insn instanceof InvokeInstruction) {
                MethodInfo mi = ((InvokeInstruction)insn).getInvokedMethod();
                String mname = mi.getName();
                String cname = mi.getClassInfo().getName();
                if ("java.lang.Object".equals(cname)) {
                    if ("wait".equals(mname)) {
                        ++nWait;
                    } else if ("notify".equals(mname) || "notifyAll".equals(mname)) {
                        ++nNotify;
                    }
                } else if ("java.lang.Thread".equals(cname) && "start".equals(mname)) {
                    ++nStart;
                }
                if (!mi.isSynchronized()) continue;
                ++nSyncCall;
                continue;
            }
            if (insn instanceof MONITORENTER) {
                ++nSyncEnter;
                continue;
            }
            if (insn instanceof MONITOREXIT) {
                ++nSyncExit;
                continue;
            }
            if (insn instanceof ReturnInstruction) {
                if ("run".equals(insn.getMethodInfo().getName())) {
                    ++nTerminate;
                    continue;
                }
                ++nSyncReturn;
                continue;
            }
            if (!(insn instanceof FieldInstruction)) continue;
            ++nField;
        }
        HashMap<Class, Integer> map = Misc.createOccurrenceMap(this.cgs, new ElementCreator<ChoiceGenerator, Class>(){

            @Override
            public Class create(ChoiceGenerator cg) {
                if (cg instanceof ThreadChoiceGenerator) {
                    return ThreadChoiceGenerator.class;
                }
                return cg.getClass();
            }
        });
        ArrayList<Map.Entry<Class, Integer>> list = Misc.createSortedEntryList(map, new Comparator<Map.Entry<Class, Integer>>(){

            @Override
            public int compare(Map.Entry<Class, Integer> e1, Map.Entry<Class, Integer> e2) {
                return Integer.signum(e1.getValue() - e2.getValue());
            }
        });
        for (Map.Entry<Class, Integer> e : list) {
            pw.print("  ");
            pw.print(e.getKey().getName());
            pw.print(": ");
            pw.println(e.getValue());
            if (e.getKey() != ThreadChoiceGenerator.class) continue;
            pw.println("\tsignal:       " + nWait + " - " + nNotify);
            pw.println("\tsync call:    " + nSyncCall + " - " + nSyncReturn);
            pw.println("\tsync block:   " + nSyncEnter + " - " + nSyncExit);
            pw.println("\tthread:       " + nStart + " - " + nTerminate);
            pw.println("\tshared field: " + nField);
        }
    }

    @Override
    public void searchStarted(Search search) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.isNewState()) {
            this.nNewStateInsn += this.nInsn;
            ++this.nNewStates;
            if (this.nInsn > this.nMaxInsnPerNewState) {
                this.nMaxInsnPerNewState = this.nInsn;
            }
            if (this.nInsn < this.nMinInsnPerNewState) {
                this.nMinInsnPerNewState = this.nInsn;
            }
            if (search.isEndState()) {
                ++this.nEndStates;
            }
        } else {
            ++this.nVisitedStates;
        }
        this.nTotalInsn += this.nInsn;
        this.nInsn = 0;
        if (System.currentTimeMillis() - this.startTime > this.maxTime || this.nNewStates > this.maxStates || Runtime.getRuntime().totalMemory() > this.maxMemory) {
            search.terminate();
        }
    }

    @Override
    public void choiceGeneratorSet(JVM vm) {
        this.cgs.add(vm.getLastChoiceGenerator());
    }

    @Override
    public void objectLocked(JVM vm) {
    }

    @Override
    public void objectUnlocked(JVM vm) {
    }

    @Override
    public void objectWait(JVM vm) {
    }

    @Override
    public void objectNotify(JVM vm) {
    }

    @Override
    public void objectNotifyAll(JVM vm) {
    }

    @Override
    public void threadBlocked(JVM vm) {
    }

    @Override
    public void publishFinished(Publisher publisher) {
        PrintWriter pw = publisher.getOut();
        publisher.publishTopicStart("CG statistics");
        this.printCGStatisticsOn(pw);
        publisher.publishTopicStart("CG instructions");
        this.printSortedCGInsnListOn(pw);
    }

    static class InsnInfo {
        Instruction insn;
        ArrayList<ChoiceGenerator> cgList;
        int nChoices;

        InsnInfo(Instruction insn, ArrayList<ChoiceGenerator> cgList) {
            this.insn = insn;
            this.cgList = cgList;
            this.nChoices = StateSpaceAnalyzer.getChoiceCount(cgList);
        }
    }
}

