/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.GETFIELD;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import java.util.HashMap;

public class SharedChecker
extends ListenerAdapter {
    HashMap<ClassInfo, String[]> trackedClasses = new HashMap();
    HashMap<Integer, String[]> trackedObjects = new HashMap();

    @Override
    public void classLoaded(JVM vm) {
        ClassInfo ci = vm.getLastClassInfo();
        if (ci.getAnnotation("gov.nasa.jpf.NonShared") != null) {
            this.trackedClasses.put(ci, new String[1]);
        } else {
            AnnotationInfo ai = ci.getAnnotation("gov.nasa.jpf.Shared");
            if (ai != null) {
                String[] threadNames = ai.getValueAsStringArray();
                this.trackedClasses.put(ci, threadNames);
            }
        }
    }

    @Override
    public void objectCreated(JVM vm) {
        ElementInfo ei = vm.getLastElementInfo();
        ClassInfo ci = ei.getClassInfo();
        String[] threadNames = this.trackedClasses.get(ci);
        if (threadNames != null) {
            ThreadInfo ti = vm.getLastThreadInfo();
            if (threadNames[0] == null) {
                threadNames[0] = ti.getName();
            } else if (!this.isValidThread(ti, threadNames)) {
                Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", this.createErrorMessage(ti, ei, threadNames, "created"));
                ti.setNextPC(nextPc);
            }
            this.trackedObjects.put(ei.getIndex(), threadNames);
        }
    }

    private boolean isValidThread(ThreadInfo ti, String[] threadNames) {
        String tn = ti.getName();
        for (int i = 0; i < threadNames.length; ++i) {
            if (!tn.equals(threadNames[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void objectReleased(JVM vm) {
        ElementInfo ei = vm.getLastElementInfo();
        this.trackedObjects.remove(ei.getIndex());
    }

    String createErrorMessage(ThreadInfo ti, ElementInfo ei, String[] threadNames, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("@[Non]Shared object ");
        sb.append(ei);
        sb.append("\n\t\t");
        sb.append(msg);
        sb.append(" from: ");
        sb.append(ti.getName());
        sb.append(", allowed: {");
        for (int i = 0; i < threadNames.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(threadNames[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    boolean checkIllegalAccess(ThreadInfo ti, ElementInfo ei) {
        String[] threadNames;
        if (ei != null && (threadNames = this.trackedObjects.get(ei.getIndex())) != null && !this.isValidThread(ti, threadNames)) {
            Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", this.createErrorMessage(ti, ei, threadNames, "referenced"));
            ti.setNextPC(nextPc);
            return true;
        }
        return false;
    }

    @Override
    public void instructionExecuted(JVM vm) {
        GETFIELD get;
        Instruction insn = vm.getLastInstruction();
        if (insn instanceof GETFIELD && (get = (GETFIELD)insn).isReferenceField()) {
            ThreadInfo ti = vm.getLastThreadInfo();
            int ref = ti.peek();
            ElementInfo ei = ti.getElementInfo(ref);
            this.checkIllegalAccess(ti, ei);
        }
    }
}

