/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.search.heuristic.HeuristicSearch;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;

public class SearchMonitor
extends ListenerAdapter {
    static final String DEF_HOSTNAME = "localhost";
    static final int DEF_INTERVAL = 10000;
    String hostName;
    int port;
    Socket sock;
    PrintWriter out;
    int reportNumber;
    int interval;
    long time;
    long lastTime;
    long startTime;
    long startFreeMemory;
    int searchLevel = 0;
    int maxSearchLevel = 0;
    int newStates;
    int endStates;
    int backtracks;
    int revisitedStates;
    int processedStates;
    int restoredStates;
    int steps;
    long maxMemory;
    long totalMemory;
    long freeMemory;
    boolean isHeuristic = false;
    int queueSize = 0;
    int currentHeapCount = 0;
    int maxHeapCount = 0;
    int currentThreadCount = 0;
    int maxThreadCount = 0;
    int totalThreads = 0;
    String constraintHit;
    int dpCalls = 0;

    @Override
    public void stateAdvanced(Search search) {
        this.steps += search.getTransition().getStepCount();
        if (this.isHeuristic) {
            this.queueSize = ((HeuristicSearch)search).getQueueSize();
        }
        if (search.isNewState()) {
            this.searchLevel = search.getDepth();
            if (this.searchLevel > this.maxSearchLevel) {
                this.maxSearchLevel = this.searchLevel;
            }
            ++this.newStates;
            this.currentHeapCount = search.getVM().getKernelState().da.count();
            if (this.currentHeapCount > this.maxHeapCount) {
                this.maxHeapCount = this.currentHeapCount;
            }
            this.currentThreadCount = search.getVM().getAliveThreadCount();
            this.totalThreads = search.getVM().getKernelState().getThreadCount();
            if (this.currentThreadCount > this.maxThreadCount) {
                this.maxThreadCount = this.currentThreadCount;
            }
            if (search.isEndState()) {
                ++this.endStates;
            }
        } else {
            ++this.revisitedStates;
        }
        this.checkReport();
    }

    @Override
    public void stateProcessed(Search search) {
        ++this.processedStates;
        this.checkReport();
    }

    @Override
    public void stateBacktracked(Search search) {
        this.searchLevel = search.getDepth();
        ++this.backtracks;
        this.checkReport();
    }

    @Override
    public void stateRestored(Search search) {
        this.searchLevel = search.getDepth();
        ++this.restoredStates;
        this.checkReport();
    }

    @Override
    public void propertyViolated(Search search) {
    }

    @Override
    public void searchStarted(Search search) {
        this.connect();
        if (search instanceof HeuristicSearch) {
            this.isHeuristic = true;
        }
        this.startTime = this.lastTime = System.currentTimeMillis();
        Runtime rt = Runtime.getRuntime();
        this.startFreeMemory = rt.freeMemory();
        this.totalMemory = rt.totalMemory();
        this.maxMemory = rt.maxMemory();
        this.reportNumber = 1;
    }

    @Override
    public void searchConstraintHit(Search search) {
        if (this.constraintHit == null) {
            this.constraintHit = search.getSearchConstraint();
            System.out.println("Constraint Hit: " + this.constraintHit);
        }
    }

    @Override
    public void searchFinished(Search search) {
        this.report("------------------------------------ statistics");
        if (this.constraintHit != null) {
            if (this.constraintHit.equals("SIZE")) {
                this.constraintHit = "Memory";
            }
            this.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            this.out.println("INCOMPLETE SEARCH (" + this.constraintHit + " Constraint Hit)");
            this.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        }
        if (this.sock != null) {
            try {
                this.out.close();
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void checkReport() {
        this.time = System.currentTimeMillis();
        Runtime rt = Runtime.getRuntime();
        long m = rt.totalMemory();
        if (m > this.totalMemory) {
            this.totalMemory = m;
        }
        if (this.time - this.lastTime >= (long)this.interval) {
            this.freeMemory = rt.freeMemory();
            this.report("# " + this.reportNumber++);
            this.lastTime = this.time;
        }
    }

    void reportRuntime() {
        long td = this.time - this.startTime;
        int h = (int)(td / 3600000L);
        int m = (int)(td / 60000L) % 60;
        int s = (int)(td / 1000L) % 60;
        this.out.print("  abs time:          ");
        if (h < 10) {
            this.out.print('0');
        }
        this.out.print(h);
        this.out.print(':');
        if (m < 10) {
            this.out.print('0');
        }
        this.out.print(m);
        this.out.print(':');
        if (s < 10) {
            this.out.print('0');
        }
        this.out.print(s);
        this.out.print("  (");
        this.out.print(td);
        this.out.println(" ms)");
    }

    void report(String header) {
        this.out.println(header);
        this.reportRuntime();
        this.out.print("  rel. time [ms]:    ");
        this.out.println(this.time - this.lastTime);
        this.out.println();
        this.out.print("  search depth:      ");
        this.out.print(this.searchLevel);
        this.out.print(" (max: ");
        this.out.print(this.maxSearchLevel);
        this.out.println(")");
        this.out.print("  new states:        ");
        this.out.println(this.newStates);
        this.out.print("  revisited states:  ");
        this.out.println(this.revisitedStates);
        this.out.print("  end states:        ");
        this.out.println(this.endStates);
        this.out.print("  backtracks:        ");
        this.out.println(this.backtracks);
        this.out.print("  processed states:  ");
        this.out.print(this.processedStates);
        this.out.print(" (");
        double d = (double)this.backtracks / (double)this.processedStates;
        int n = (int)d;
        int m = (int)((d - (double)n) * 10.0);
        this.out.print(n);
        this.out.print('.');
        this.out.print(m);
        this.out.println(" bt/proc state)");
        this.out.print("  restored states:   ");
        this.out.println(this.restoredStates);
        if (this.isHeuristic) {
            this.out.print("  queue size:        ");
            this.out.println(this.queueSize);
        }
        this.out.println();
        this.out.print("  total memory [kB]: ");
        this.out.print(this.totalMemory / 1024L);
        this.out.print(" (max: ");
        this.out.print(this.maxMemory / 1024L);
        this.out.println(")");
        this.out.print("  free memory [kB]:  ");
        this.out.println(this.freeMemory / 1024L);
        this.out.print("  heap objects:      ");
        this.out.print(this.currentHeapCount);
        this.out.print(" (max: ");
        this.out.print(this.maxHeapCount);
        this.out.println(")");
        this.out.print("  alive threads:     ");
        this.out.print(this.currentThreadCount);
        this.out.print(" (max: ");
        this.out.print(this.maxThreadCount);
        this.out.println(") out of " + this.totalThreads + " current thread objects ");
        this.out.println();
    }

    int consumeIntArg(String[] args, int i, String varName, int def) {
        int ret = def;
        args[i] = null;
        if (i < args.length - 1) {
            ++i;
            try {
                ret = Integer.parseInt(args[i]);
                args[i] = null;
            }
            catch (NumberFormatException nfx) {
                System.err.print("Warning: illegal " + varName + " specification: " + args[i] + " using default " + ret);
            }
        }
        return ret;
    }

    void filterArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].equals("-port")) {
                this.port = this.consumeIntArg(args, i++, "port", -1);
                continue;
            }
            if (args[i].equals("-interval")) {
                this.interval = this.consumeIntArg(args, i++, "interval", 10000);
                continue;
            }
            if (!args[i].equals("-hostname")) continue;
            args[i] = null;
            if (i >= args.length - 1) continue;
            this.hostName = args[++i];
            args[i] = null;
        }
    }

    static void printUsage() {
        System.out.println("SearchMonitor - a JPF listener tool to monitor JPF searches");
        System.out.println("usage: java gov.nasa.jpf.tools.SearchMonitor <jpf-options>  <monitor-options> <class>");
        System.out.println("<monitor-options>:");
        System.out.println("       -hostname <name> : connect to host <name>, default: localhost");
        System.out.println("       -port <num>      : connect to port <num>, default: (use stdout)");
        System.out.println("       -interval <num>  : report every <num> msec, default: 10000");
    }

    void connect() {
        if (this.port > 0) {
            try {
                this.sock = new Socket(this.hostName, this.port);
                this.out = new PrintWriter(this.sock.getOutputStream(), true);
            }
            catch (UnknownHostException uhx) {
                System.err.println("Warning: unknown log host: " + this.hostName + ", using System.out");
            }
            catch (ConnectException cex) {
                System.err.println("Warning: no log host detected, using System.out");
            }
            catch (IOException iox) {
                System.err.println(iox);
            }
        }
        if (this.out == null) {
            this.out = new PrintWriter(System.out, true);
        }
    }

    public void run(Config conf) {
        JPF jpf = new JPF(conf);
        jpf.addSearchListener(this);
        jpf.run();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            SearchMonitor.printUsage();
            return;
        }
        Config conf = JPF.createConfig(args);
        SearchMonitor listener = new SearchMonitor(conf);
        listener.filterArgs(args);
        listener.run(conf);
    }

    public SearchMonitor(Config config) {
        this.port = config.getInt("monitor.port", -1);
        this.hostName = config.getString("monitor.hostname", DEF_HOSTNAME);
        this.interval = config.getInt("monitor.interval", 10000);
    }
}

