/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;
import gov.nasa.jpf.jvm.bytecode.InstanceFieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.PUTFIELD;
import gov.nasa.jpf.jvm.bytecode.PUTSTATIC;
import gov.nasa.jpf.jvm.bytecode.StaticFieldInstruction;
import gov.nasa.jpf.search.Search;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class RaceDetector
extends PropertyListenerAdapter {
    HashMap<String, FieldAccessSequence> fields = new HashMap();
    Stack<ArrayList<FieldAccessSequence>> transitions = new Stack();
    ArrayList<FieldAccessSequence> pendingChanges;
    FieldAccessSequence raceField;
    ArrayList<FieldAccess> raceAccess1 = new ArrayList();
    ArrayList<FieldAccess> raceAccess2 = new ArrayList();
    String[] watchFields;
    boolean terminate;
    boolean verifyCycle;

    public RaceDetector(Config config) {
        this.watchFields = config.getStringArray("race.fields");
        this.terminate = config.getBoolean("race.terminate", true);
        this.verifyCycle = config.getBoolean("race.verify_cycle", false);
    }

    @Override
    public void reset() {
        this.raceField = null;
    }

    boolean isWatchedField(FieldInstruction finsn) {
        if (this.watchFields == null) {
            return true;
        }
        String fname = finsn.getVariableId();
        for (int i = 0; i < this.watchFields.length; ++i) {
            if (!fname.matches(this.watchFields[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean check(Search search, JVM vm) {
        return this.raceField == null;
    }

    @Override
    public String getErrorMessage() {
        return "potential field race: " + this.raceField.id;
    }

    @Override
    public void stateAdvanced(Search search) {
        this.transitions.push(this.pendingChanges);
        this.pendingChanges = null;
    }

    @Override
    public void stateBacktracked(Search search) {
        ArrayList<FieldAccessSequence> fops = this.transitions.pop();
        if (fops != null) {
            for (FieldAccessSequence fs : fops) {
                fs.purgeLastAccess();
            }
        }
    }

    @Override
    public void instructionExecuted(JVM jvm) {
        Instruction insn = jvm.getLastInstruction();
        if (insn instanceof FieldInstruction) {
            ThreadInfo ti = jvm.getLastThreadInfo();
            FieldInstruction finsn = (FieldInstruction)insn;
            String id = null;
            if (this.raceField != null) {
                return;
            }
            if (ti.hasOtherRunnables() && this.isWatchedField(finsn)) {
                if (finsn instanceof StaticFieldInstruction) {
                    if (finsn.getMethodInfo().isClinit(finsn.getFieldInfo().getClassInfo())) {
                        return;
                    }
                    id = finsn.getVariableId();
                } else {
                    ElementInfo ei = ((InstanceFieldInstruction)insn).getLastElementInfo();
                    if (ei != null && ei.isShared()) {
                        id = finsn.getId(ei);
                    }
                }
                if (id != null) {
                    FieldAccess conflict;
                    FieldAccessSequence fs = this.fields.get(id);
                    if (fs == null) {
                        fs = new FieldAccessSequence(id);
                        this.fields.put(id, fs);
                    }
                    FieldAccess fa = new FieldAccess(ti, finsn);
                    fs.addAccess(fa);
                    if (this.pendingChanges == null) {
                        this.pendingChanges = new ArrayList(5);
                    }
                    this.pendingChanges.add(fs);
                    if (!fa.hasLockCandidates() && (conflict = fa.getConflict()) != null) {
                        if (this.verifyCycle) {
                            int idx = this.raceAccess1.indexOf(conflict);
                            if (idx >= 0 && fa.equals(this.raceAccess2.get(idx))) {
                                if (this.terminate) {
                                    this.raceField = fs;
                                }
                                System.err.println("race detected (access occurred in both orders): " + fs.id);
                                System.err.println("\t" + fa.describe());
                                System.err.println("\t" + conflict.describe());
                            } else {
                                this.raceAccess1.add(fa);
                                this.raceAccess2.add(conflict);
                            }
                        } else {
                            if (this.terminate) {
                                this.raceField = fs;
                            }
                            System.err.println("potential race detected: " + fs.id);
                            System.err.println("\t" + fa.describe());
                            System.err.println("\t" + conflict.describe());
                        }
                    }
                }
            }
        }
    }

    static class FieldAccessSequence {
        String id;
        FieldAccess lastAccess;

        FieldAccessSequence(String id) {
            this.id = id;
        }

        void addAccess(FieldAccess fa) {
            fa.prev = this.lastAccess;
            this.lastAccess = fa;
            fa.updateLockCandidates();
        }

        void purgeLastAccess() {
            this.lastAccess = this.lastAccess.prev;
        }
    }

    static class FieldAccess {
        ThreadInfo ti;
        Object[] locksHeld;
        Object[] lockCandidates;
        FieldInstruction finsn;
        FieldAccess prev;

        FieldAccess(ThreadInfo ti, FieldInstruction finsn) {
            this.ti = ti;
            this.finsn = finsn;
            LinkedList<ElementInfo> lockSet = ti.getLockedObjects();
            this.locksHeld = new Object[lockSet.size()];
            if (this.locksHeld.length > 0) {
                Iterator it = lockSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    this.locksHeld[i] = ((ElementInfo)it.next()).toString();
                    ++i;
                }
            }
        }

        <T> T[] intersect(T[] a, T[] b) {
            ArrayList<T> list = new ArrayList<T>(a.length);
            block0: for (int i = 0; i < a.length; ++i) {
                for (int j = 0; j < b.length; ++j) {
                    if (!a[i].equals(b[j])) continue;
                    list.add(a[i]);
                    continue block0;
                }
            }
            return list.size() == a.length ? a : list.toArray((Object[])a.clone());
        }

        void updateLockCandidates() {
            this.lockCandidates = this.prev == null ? this.locksHeld : this.intersect(this.locksHeld, this.prev.lockCandidates);
        }

        boolean hasLockCandidates() {
            return this.lockCandidates.length > 0;
        }

        boolean isWriteAccess() {
            return this.finsn instanceof PUTFIELD || this.finsn instanceof PUTSTATIC;
        }

        FieldAccess getConflict() {
            boolean isWrite = this.isWriteAccess();
            FieldAccess c = this.prev;
            while (c != null) {
                if (c.ti != this.ti && isWrite != c.isWriteAccess()) {
                    return c;
                }
                c = c.prev;
            }
            return null;
        }

        public boolean equals(Object other) {
            if (other instanceof FieldAccess) {
                FieldAccess that = (FieldAccess)other;
                if (this.ti != that.ti) {
                    return false;
                }
                return this.finsn == that.finsn;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        String describe() {
            String s = this.isWriteAccess() ? "write" : "read";
            s = s + " from thread: \"";
            s = s + this.ti.getName();
            s = s + "\", holding locks {";
            for (int i = 0; i < this.locksHeld.length; ++i) {
                if (i > 0) {
                    s = s + ',';
                }
                s = s + this.locksHeld[i];
            }
            s = s + "} in ";
            s = s + this.finsn.getSourceLocation();
            return s;
        }
    }
}

