/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.PUTFIELD;
import gov.nasa.jpf.jvm.bytecode.PUTSTATIC;
import gov.nasa.jpf.jvm.choice.ThreadChoiceFromSet;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.StringSetMatcher;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PreciseRaceDetector
extends PropertyListenerAdapter {
    FieldInfo raceField;
    ThreadInfo[] racers = new ThreadInfo[2];
    Instruction[] insns = new Instruction[2];
    StringSetMatcher includes = null;
    StringSetMatcher excludes = null;

    public PreciseRaceDetector(Config conf) {
        this.includes = StringSetMatcher.getNonEmpty(conf.getStringArray("race.include"));
        this.excludes = StringSetMatcher.getNonEmpty(conf.getStringArray("race.exclude"));
    }

    @Override
    public boolean check(Search search, JVM vm) {
        return this.raceField == null;
    }

    @Override
    public void reset() {
        this.raceField = null;
        this.racers[1] = null;
        this.racers[0] = null;
        this.insns[1] = null;
        this.insns[0] = null;
    }

    @Override
    public String getErrorMessage() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("race for: \"");
        pw.print(this.raceField);
        pw.println("\"");
        for (int i = 0; i < 2; ++i) {
            pw.print("  ");
            pw.print(this.racers[i].getName());
            pw.print(" at ");
            pw.println(this.insns[i].getSourceLocation());
            pw.print("\t\t\"" + this.insns[i].getSourceLine().trim());
            pw.print("\"  : ");
            pw.println(this.insns[i]);
        }
        pw.flush();
        return sw.toString();
    }

    private boolean isPutInsn(Instruction insn) {
        return insn instanceof PUTFIELD || insn instanceof PUTSTATIC;
    }

    @Override
    public void choiceGeneratorSet(JVM vm) {
        ChoiceGenerator cg = vm.getLastChoiceGenerator();
        if (cg instanceof ThreadChoiceFromSet) {
            ThreadInfo[] threads = ((ThreadChoiceFromSet)cg).getAllThreadChoices();
            ElementInfo[] eiCandidates = null;
            FieldInfo[] fiCandidates = null;
            for (int i = 0; i < threads.length; ++i) {
                FieldInstruction finsn;
                FieldInfo fi;
                ThreadInfo ti = threads[i];
                Instruction insn = ti.getPC();
                if (!(insn instanceof FieldInstruction) || !StringSetMatcher.isMatch((fi = (finsn = (FieldInstruction)insn).getFieldInfo()).getFullName(), this.includes, this.excludes)) continue;
                if (eiCandidates == null) {
                    eiCandidates = new ElementInfo[threads.length];
                    fiCandidates = new FieldInfo[threads.length];
                }
                ElementInfo ei = finsn.peekElementInfo(ti);
                int idx = -1;
                for (int j = 0; j < i; ++j) {
                    if (ei != eiCandidates[j] || fi != fiCandidates[j]) continue;
                    idx = j;
                    break;
                }
                if (idx >= 0) {
                    Instruction otherInsn = threads[idx].getPC();
                    if (!this.isPutInsn(otherInsn) && !this.isPutInsn(insn)) continue;
                    this.raceField = ((FieldInstruction)insn).getFieldInfo();
                    this.racers[0] = threads[idx];
                    this.insns[0] = otherInsn;
                    this.racers[1] = threads[i];
                    this.insns[1] = insn;
                    return;
                }
                eiCandidates[i] = ei;
                fiCandidates[i] = fi;
            }
        }
    }

    @Override
    public void executeInstruction(JVM jvm) {
        if (this.raceField != null) {
            ThreadInfo ti = jvm.getLastThreadInfo();
            ti.breakTransition();
        }
    }
}

