/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ARETURN;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.PUTFIELD;
import gov.nasa.jpf.jvm.bytecode.PUTSTATIC;
import gov.nasa.jpf.jvm.bytecode.RETURN;
import java.util.HashSet;

public class NonNullChecker
extends ListenerAdapter {
    HashSet<ClassInfo> staticFieldCandidates = new HashSet();
    HashSet<ClassInfo> instanceFieldCandidates = new HashSet();

    @Override
    public void classLoaded(JVM vm) {
        ClassInfo ci = vm.getLastClassInfo();
        for (FieldInfo fi : ci.getDeclaredStaticFields()) {
            if (fi.getAnnotation("gov.nasa.jpf.NonNull") == null) continue;
            if (ci.getClinit() == null) {
                this.throwAssertionError(vm.getLastThreadInfo(), "@NonNull static field without clinit: " + fi.getFullName());
                return;
            }
            this.staticFieldCandidates.add(ci);
            break;
        }
        for (FieldInfo fi : ci.getDeclaredInstanceFields()) {
            if (fi.getAnnotation("gov.nasa.jpf.NonNull") == null) continue;
            if (!ci.hasCtors()) {
                this.throwAssertionError(vm.getLastThreadInfo(), "@NonNull instance field without ctor: " + fi.getFullName());
                return;
            }
            this.instanceFieldCandidates.add(ci);
            break;
        }
    }

    @Override
    public void instructionExecuted(JVM vm) {
        FieldInfo fi;
        PUTSTATIC put;
        MethodInfo mi;
        Instruction insn = vm.getLastInstruction();
        if (insn instanceof ARETURN) {
            ARETURN areturn = (ARETURN)insn;
            MethodInfo mi2 = insn.getMethodInfo();
            if (areturn.getReturnValue() == -1 && mi2.getAnnotation("gov.nasa.jpf.NonNull") != null) {
                this.throwAssertionError(vm.getLastThreadInfo(), "null return from @NonNull method: " + mi2.getCompleteName());
                return;
            }
        } else if (insn instanceof RETURN) {
            FieldInfo fi2;
            ClassInfo ci;
            RETURN ret = (RETURN)insn;
            MethodInfo mi3 = insn.getMethodInfo();
            if (mi3.isCtor()) {
                ThreadInfo ti;
                ElementInfo ei;
                FieldInfo fi3;
                ClassInfo ci2 = mi3.getClassInfo();
                if (this.instanceFieldCandidates.contains(ci2) && (fi3 = this.checkNonNullInstanceField(ci2, ei = (ti = vm.getLastThreadInfo()).getElementInfo(ret.getReturnFrame().getThis()))) != null) {
                    this.throwAssertionError(ti, "uninitialized @NonNull instance field: " + fi3.getFullName());
                    return;
                }
            } else if (mi3.isClinit() && this.staticFieldCandidates.contains(ci = mi3.getClassInfo()) && (fi2 = this.checkNonNullStaticField(ci)) != null) {
                this.throwAssertionError(vm.getLastThreadInfo(), "uninitialized @NonNull static field: " + fi2.getFullName());
                return;
            }
        } else if (insn instanceof PUTFIELD) {
            FieldInfo fi4;
            PUTFIELD put2;
            MethodInfo mi4 = insn.getMethodInfo();
            if (!mi4.isCtor() && (put2 = (PUTFIELD)insn).getLastValue() == -1L && (fi4 = put2.getFieldInfo()).getAnnotation("gov.nasa.jpf.NonNull") != null) {
                this.throwAssertionError(vm.getLastThreadInfo(), "null assignment to @NonNull instance field: " + fi4.getFullName());
                return;
            }
        } else if (insn instanceof PUTSTATIC && !(mi = insn.getMethodInfo()).isClinit() && (put = (PUTSTATIC)insn).getLastValue() == -1L && (fi = put.getFieldInfo()).getAnnotation("gov.nasa.jpf.NonNull") != null) {
            this.throwAssertionError(vm.getLastThreadInfo(), "null assignment to @NonNull static field: " + fi.getFullName());
            return;
        }
    }

    void throwAssertionError(ThreadInfo ti, String msg) {
        Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", msg);
        ti.setNextPC(nextPc);
    }

    FieldInfo checkNonNullInstanceField(ClassInfo ci, ElementInfo ei) {
        for (FieldInfo fi : ci.getDeclaredInstanceFields()) {
            if (fi.getAnnotation("gov.nasa.jpf.NonNull") == null || ei.getReferenceField(fi) != -1) continue;
            return fi;
        }
        return null;
    }

    FieldInfo checkNonNullStaticField(ClassInfo ci) {
        StaticElementInfo ei = ci.getStaticElementInfo();
        for (FieldInfo fi : ci.getDeclaredStaticFields()) {
            if (fi.getAnnotation("gov.nasa.jpf.NonNull") == null || ei.getReferenceField(fi) != -1) continue;
            return fi;
        }
        return null;
    }
}

