/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.jvm.bytecode.VirtualInvocation;
import gov.nasa.jpf.report.ConsolePublisher;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.StringSetMatcher;
import java.io.PrintWriter;
import java.util.HashMap;

public class MethodAnalyzer
extends ListenerAdapter {
    static String[] opTypeMnemonic = new String[]{"C", "X", "E", "R"};
    StringSetMatcher includes = null;
    StringSetMatcher excludes = null;
    int maxHistory;
    String format;
    boolean skipInit;
    boolean showDepth;
    boolean showTransition;
    JVM vm;
    Search search;
    OpType opType;
    MethodOp lastOp;
    MethodOp lastTransition;
    boolean isFirstTransition = true;
    HashMap<Integer, MethodOp> storedTransition = new HashMap();

    public MethodAnalyzer(Config config, JPF jpf) {
        jpf.addPublisherExtension(ConsolePublisher.class, this);
        this.maxHistory = config.getInt("method.max_history", Integer.MAX_VALUE);
        this.format = config.getString("method.format", "raw");
        this.skipInit = config.getBoolean("method.skip_init", true);
        this.showDepth = config.getBoolean("method.show_depth", false);
        this.showTransition = config.getBoolean("method.show_transition", false);
        this.includes = StringSetMatcher.getNonEmpty(config.getStringArray("method.include"));
        this.excludes = StringSetMatcher.getNonEmpty(config.getStringArray("method.exclude"));
        this.vm = jpf.getVM();
        this.search = jpf.getSearch();
    }

    void addOp(JVM vm, OpType opType, MethodInfo mi, ThreadInfo ti, ElementInfo ei, int stackDepth) {
        if (!this.skipInit || !this.isFirstTransition) {
            MethodOp op = new MethodOp(opType, mi, ti, ei, stackDepth);
            if (this.lastOp == null) {
                this.lastOp = op;
            } else {
                op.p = this.lastOp;
                this.lastOp = op;
            }
        }
    }

    boolean isAnalyzedMethod(MethodInfo mi) {
        String mthName = mi.getFullName();
        return StringSetMatcher.isMatch(mthName, this.includes, this.excludes);
    }

    void printRaw(PrintWriter pw) {
        MethodOp start = this.revertAndFlatten(this.lastTransition);
        int lastStateId = Integer.MIN_VALUE;
        int transition = this.skipInit ? 1 : 0;
        int lastTid = start.ti.getIndex();
        MethodOp op = start;
        while (op != null) {
            if (this.showTransition) {
                if (op.stateId != lastStateId) {
                    lastStateId = op.stateId;
                    pw.print("------------------------------------------ #");
                    pw.println(transition++);
                }
            } else {
                int tid = op.ti.getIndex();
                if (tid != lastTid) {
                    lastTid = tid;
                    pw.println("------------------------------------------");
                }
            }
            op.printRawOn(pw);
            pw.println();
            op = op.p;
        }
    }

    MethodOp revertAndFlatten(MethodOp start) {
        MethodOp last = null;
        MethodOp prevTransition = start.prevTransition;
        MethodOp op = start;
        while (op != null) {
            MethodOp opp = op.p;
            op.p = last;
            if (opp == null) {
                if (prevTransition == null) {
                    return op;
                }
                last = op;
                op = prevTransition;
                prevTransition = op.prevTransition;
                continue;
            }
            last = op;
            op = opp;
        }
        return null;
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.isNewState() && this.lastOp != null) {
            int stateId = search.getStateNumber();
            MethodOp op = this.lastOp;
            while (op != null) {
                op.stateId = stateId;
                op = op.p;
            }
            this.lastOp.prevTransition = this.lastTransition;
            this.lastTransition = this.lastOp;
        }
        this.lastOp = null;
        this.isFirstTransition = false;
    }

    @Override
    public void stateBacktracked(Search search) {
        int stateId = search.getStateNumber();
        while (this.lastTransition != null && this.lastTransition.stateId > stateId) {
            this.lastTransition = this.lastTransition.prevTransition;
        }
        this.lastOp = null;
    }

    @Override
    public void stateStored(Search search) {
        this.storedTransition.put(search.getStateNumber(), this.lastTransition);
    }

    @Override
    public void stateRestored(Search search) {
        int stateId = search.getStateNumber();
        MethodOp op = this.storedTransition.get(stateId);
        if (op != null) {
            this.lastTransition = op;
            this.storedTransition.remove(stateId);
        }
    }

    @Override
    public void instructionExecuted(JVM vm) {
        Instruction insn = vm.getLastInstruction();
        ElementInfo ei = null;
        if (insn instanceof InvokeInstruction) {
            InvokeInstruction call = (InvokeInstruction)insn;
            ThreadInfo ti = vm.getLastThreadInfo();
            MethodInfo mi = call.getInvokedMethod(ti);
            if (this.isAnalyzedMethod(mi)) {
                OpType type = ti.getNextPC() == call ? OpType.CALL : (ti.isFirstStepInsn() ? OpType.EXECUTE : OpType.CALL_EXECUTE);
                if (!mi.isStatic() && call instanceof VirtualInvocation) {
                    ei = ((VirtualInvocation)call).getThisElementInfo(ti);
                }
                this.addOp(vm, type, mi, ti, ei, ti.getStackDepth());
            }
        } else if (insn instanceof ReturnInstruction) {
            ReturnInstruction ret = (ReturnInstruction)insn;
            ThreadInfo ti = vm.getLastThreadInfo();
            StackFrame frame = ret.getReturnFrame();
            MethodInfo mi = frame.getMethodInfo();
            if (this.isAnalyzedMethod(mi)) {
                int ref;
                if (!mi.isStatic() && (ref = frame.getThis()) != -1) {
                    ei = ti.getElementInfo(ref);
                }
                this.addOp(vm, OpType.RETURN, mi, ti, ei, ti.getStackDepth() + 1);
            }
        }
    }

    @Override
    public void publishPropertyViolation(Publisher publisher) {
        PrintWriter pw = publisher.getOut();
        publisher.publishTopicStart("method ops " + publisher.getLastErrorId());
        this.printRaw(pw);
    }

    static class MethodOp {
        OpType type;
        ThreadInfo ti;
        ElementInfo ei;
        Instruction insn;
        MethodInfo mi;
        int stackDepth;
        int stateId = Integer.MIN_VALUE;
        MethodOp prevTransition;
        MethodOp p;

        MethodOp(OpType type, MethodInfo mi, ThreadInfo ti, ElementInfo ei, int stackDepth) {
            this.type = type;
            this.ti = ti;
            this.mi = mi;
            this.ei = ei;
            this.stackDepth = stackDepth;
        }

        void printRawOn(PrintWriter pw) {
            pw.print(this.ti.getIndex());
            pw.print(": ");
            for (int i = 0; i < this.stackDepth; ++i) {
                pw.print('.');
            }
            pw.print(opTypeMnemonic[this.type.ordinal()]);
            pw.print(' ');
            pw.print(this.mi.getFullName());
            if (this.ei != null) {
                pw.print(", ");
                pw.print(this.ei);
            }
        }

        public String toString() {
            return "Op {" + this.ti.getName() + ',' + opTypeMnemonic[this.type.ordinal()] + ',' + this.mi.getFullName() + ',' + this.ei + '}';
        }
    }

    static enum OpType {
        CALL,
        CALL_EXECUTE,
        EXECUTE,
        RETURN;

    }
}

