/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public class LogConsole {
    static int DEF_PORT = 20000;
    boolean running;
    int port;
    boolean autoclose;
    boolean killed;
    ServerSocket ss;
    Socket cs;

    public void run() {
        this.running = true;
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook()));
        if (this.port == 0) {
            this.port = DEF_PORT;
        }
        try {
            this.ss = new ServerSocket(this.port);
            try {
                do {
                    System.out.println("LogConsole listening on port: " + this.port);
                    this.cs = this.ss.accept();
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.cs.getInputStream()));
                    System.out.println("LogConsole connected");
                    System.out.println("--------------------------------------------------------------------------------");
                    try {
                        String msg;
                        while ((msg = in.readLine()) != null) {
                            System.out.println(msg);
                        }
                        System.out.println("--------------------------------------------------------------------------------");
                        System.out.println("LogConsole disconnected");
                    }
                    catch (IOException iox) {
                        System.err.println(iox);
                    }
                    in.close();
                    this.cs.close();
                } while (!this.autoclose);
                System.out.println("LogConsole closing");
            }
            catch (IOException iox) {
                if (!this.killed) {
                    System.err.println("Error: LogConsole accept failed on port: " + this.port);
                }
            }
        }
        catch (IOException iox) {
            System.err.println("Error: LogConsole cannot listen on port: " + this.port);
        }
        this.running = false;
    }

    public void showUsage() {
        System.out.println("LogConsole: socket based console logger");
        System.out.println("     usage: java gov.nasa.jpf.tools.LogConsole {flags} [<port>]");
        System.out.println("      args: -help         show this message");
        System.out.println("            -autoclose    close the application upon disconnect");
        System.out.println("            <port>        optional port number, default: " + DEF_PORT);
    }

    boolean processArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-autoclose")) {
                    args[i] = null;
                    this.autoclose = true;
                    continue;
                }
                if (args[i].equals("-help")) {
                    this.showUsage();
                    return false;
                }
                System.err.println("Warning: unknown argument (see -help for usage): " + args[i]);
                continue;
            }
            if (args[i].matches("[0-9]+")) {
                if (this.port != 0) {
                    System.err.println("Error: only one port parameter allowed (see -help for usage): " + args[i]);
                    return false;
                }
                try {
                    this.port = Integer.parseInt(args[i]);
                    continue;
                }
                catch (NumberFormatException nfx) {
                    System.err.println("Error: illegal port spec: " + args[i]);
                    return false;
                }
            }
            System.out.println("Error: unknown argument: " + args[i]);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        LogConsole console = new LogConsole();
        if (console.processArgs(args)) {
            console.run();
        }
    }

    class ShutdownHook
    implements Runnable {
        ShutdownHook() {
        }

        @Override
        public void run() {
            if (LogConsole.this.running) {
                LogConsole.this.killed = true;
                System.out.println("\nLogConsole killed, shutting down");
            }
            try {
                LogConsole.this.cs.close();
                LogConsole.this.ss.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

