/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class JavaJPF {
    static void printTrimmedStackTrace(Throwable e) {
        StackTraceElement tmp;
        int i;
        StackTraceElement[] st = e.getStackTrace();
        LinkedList<StackTraceElement> newStList = new LinkedList<StackTraceElement>();
        int minStuff = Thread.currentThread().getStackTrace().length + 2;
        boolean internal = true;
        for (i = 0; i < st.length && (i <= minStuff || internal); ++i) {
            tmp = st[st.length - 1 - i];
            String cname = tmp.getClassName();
            boolean bl = internal = cname.startsWith("java.lang.") || cname.startsWith("sun.reflect.");
            if (internal) continue;
            newStList.addFirst(tmp);
        }
        while (i < st.length) {
            tmp = st[st.length - 1 - i];
            newStList.addFirst(tmp);
            ++i;
        }
        StackTraceElement[] newSt = newStList.toArray(new StackTraceElement[newStList.size()]);
        e.setStackTrace(newSt);
        e.printStackTrace();
    }

    static void showUsage() {
        System.out.println("Usage: \"java [<vm-option>..] [RunTool] gov.nasa.jpf.tools.JavaJPF [<jpf-option>..] [<app> [<app-arg>..]]");
        System.out.println("  <jpf-option> : -c <config-file>  : name of config properties file (default \"jpf.properties\")");
        System.out.println("               | -help  : print usage information");
        System.out.println("               | -show  : print configuration dictionary contents");
        System.out.println("               | +<key>=<value>  : add or override key/value pair to config dictionary");
        System.out.println("  <app>        : application class or *.xml error trace file");
        System.out.println("  <app-arg>    : arguments passed into main(String[]) if application class");
    }

    public static void invokeMain(Class<?> clazz, String[] args) throws NoSuchMethodException, InvocationTargetException {
        Class[] params = new Class[]{args.getClass()};
        Method main = clazz.getMethod("main", params);
        if (!Modifier.isStatic(main.getModifiers())) {
            throw new NoSuchMethodException("main method in " + clazz + " not static!");
        }
        try {
            main.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new NoSuchMethodException("main method in " + clazz + " not accessible!");
        }
    }

    public static void main(String[] args) {
        ClassLoader cl;
        Config conf = JPF.createConfig(args);
        if (JPF.isHelpRequest(args)) {
            JavaJPF.showUsage();
        }
        if (JPF.isPrintConfigRequest(args)) {
            conf.print(new PrintWriter(System.out));
        }
        String targetClassName = conf.getTargetArg();
        if (conf.getTargetArg() == null) {
            return;
        }
        String vmClassPath = conf.getExpandedString("vm.classpath");
        if (vmClassPath == null) {
            cl = JavaJPF.class.getClassLoader();
        } else {
            StringTokenizer cpToks = new StringTokenizer(vmClassPath, File.pathSeparator);
            ArrayList<URL> cpList = new ArrayList<URL>();
            while (cpToks.hasMoreTokens()) {
                try {
                    cpList.add(new File(cpToks.nextToken()).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    System.exit(2);
                }
            }
            URL[] cpArr = cpList.toArray(new URL[cpList.size()]);
            cl = new URLClassLoader(cpArr, JavaJPF.class.getClassLoader());
        }
        try {
            Class<?> mainClass = cl.loadClass(targetClassName);
            JavaJPF.invokeMain(mainClass, conf.getTargetArgParameters());
        }
        catch (ClassNotFoundException e) {
            JavaJPF.printTrimmedStackTrace(e);
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            JavaJPF.printTrimmedStackTrace(e);
            System.exit(1);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            JavaJPF.printTrimmedStackTrace(e);
            System.exit(1);
        }
    }
}

