/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.report.ConsolePublisher;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.DynamicObjectArray;
import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.SourceRef;
import gov.nasa.jpf.util.StringSetMatcher;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class HeapTracker
extends PropertyListenerAdapter {
    PathStat stat = new PathStat();
    Stack<PathStat> pathStats = new Stack();
    DynamicObjectArray<SourceRef> loc = new DynamicObjectArray();
    HashMap<String, TypeStat> typeStat = new HashMap();
    int maxState;
    int nForward;
    int nBacktrack;
    int nElemTotal;
    int nGcTotal;
    int nSharedTotal;
    int nImmutableTotal;
    int nElemMax = Integer.MIN_VALUE;
    int nElemMin = Integer.MAX_VALUE;
    int nElemAv;
    int pElemSharedMax = Integer.MIN_VALUE;
    int pElemSharedMin = Integer.MAX_VALUE;
    int pElemSharedAv;
    int pElemImmutableMax = Integer.MIN_VALUE;
    int pElemImmutableMin = Integer.MAX_VALUE;
    int pElemImmutableAv;
    int nReleased;
    int nReleasedTotal;
    int nReleasedAv;
    int nReleasedMax = Integer.MIN_VALUE;
    int nReleasedMin = Integer.MAX_VALUE;
    int maxPathHeap = Integer.MIN_VALUE;
    int maxPathNew = Integer.MIN_VALUE;
    int maxPathReleased = Integer.MIN_VALUE;
    int maxPathAlive = Integer.MIN_VALUE;
    int initHeap = 0;
    int initNew = 0;
    int initReleased = 0;
    int initAlive = 0;
    boolean showTypeStats;
    int maxTypesShown;
    int maxHeapSizeLimit;
    int maxLiveLimit;
    boolean throwOutOfMemory = false;
    StringSetMatcher includes;
    StringSetMatcher excludes;

    void updateMaxPathValues() {
        int nAlive;
        if (this.stat.heapSize > this.maxPathHeap) {
            this.maxPathHeap = this.stat.heapSize;
        }
        if (this.stat.nNew > this.maxPathNew) {
            this.maxPathNew = this.stat.nNew;
        }
        if (this.stat.nReleased > this.maxPathReleased) {
            this.maxPathReleased = this.stat.nReleased;
        }
        if ((nAlive = this.stat.nNew - this.stat.nReleased) > this.maxPathAlive) {
            this.maxPathAlive = nAlive;
        }
    }

    void allocTypeStats(ElementInfo ei) {
        String typeName = ei.getClassInfo().getName();
        TypeStat ts = this.typeStat.get(typeName);
        if (ts == null) {
            ts = new TypeStat(typeName);
            this.typeStat.put(typeName, ts);
        }
        ++ts.nAlloc;
    }

    void releaseTypeStats(ElementInfo ei) {
        String typeName = ei.getClassInfo().getName();
        TypeStat ts = this.typeStat.get(typeName);
        if (ts != null) {
            ++ts.nReleased;
        }
    }

    public HeapTracker(Config config, JPF jpf) {
        this.maxHeapSizeLimit = config.getInt("heap.size_limit", -1);
        this.maxLiveLimit = config.getInt("heap.live_limit", -1);
        this.throwOutOfMemory = config.getBoolean("heap.throw_exception");
        this.showTypeStats = config.getBoolean("heap.show_types");
        this.maxTypesShown = config.getInt("heap.max_types", 20);
        this.includes = StringSetMatcher.getNonEmpty(config.getStringArray("heap.include"));
        this.excludes = StringSetMatcher.getNonEmpty(config.getStringArray("heap.exclude"));
        jpf.addPublisherExtension(ConsolePublisher.class, this);
    }

    @Override
    public boolean check(Search search, JVM vm) {
        if (this.throwOutOfMemory) {
            return true;
        }
        if (this.maxHeapSizeLimit >= 0 && this.stat.heapSize > this.maxHeapSizeLimit) {
            return false;
        }
        return this.maxLiveLimit < 0 || this.stat.nNew - this.stat.nReleased <= this.maxLiveLimit;
    }

    @Override
    public String getErrorMessage() {
        return "heap limit exceeded: " + this.stat.heapSize + " > " + this.maxHeapSizeLimit;
    }

    @Override
    public void searchStarted(Search search) {
        super.searchStarted(search);
        this.updateMaxPathValues();
        this.pathStats.push(this.stat);
        this.initHeap = this.stat.heapSize;
        this.initNew = this.stat.nNew;
        this.initReleased = this.stat.nReleased;
        this.initAlive = this.initNew - this.initReleased;
        this.stat = (PathStat)this.stat.clone();
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.isNewState()) {
            int id = search.getStateNumber();
            if (id > this.maxState) {
                this.maxState = id;
            }
            this.updateMaxPathValues();
            this.pathStats.push(this.stat);
            this.stat = (PathStat)this.stat.clone();
            ++this.nForward;
        }
    }

    @Override
    public void stateBacktracked(Search search) {
        ++this.nBacktrack;
        if (!this.pathStats.isEmpty()) {
            this.stat = this.pathStats.pop();
        }
    }

    @Override
    public void publishFinished(Publisher publisher) {
        PrintWriter pw = publisher.getOut();
        publisher.publishTopicStart("heap statistics");
        pw.println("heap statistics:");
        pw.println("  states:         " + this.maxState);
        pw.println("  forwards:       " + this.nForward);
        pw.println("  backtrack:      " + this.nBacktrack);
        pw.println();
        pw.println("  gc cycles:      " + this.nGcTotal);
        pw.println();
        pw.println("  max Objects:    " + this.nElemMax);
        pw.println("  min Objects:    " + this.nElemMin);
        pw.println("  avg Objects:    " + this.nElemAv);
        pw.println();
        pw.println("  max% shared:    " + this.pElemSharedMax);
        pw.println("  min% shared:    " + this.pElemSharedMin);
        pw.println("  avg% shared:    " + this.pElemSharedAv);
        pw.println();
        pw.println("  max% immutable: " + this.pElemImmutableMax);
        pw.println("  min% immutable: " + this.pElemImmutableMin);
        pw.println("  avg% immutable: " + this.pElemImmutableAv);
        pw.println();
        pw.println("  max released:   " + this.nReleasedMax);
        pw.println("  min released:   " + this.nReleasedMin);
        pw.println("  avg released:   " + this.nReleasedAv);
        pw.println();
        pw.print("  max path heap (B):   " + this.maxPathHeap);
        pw.println(" / " + (this.maxPathHeap - this.initHeap));
        pw.print("  max path alive:      " + this.maxPathAlive);
        pw.println(" / " + (this.maxPathAlive - this.initAlive));
        pw.print("  max path new:        " + this.maxPathNew);
        pw.println(" / " + (this.maxPathNew - this.initNew));
        pw.print("  max path released:   " + this.maxPathReleased);
        pw.println(" / " + (this.maxPathReleased - this.initReleased));
        if (this.showTypeStats) {
            pw.println();
            pw.println("  type allocation statistics:");
            ArrayList<Map.Entry<String, TypeStat>> list = Misc.createSortedEntryList(this.typeStat, new Comparator<Map.Entry<String, TypeStat>>(){

                @Override
                public int compare(Map.Entry<String, TypeStat> e1, Map.Entry<String, TypeStat> e2) {
                    return Integer.signum(e1.getValue().nAlloc - e2.getValue().nAlloc);
                }
            });
            int i = 0;
            for (Map.Entry<String, TypeStat> e : list) {
                TypeStat ts = e.getValue();
                pw.print("  ");
                pw.print(String.format("%1$9d : ", ts.nAlloc));
                pw.println(ts.typeName);
                if (i++ <= this.maxTypesShown) continue;
                pw.println("  ...");
                break;
            }
        }
    }

    @Override
    public void gcBegin(JVM vm) {
    }

    @Override
    public void gcEnd(JVM jvm) {
        DynamicArea da = jvm.getDynamicArea();
        int n = 0;
        int nShared = 0;
        int nImmutable = 0;
        for (DynamicElementInfo ei : da) {
            ++n;
            if (ei.isShared()) {
                ++nShared;
            }
            if (!ei.isImmutable()) continue;
            ++nImmutable;
        }
        this.nElemTotal += n;
        ++this.nGcTotal;
        if (n > this.nElemMax) {
            this.nElemMax = n;
        }
        if (n < this.nElemMin) {
            this.nElemMin = n;
        }
        int pShared = nShared * 100 / n;
        int pImmutable = nImmutable * 100 / n;
        if (pShared > this.pElemSharedMax) {
            this.pElemSharedMax = pShared;
        }
        if (pShared < this.pElemSharedMin) {
            this.pElemSharedMin = pShared;
        }
        this.nSharedTotal += nShared;
        this.nImmutableTotal += nImmutable;
        this.pElemSharedAv = this.nSharedTotal * 100 / this.nElemTotal;
        this.pElemImmutableAv = this.nImmutableTotal * 100 / this.nElemTotal;
        if (pImmutable > this.pElemImmutableMax) {
            this.pElemImmutableMax = pImmutable;
        }
        if (pImmutable < this.pElemImmutableMin) {
            this.pElemImmutableMin = pImmutable;
        }
        this.nElemAv = this.nElemTotal / this.nGcTotal;
        this.nReleasedAv = this.nReleasedTotal / this.nGcTotal;
        if (this.nReleased > this.nReleasedMax) {
            this.nReleasedMax = this.nReleased;
        }
        if (this.nReleased < this.nReleasedMin) {
            this.nReleasedMin = this.nReleased;
        }
        this.nReleased = 0;
    }

    boolean isRelevantType(ElementInfo ei) {
        String clsName = ei.getClassInfo().getName();
        return StringSetMatcher.isMatch(clsName, this.includes, this.excludes);
    }

    @Override
    public void objectCreated(JVM jvm) {
        ClassInfo mci;
        ElementInfo ei = jvm.getLastElementInfo();
        int idx = ei.getIndex();
        ThreadInfo ti = jvm.getLastThreadInfo();
        int line = ti.getLine();
        MethodInfo mi = ti.getMethod();
        SourceRef sr = null;
        if (!this.isRelevantType(ei)) {
            return;
        }
        if (mi != null && (mci = mi.getClassInfo()) != null) {
            String file = mci.getSourceFileName();
            sr = file != null ? new SourceRef(file, line) : new SourceRef(mci.getName(), line);
        }
        this.loc.set(idx, sr);
        ++this.stat.nNew;
        this.stat.heapSize += ei.getHeapSize();
        if (this.showTypeStats) {
            this.allocTypeStats(ei);
        }
        if (this.throwOutOfMemory && (this.maxHeapSizeLimit >= 0 && this.stat.heapSize > this.maxHeapSizeLimit || this.maxLiveLimit >= 0 && this.stat.nNew - this.stat.nReleased > this.maxLiveLimit)) {
            DynamicArea.getHeap().setOutOfMemory(true);
        }
    }

    @Override
    public void objectReleased(JVM jvm) {
        ElementInfo ei = jvm.getLastElementInfo();
        if (!this.isRelevantType(ei)) {
            return;
        }
        ++this.nReleasedTotal;
        ++this.nReleased;
        if (this.showTypeStats) {
            this.releaseTypeStats(ei);
        }
        ++this.stat.nReleased;
        this.stat.heapSize -= ei.getHeapSize();
    }

    protected void printElementInfo(ElementInfo ei) {
        boolean first = false;
        System.out.print(ei.getIndex());
        System.out.print(": ");
        System.out.print(ei.getClassInfo().getName());
        System.out.print("  [");
        if (ei.isShared()) {
            System.out.print("shared");
            first = false;
        }
        if (ei.isImmutable()) {
            if (!first) {
                System.out.print(' ');
            }
            System.out.print("immutable");
        }
        System.out.print("] ");
        SourceRef sr = this.loc.get(ei.getIndex());
        if (sr != null) {
            System.out.println(sr);
        } else {
            System.out.println("?");
        }
    }

    static void printUsage() {
        System.out.println("HeapTracker - a JPF listener tool to report and check heap utilization");
        System.out.println("usage: java gov.nasa.jpf.tools.HeapTracker <jpf-options> <heapTracker-options> <class>");
        System.out.println("       +heap.size_limit=<num> : report property violation if heap exceeds <num> bytes");
        System.out.println("       +heap.live_limit=<num> : report property violation if more than <num> live objects");
        System.out.println("       +heap.classes=<regEx> : only report instances of classes matching <regEx>");
        System.out.println("       +heap.throw_exception=<bool>: throw a OutOfMemoryError instead of reporting property violation");
    }

    static class TypeStat {
        String typeName;
        int nAlloc;
        int nReleased;

        TypeStat(String typeName) {
            this.typeName = typeName;
        }
    }

    static class PathStat
    implements Cloneable {
        int nNew = 0;
        int nReleased = 0;
        int heapSize = 0;

        PathStat() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

