/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.jvm.Types;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class GenPeer {
    static final String SYS_PKG = "gov.nasa.jpf.jvm";
    static final String MJI_ENV = "gov.nasa.jpf.jvm.MJIEnv";
    static final String INDENT = "  ";
    static final String METHOD_PREFIX = "public static";
    static final String ENV_ARG = "MJIEnv env";
    static final String OBJ_ARG = "int robj";
    static final String CLS_ARG = "int rcls";
    static final String REF_TYPE = "int";
    static final String NULL = "MJIEnv.NULL";
    static final String EXEC_COND = "$isExecutable_";
    static final String DETERM_COND = "$isDeterministic_";
    static String clsName;
    static String[] mths;
    static boolean isSystemPkg;
    static boolean allMethods;
    static boolean mangleNames;
    static boolean clinit;
    static boolean execCond;
    static boolean determCond;

    public static void main(String[] args) {
        if (args.length == 0 || !GenPeer.readOptions(args)) {
            GenPeer.showUsage();
            return;
        }
        PrintWriter pw = new PrintWriter(System.out, true);
        Class<?> cls = GenPeer.getClass(clsName);
        if (cls != null) {
            GenPeer.printNativePeer(cls, pw);
        }
    }

    static Class<?> getClass(String cname) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(cname);
        }
        catch (ClassNotFoundException cnfx) {
            System.err.println("target class not found: " + cname);
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
        return clazz;
    }

    static boolean isMJICandidate(Method m) {
        if (allMethods) {
            return true;
        }
        if (mths != null) {
            String name = m.getName();
            for (int i = 0; i < mths.length; ++i) {
                if (!name.equals(mths[i])) continue;
                return true;
            }
        } else if ((m.getModifiers() & 0x100) != 0) {
            return true;
        }
        return false;
    }

    static void getMangledName(Method m) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(m.getName());
        sb.append("__");
    }

    static boolean isPrimitiveType(String t) {
        return REF_TYPE.equals(t) || "long".equals(t) || "boolean".equals(t) || "void".equals(t) || "byte".equals(t) || "char".equals(t) || "short".equals(t) || "float".equals(t) || "double".equals(t);
    }

    static void printClinit(PrintWriter pw) {
        pw.print(INDENT);
        pw.print(METHOD_PREFIX);
        pw.print(" void $clinit (");
        pw.print(ENV_ARG);
        pw.print(", ");
        pw.print(CLS_ARG);
        pw.println(") {");
        pw.print(INDENT);
        pw.println("}");
    }

    static void printFooter(Class<?> cls, PrintWriter pw) {
        pw.println("}");
    }

    static void printHeader(Class<?> cls, PrintWriter pw) {
        if (isSystemPkg) {
            pw.print("package ");
            pw.print(SYS_PKG);
            pw.println(';');
            pw.println();
            pw.print("import ");
            pw.print(MJI_ENV);
            pw.println(";");
            pw.println();
        }
        String cname = cls.getName().replace('.', '_');
        pw.print("class ");
        pw.print("JPF_");
        pw.print(cname);
        pw.println(" {");
    }

    static void printMethodBody(String rt, String t, PrintWriter pw) {
        if (!"void".equals(rt)) {
            pw.print(INDENT);
            pw.print(INDENT);
            pw.print(rt);
            if (rt == REF_TYPE && rt != t) {
                pw.print(" r");
                pw.print(t);
                pw.print(" = ");
                pw.print(NULL);
                pw.println(";");
                pw.print(INDENT);
                pw.print(INDENT);
                pw.print("return r");
                pw.print(t);
                pw.println(";");
            } else {
                pw.print(" v = (");
                pw.print(rt);
                pw.println(")0;");
                pw.print(INDENT);
                pw.print(INDENT);
                pw.println("return v;");
            }
        }
    }

    static void printMethodName(Method m, PrintWriter pw) {
        String name = null;
        name = mangleNames ? Types.getJNIMangledMethodName(m) : m.getName();
        pw.print(name);
    }

    static void printMethodStub(String condPrefix, Method m, PrintWriter pw) {
        String rt;
        String t = null;
        pw.print(INDENT);
        pw.print(METHOD_PREFIX);
        pw.print(' ');
        if (condPrefix == null) {
            t = rt = GenPeer.stripType(m.getReturnType().getName());
            if (!GenPeer.isPrimitiveType(rt)) {
                rt = REF_TYPE;
            }
        } else {
            rt = "boolean";
        }
        pw.print(rt);
        pw.print(' ');
        if (condPrefix != null) {
            pw.print(condPrefix);
        }
        GenPeer.printMethodName(m, pw);
        pw.print(" (");
        GenPeer.printStdArgs(m, pw);
        GenPeer.printTargetArgs(m, pw);
        pw.println(") {");
        if (condPrefix == null) {
            GenPeer.printMethodBody(rt, GenPeer.stripType(null, t), pw);
        } else {
            pw.print(INDENT);
            pw.print(INDENT);
            pw.println("return true;");
        }
        pw.print(INDENT);
        pw.println('}');
    }

    static void printNativePeer(Class<?> cls, PrintWriter pw) {
        Method[] mths = cls.getDeclaredMethods();
        GenPeer.printHeader(cls, pw);
        if (clinit) {
            GenPeer.printClinit(pw);
        }
        for (int i = 0; i < mths.length; ++i) {
            Method m = mths[i];
            if (!GenPeer.isMJICandidate(m)) continue;
            if (determCond) {
                pw.println();
                GenPeer.printMethodStub(DETERM_COND, m, pw);
            }
            if (execCond) {
                pw.println();
                GenPeer.printMethodStub(EXEC_COND, m, pw);
            }
            pw.println();
            GenPeer.printMethodStub(null, m, pw);
        }
        GenPeer.printFooter(cls, pw);
    }

    static void printStdArgs(Method m, PrintWriter pw) {
        pw.print(ENV_ARG);
        pw.print(", ");
        if ((m.getModifiers() & 8) != 0) {
            pw.print(CLS_ARG);
        } else {
            pw.print(OBJ_ARG);
        }
    }

    static void printTargetArgs(Method m, PrintWriter pw) {
        Class<?>[] pt = m.getParameterTypes();
        for (int i = 0; i < pt.length; ++i) {
            String t = GenPeer.stripType(pt[i].getName());
            boolean isPrim = GenPeer.isPrimitiveType(t);
            pw.print(", ");
            if (isPrim) {
                pw.print(t);
                pw.print(" v");
                pw.print(i);
                continue;
            }
            pw.print(REF_TYPE);
            pw.print(" r");
            pw.print(GenPeer.stripType(null, t));
            pw.print(i);
        }
    }

    static String[] readNames(String[] args, int i) {
        ArrayList<String> a = null;
        while (i < args.length && args[i].charAt(0) != '-') {
            if (a == null) {
                a = new ArrayList<String>();
            }
            a.add(args[i]);
            ++i;
        }
        if (a != null) {
            String[] names = new String[a.size()];
            a.toArray(names);
            return names;
        }
        return null;
    }

    static boolean readOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-s".equals(arg)) {
                isSystemPkg = true;
                continue;
            }
            if ("-m".equals(arg)) {
                mangleNames = true;
                continue;
            }
            if ("-a".equals(arg)) {
                allMethods = true;
                continue;
            }
            if ("-ci".equals(arg)) {
                clinit = true;
                continue;
            }
            if ("-dc".equals(arg)) {
                determCond = true;
                continue;
            }
            if ("-ec".equals(arg)) {
                execCond = true;
                continue;
            }
            if (arg.charAt(0) != '-') {
                if (clsName == null) {
                    clsName = arg;
                    continue;
                }
                mths = GenPeer.readNames(args, i);
                i += mths.length;
                continue;
            }
            System.err.println("unknown option: " + arg);
            GenPeer.showUsage();
            return false;
        }
        return clsName != null;
    }

    static void showUsage() {
        System.out.println("usage:   'GenPeer [<option>..] <className> [<method>..]'");
        System.out.println("options:  -s  : system peer class (gov.nasa.jpf.jvm)");
        System.out.println("          -ci : create <clinit> MJI method");
        System.out.println("          -m  : create mangled method names");
        System.out.println("          -a  : create MJI methods for all target class methods");
        System.out.println("          -dc : create isDeterministic condition methods");
        System.out.println("          -de : create isExecutable condition methods");
        System.out.println("          -nd : mark methods as non-deterministic");
    }

    static String stripType(String s) {
        return GenPeer.stripType("java.lang", s);
    }

    static String stripType(String prefix, String s) {
        int i = s.lastIndexOf(46) + 1;
        int l = s.length() - 1;
        if (s.charAt(l) == ';') {
            s = s.substring(0, l);
        }
        if (prefix == null) {
            if (i == 0) {
                return s;
            }
            return s.substring(i);
        }
        if (s.startsWith(prefix) && prefix.length() + 1 == i) {
            return s.substring(i);
        }
        return s;
    }
}

