/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.report.ConsolePublisher;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.search.Search;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Stack;

public class DeadlockAnalyzer
extends ListenerAdapter {
    static String[] opTypeMnemonic = new String[]{"B", "L", "U", "W", "N", "A", "S", "T"};
    ThreadOp lastOp;
    ThreadOp lastTransition;
    int maxHistory;
    String format;
    JVM vm;
    Search search;
    HashMap<Integer, ThreadOp> storedTransition = new HashMap();

    public DeadlockAnalyzer(Config config, JPF jpf) {
        jpf.addPublisherExtension(ConsolePublisher.class, this);
        this.maxHistory = config.getInt("deadlock.max_history", Integer.MAX_VALUE);
        this.format = config.getString("deadlock.format", "essential");
        this.vm = jpf.getVM();
        this.search = jpf.getSearch();
    }

    boolean requireAllOps() {
        return this.format.equalsIgnoreCase("essential");
    }

    void addOp(JVM vm, OpType opType) {
        ThreadOp op = new ThreadOp(vm, opType);
        if (this.lastOp == null) {
            this.lastOp = op;
        } else {
            assert (this.lastOp.stateId == 0);
            op.prevOp = this.lastOp;
            this.lastOp = op;
        }
    }

    void printRawOps(PrintWriter pw) {
        int i = 0;
        ThreadOp tOp = this.lastTransition;
        while (tOp != null) {
            ThreadOp op = tOp;
            while (op != null) {
                if (i++ >= this.maxHistory) {
                    pw.println("...");
                    return;
                }
                op.printOn(pw);
                op = op.prevOp;
            }
            tOp = tOp.prevTransition;
        }
    }

    void printEssentialOps(PrintWriter pw) {
        ThreadOp tOp2;
        LinkedHashSet<ThreadInfo> threads = new LinkedHashSet<ThreadInfo>();
        ArrayList<ThreadOp> ops = new ArrayList<ThreadOp>();
        HashMap waits = new HashMap();
        HashMap<ElementInfo, ThreadInfo> blocks = new HashMap<ElementInfo, ThreadInfo>();
        HashSet<ThreadInfo> runnables = new HashSet<ThreadInfo>();
        ThreadOp trans = this.lastTransition;
        while (trans != null) {
            tOp2 = trans;
            while (tOp2 != null) {
                HashMap<ElementInfo, ThreadInfo> map;
                OpType ot = tOp2.opType;
                ThreadInfo oti = tOp2.ti;
                if (ot == OpType.wait || ot == OpType.block) {
                    if (!runnables.contains(oti) && !threads.contains(oti)) {
                        map = ot == OpType.block ? blocks : waits;
                        threads.add(oti);
                        map.put(tOp2.ei, oti);
                        ops.add(tOp2);
                    }
                } else if (ot == OpType.notify || ot == OpType.notifyAll || ot == OpType.lock) {
                    map = ot == OpType.lock ? blocks : waits;
                    ThreadInfo ti = (ThreadInfo)map.get(tOp2.ei);
                    if (ti != null && ti != oti) {
                        if (!threads.contains(oti)) {
                            threads.add(oti);
                        }
                        map.remove(tOp2.ei);
                        ops.add(tOp2);
                    }
                    runnables.add(oti);
                } else if (ot == OpType.unlock) {
                    runnables.add(oti);
                } else if (ot == OpType.terminated || ot == OpType.started) {
                    ops.add(tOp2);
                }
                tOp2 = tOp2.prevOp;
            }
            trans = trans.prevTransition;
        }
        ListIterator it = ops.listIterator();
        while (it.hasNext()) {
            tOp2 = (ThreadOp)it.next();
            if (tOp2.opType != OpType.terminated && tOp2.opType != OpType.started || threads.contains(tOp2.ti)) continue;
            it.remove();
        }
        this.printHeader(pw, threads);
        for (ThreadOp tOp2 : ops) {
            tOp2.printColumnOn(pw, threads);
            tOp2.printLocOn(pw);
            pw.println();
        }
    }

    Collection<ThreadInfo> getThreadList() {
        ArrayList<ThreadInfo> tcol = new ArrayList<ThreadInfo>();
        boolean allOps = this.requireAllOps();
        int i = 0;
        ThreadOp tOp = this.lastTransition;
        while (tOp != null && (allOps || ++i < this.maxHistory)) {
            block2: {
                for (ThreadInfo ti : tcol) {
                    if (ti != tOp.ti) continue;
                    break block2;
                }
                tcol.add(tOp.ti);
            }
            tOp = tOp.prevTransition;
        }
        return tcol;
    }

    void printHeader(PrintWriter pw, Collection<ThreadInfo> tlist) {
        for (ThreadInfo ti : tlist) {
            pw.print(String.format("  %1$2d    ", ti.getIndex()));
        }
        pw.print(" trans    insn     loc");
        pw.println();
        for (int i = 0; i < tlist.size(); ++i) {
            pw.print("------- ");
        }
        pw.print("-----------------------");
        pw.println();
    }

    void printColumnOps(PrintWriter pw) {
        int i = 0;
        Collection<ThreadInfo> tlist = this.getThreadList();
        this.printHeader(pw, tlist);
        ThreadOp tOp = this.lastTransition;
        while (tOp != null) {
            ThreadOp op = tOp;
            while (op != null) {
                if (i++ >= this.maxHistory) {
                    pw.println("...");
                    return;
                }
                op.printColumnOn(pw, tlist);
                op.printLocOn(pw);
                pw.println();
                op = op.prevOp;
            }
            tOp = tOp.prevTransition;
        }
    }

    ElementInfo[] getLocks(ThreadInfo[] tlist, int status) {
        ElementInfo[] elist = new ElementInfo[tlist.length];
        for (int i = 0; i < elist.length; ++i) {
            if (tlist[i].getStatus() != status) continue;
            elist[i] = tlist[i].getLockObject();
        }
        return elist;
    }

    boolean showOp(ThreadOp op, ThreadInfo[] tlist, boolean[] waitSeen, boolean[] notifySeen, boolean[] blockSeen, boolean[] lockSeen, Stack<ElementInfo>[] unlocked) {
        int idx;
        ThreadInfo ti = op.ti;
        ElementInfo ei = op.ei;
        for (idx = 0; idx < tlist.length && tlist[idx] != ti; ++idx) {
        }
        switch (op.opType) {
            case block: {
                if (ti.isBlocked() && !blockSeen[idx]) {
                    blockSeen[idx] = true;
                    return true;
                }
                return false;
            }
            case unlock: {
                unlocked[idx].push(ei);
                return false;
            }
            case lock: {
                if (!unlocked[idx].isEmpty() && unlocked[idx].peek() == ei) {
                    unlocked[idx].pop();
                    return false;
                }
                for (int i = 0; i < tlist.length; ++i) {
                    if (i == idx || !tlist[i].isBlocked() || tlist[i].getLockObject() != ei || lockSeen[i]) continue;
                    lockSeen[i] = true;
                    return true;
                }
                return false;
            }
            case wait: {
                if (ti.isWaiting() && !waitSeen[idx]) {
                    waitSeen[idx] = true;
                    return true;
                }
                return false;
            }
            case notify: 
            case notifyAll: {
                for (int i = 0; i < tlist.length; ++i) {
                    if (i == idx || !tlist[i].isWaiting() || tlist[i].getLockObject() != ei || notifySeen[i]) continue;
                    notifySeen[i] = true;
                    return true;
                }
                return false;
            }
            case started: 
            case terminated: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void objectLocked(JVM vm) {
        this.addOp(vm, OpType.lock);
    }

    @Override
    public void objectUnlocked(JVM vm) {
        this.addOp(vm, OpType.unlock);
    }

    @Override
    public void objectWait(JVM vm) {
        this.addOp(vm, OpType.wait);
    }

    @Override
    public void objectNotify(JVM vm) {
        this.addOp(vm, OpType.notify);
    }

    @Override
    public void objectNotifyAll(JVM vm) {
        this.addOp(vm, OpType.notifyAll);
    }

    @Override
    public void threadBlocked(JVM vm) {
        this.addOp(vm, OpType.block);
    }

    @Override
    public void threadStarted(JVM vm) {
        this.addOp(vm, OpType.started);
    }

    @Override
    public void threadTerminated(JVM vm) {
        this.addOp(vm, OpType.terminated);
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.isNewState() && this.lastOp != null) {
            int stateId = search.getStateNumber();
            ThreadInfo ti = this.lastOp.ti;
            ThreadOp op = this.lastOp;
            while (op != null) {
                assert (op.stateId == 0);
                op.stateId = stateId;
                op = op.prevOp;
            }
            this.lastOp.prevTransition = this.lastTransition;
            this.lastTransition = this.lastOp;
        }
        this.lastOp = null;
    }

    @Override
    public void stateBacktracked(Search search) {
        int stateId = search.getStateNumber();
        while (this.lastTransition != null && this.lastTransition.stateId > stateId) {
            this.lastTransition = this.lastTransition.prevTransition;
        }
        this.lastOp = null;
    }

    @Override
    public void stateStored(Search search) {
        this.storedTransition.put(search.getStateNumber(), this.lastTransition);
    }

    @Override
    public void stateRestored(Search search) {
        int stateId = search.getStateNumber();
        ThreadOp op = this.storedTransition.get(stateId);
        if (op != null) {
            this.lastTransition = op;
            this.storedTransition.remove(stateId);
        }
    }

    @Override
    public void publishPropertyViolation(Publisher publisher) {
        PrintWriter pw = publisher.getOut();
        publisher.publishTopicStart("thread ops " + publisher.getLastErrorId());
        if ("column".equalsIgnoreCase(this.format)) {
            this.printColumnOps(pw);
        } else if ("essential".equalsIgnoreCase(this.format)) {
            this.printEssentialOps(pw);
        } else {
            this.printRawOps(pw);
        }
    }

    static class ThreadOp {
        ThreadInfo ti;
        ElementInfo ei;
        Instruction insn;
        OpType opType;
        int stateId;
        ThreadOp prevTransition;
        ThreadOp prevOp;

        ThreadOp(JVM vm, OpType type) {
            this.ti = vm.getLastThreadInfo();
            this.ei = vm.getLastElementInfo();
            this.insn = this.ti.getPC();
            this.opType = type;
            this.prevOp = null;
        }

        void printLocOn(PrintWriter pw) {
            pw.print(String.format("%6d", new Integer(this.stateId)));
            if (this.insn != null) {
                pw.print(String.format(" %10.10s ", this.insn.getMnemonic()));
                pw.print(this.insn.getFileLocation());
                String line = this.insn.getSourceLine();
                if (line != null) {
                    pw.print(" : ");
                    pw.print(line.trim());
                }
            }
        }

        void printOn(PrintWriter pw) {
            pw.print(this.stateId);
            pw.print(" : ");
            pw.print(this.ti.getName());
            pw.print(" : ");
            pw.print(this.opType.name());
            pw.print(" : ");
            pw.println(this.ei);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.stateId);
            sb.append(" : ");
            sb.append(this.ti.getName());
            sb.append(" : ");
            sb.append(this.opType.name());
            sb.append(" : ");
            sb.append(this.ei);
            return sb.toString();
        }

        void printColumnOn(PrintWriter pw, Collection<ThreadInfo> tlist) {
            for (ThreadInfo t : tlist) {
                if (this.ti == t) {
                    if (this.opType == OpType.started || this.opType == OpType.terminated) {
                        pw.print(String.format("   %1$s    ", opTypeMnemonic[this.opType.ordinal()]));
                        continue;
                    }
                    pw.print(String.format("%1$s:%2$-5d ", opTypeMnemonic[this.opType.ordinal()], this.ei.getIndex()));
                    continue;
                }
                pw.print("   |    ");
            }
        }
    }

    static enum OpType {
        block,
        lock,
        unlock,
        wait,
        notify,
        notifyAll,
        started,
        terminated;

    }
}

