/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.InfoObject;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.test.Contract;
import gov.nasa.jpf.test.ContractAnd;
import gov.nasa.jpf.test.ContractContext;
import gov.nasa.jpf.test.ContractSpecLexer;
import gov.nasa.jpf.test.ContractSpecParser;
import gov.nasa.jpf.test.EmptyContract;
import gov.nasa.jpf.test.VarLookup;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.logging.Logger;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class ContractVerifier
extends ListenerAdapter {
    protected static Logger log = JPF.getLogger("gov.nasa.jpf.test");
    IdentityHashMap<StackFrame, PostCond> pending = new IdentityHashMap();
    HashMap<InfoObject, Contract> dictPre = new HashMap();
    HashMap<InfoObject, Contract> dictPost = new HashMap();
    HashMap<InfoObject, Contract> dictIInv = new HashMap();
    ContractContext ctx = new ContractContext(log);

    @Override
    public void classLoaded(JVM vm) {
        this.getInvariant(vm.getLastClassInfo());
    }

    ClassInfo getClassInfo(StackFrame frame) {
        MethodInfo mi = frame.getMethodInfo();
        if (mi.isStatic()) {
            return mi.getClassInfo();
        }
        int thisRef = frame.getThis();
        Object ei = DynamicArea.getHeap().get(thisRef);
        return ((ElementInfo)ei).getClassInfo();
    }

    @Override
    public void executeInstruction(JVM vm) {
        Instruction insn = vm.getLastInstruction();
        if (insn instanceof ReturnInstruction) {
            ThreadInfo ti = vm.getLastThreadInfo();
            StackFrame frame = ti.getTopFrame();
            MethodInfo mi = frame.getMethodInfo();
            this.ctx.setContextInfo(mi, ti);
            if (!frame.isDirectCallFrame()) {
                VarLookup.Invariant lookupPolicy;
                Contract inv;
                ClassInfo ci;
                PostCond pc = this.pending.get(frame);
                if (pc != null) {
                    Contract postCond = pc.contract;
                    VarLookup.PostCond lookupPolicy2 = new VarLookup.PostCond(ti, (ReturnInstruction)insn, pc.lookupPolicy);
                    if (!postCond.holdsAll(lookupPolicy2)) {
                        Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", this.getErrorMessage(postCond, lookupPolicy2, "postcondition", "AND"));
                        ti.setNextPC(nextPc);
                        this.pending.remove(frame);
                        return;
                    }
                    this.pending.remove(frame);
                }
                if ((ci = this.getClassInfo(frame)) != null && !mi.isStatic() && !mi.isCtor() && (inv = this.dictIInv.get(ci)).hasNonEmptyContracts() && !inv.holdsAll(lookupPolicy = new VarLookup.Invariant(ti))) {
                    Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", this.getErrorMessage(inv, lookupPolicy, "invariant", "AND"));
                    ti.setNextPC(nextPc);
                    return;
                }
            }
        }
    }

    @Override
    public void instructionExecuted(JVM vm) {
        Instruction insn = vm.getLastInstruction();
        if (insn instanceof InvokeInstruction) {
            Contract postCond;
            VarLookup.PreCond lookup;
            InvokeInstruction call = (InvokeInstruction)insn;
            MethodInfo mi = call.getInvokedMethod();
            ThreadInfo ti = vm.getLastThreadInfo();
            this.ctx.setContextInfo(mi, ti);
            Contract preCond = this.getPreCondition(mi);
            if (!preCond.isEmpty() && !preCond.holdsAny(lookup = new VarLookup.PreCond(ti, call))) {
                Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", this.getErrorMessage(preCond, lookup, "precondition", "OR"));
                ti.setNextPC(nextPc);
            }
            if ((postCond = this.getPostCondition(mi)).hasNonEmptyContracts()) {
                VarLookup.PostCondPreExec lookup2 = new VarLookup.PostCondPreExec(ti);
                postCond.saveOldValues(lookup2);
                lookup2.purgeVars();
                StackFrame frame = ti.getTopFrame();
                PostCond pc = new PostCond(frame, postCond, lookup2);
                this.pending.put(frame, pc);
            }
        }
    }

    String getErrorMessage(Contract c, VarLookup policy, String type, String combinator) {
        String msg = type;
        msg = msg + " violated: ";
        msg = msg + c.getErrorMessage(policy, combinator);
        HashMap<Object, Object> values = policy.getCache();
        if (!values.isEmpty()) {
            msg = msg + ", values=";
            msg = msg + values;
        }
        return msg;
    }

    Contract loadContract(String annotation, InfoObject iobj, HashMap<InfoObject, Contract> dict) {
        Contract contract = null;
        AnnotationInfo ai = iobj.getAnnotation(annotation);
        if (ai != null) {
            Object v = ai.value();
            if (v instanceof String) {
                contract = this.parseContractSpec((String)v);
            } else if (v instanceof Object[]) {
                for (Object s : (Object[])v) {
                    Contract c = this.parseContractSpec(s.toString());
                    contract = contract == null ? c : new ContractAnd(contract, c);
                }
            }
        } else {
            contract = new EmptyContract();
        }
        dict.put(iobj, contract);
        return contract;
    }

    Contract getContract(String annotation, MethodInfo mi, HashMap<InfoObject, Contract> dict) {
        MethodInfo smi;
        Contract contract = dict.get(mi);
        if (contract == null) {
            contract = this.loadContract(annotation, mi, dict);
        }
        if ((smi = mi.getOverriddenMethodInfo()) != null) {
            contract.setSuperContract(this.getContract(annotation, smi, dict));
        }
        return contract;
    }

    Contract getContract(String annotation, ClassInfo ci, HashMap<InfoObject, Contract> dict) {
        ClassInfo sci;
        Contract contract = dict.get(ci);
        if (contract == null) {
            contract = this.loadContract(annotation, ci, dict);
        }
        if ((sci = ci.getSuperClass()) != null) {
            contract.setSuperContract(this.getContract(annotation, sci, dict));
        }
        return contract;
    }

    Contract getPreCondition(MethodInfo mi) {
        return this.getContract("gov.nasa.jpf.Requires", mi, this.dictPre);
    }

    Contract getPostCondition(MethodInfo mi) {
        return this.getContract("gov.nasa.jpf.Ensures", mi, this.dictPost);
    }

    Contract getInvariant(ClassInfo ci) {
        return this.getContract("gov.nasa.jpf.Invariant", ci, this.dictIInv);
    }

    Contract parseContractSpec(String spec) {
        ANTLRStringStream input = new ANTLRStringStream(spec);
        ContractSpecLexer lexer = new ContractSpecLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ContractSpecParser parser = new ContractSpecParser((TokenStream)tokens, this.ctx);
        try {
            Contract contract = parser.contract();
            return contract;
        }
        catch (RecognitionException rx) {
            this.error("spec did not parse: " + (Object)((Object)rx));
            return null;
        }
    }

    void error(String msg) {
        System.err.println(msg);
    }

    static class PostCond {
        VarLookup lookupPolicy;
        Contract contract;
        StackFrame frame;

        PostCond(StackFrame f, Contract c, VarLookup p) {
            this.frame = f;
            this.contract = c;
            this.lookupPolicy = p;
        }
    }
}

