/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.PUTFIELD;
import gov.nasa.jpf.jvm.bytecode.PUTSTATIC;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.Trace;

public class ConstChecker
extends ListenerAdapter {
    Trace<ConstContext> constContext = new Trace();

    public ConstChecker(Config conf) {
        this.constContext.addOp(new ConstContext());
    }

    AnnotationInfo getAnnotation(MethodInfo mi) {
        return mi.getAnnotation("gov.nasa.jpf.Const");
    }

    @Override
    public void instructionExecuted(JVM vm) {
        ThreadInfo ti = vm.getLastThreadInfo();
        Instruction insn = vm.getLastInstruction();
        if (!insn.isCompleted(ti)) {
            return;
        }
        if (insn instanceof InvokeInstruction) {
            AnnotationInfo ai;
            InvokeInstruction call = (InvokeInstruction)insn;
            MethodInfo mi = call.getInvokedMethod();
            if (!mi.isDirectCallStub() && (ai = this.getAnnotation(mi)) != null) {
                ConstContext cc = this.constContext.getLastOp();
                if (!mi.isStatic()) {
                    int objRef = ti.getThis();
                    int clsRef = ((DynamicElementInfo)vm.getDynamicArea().get(objRef)).getClassInfo().getClassObjectRef();
                    this.constContext.addOp(cc.incRefs(objRef, clsRef));
                } else {
                    int clsRef = mi.getClassInfo().getClassObjectRef();
                    this.constContext.addOp(cc.incRef(clsRef));
                }
            }
        } else if (insn instanceof ReturnInstruction) {
            ConstContext cc;
            AnnotationInfo ai;
            ReturnInstruction ret = (ReturnInstruction)insn;
            MethodInfo mi = insn.getMethodInfo();
            if (!mi.isDirectCallStub() && (ai = this.getAnnotation(mi)) != null && (cc = this.constContext.getLastOp()) != null) {
                if (!mi.isStatic()) {
                    int objRef = ret.getReturnFrame().getThis();
                    int clsRef = ((DynamicElementInfo)vm.getDynamicArea().get(objRef)).getClassInfo().getClassObjectRef();
                    this.constContext.addOp(cc.decRefs(objRef, clsRef));
                } else {
                    int clsRef = mi.getClassInfo().getClassObjectRef();
                    this.constContext.addOp(cc.decRef(clsRef));
                }
            }
        } else if (insn instanceof PUTFIELD) {
            PUTFIELD put = (PUTFIELD)insn;
            int objRef = put.getLastThis();
            ConstContext cc = this.constContext.getLastOp();
            if (cc != null) {
                if (cc.includes(objRef)) {
                    Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", "instance field write within const context: " + put.getFieldInfo());
                    ti.setNextPC(nextPc);
                    return;
                }
                int clsRef = ((DynamicElementInfo)vm.getDynamicArea().get(objRef)).getClassInfo().getClassObjectRef();
                if (cc.includes(clsRef)) {
                    Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", "static field write within const context: " + put.getFieldInfo());
                    ti.setNextPC(nextPc);
                    return;
                }
            }
        } else if (insn instanceof PUTSTATIC) {
            PUTSTATIC put = (PUTSTATIC)insn;
            int clsRef = put.getFieldInfo().getClassInfo().getClassObjectRef();
            ConstContext cc = this.constContext.getLastOp();
            if (cc != null && cc.includes(clsRef)) {
                Instruction nextPc = ti.createAndThrowException("java.lang.AssertionError", "static field write within const context: " + put.getFieldInfo());
                ti.setNextPC(nextPc);
                return;
            }
        }
    }

    @Override
    public void stateAdvanced(Search search) {
        this.constContext.stateAdvanced(search);
    }

    @Override
    public void stateBacktracked(Search search) {
        this.constContext.stateBacktracked(search);
    }

    @Override
    public void stateStored(Search search) {
        this.constContext.stateStored(search);
    }

    @Override
    public void stateRestored(Search search) {
        this.constContext.stateRestored(search);
    }

    static class ConstContext {
        ConstObj[] consts;

        ConstContext() {
            this.consts = new ConstObj[0];
        }

        ConstContext(ConstObj[] c) {
            this.consts = c;
        }

        ConstContext incRef(int ref) {
            for (int i = 0; i < this.consts.length; ++i) {
                if (this.consts[i].ref != ref) continue;
                ConstObj[] newConsts = (ConstObj[])this.consts.clone();
                newConsts[i] = this.consts[i].inc();
                return new ConstContext(newConsts);
            }
            ConstObj[] newConsts = new ConstObj[this.consts.length + 1];
            if (this.consts.length > 0) {
                System.arraycopy(this.consts, 0, newConsts, 0, this.consts.length);
            }
            newConsts[this.consts.length] = new ConstObj(ref, 1);
            return new ConstContext(newConsts);
        }

        ConstContext decRef(int ref) {
            for (int i = 0; i < this.consts.length; ++i) {
                ConstObj[] newConsts;
                if (this.consts[i].ref != ref) continue;
                if (this.consts[i].count > 1) {
                    newConsts = (ConstObj[])this.consts.clone();
                    newConsts[i] = this.consts[i].dec();
                } else {
                    int l = this.consts.length - 1;
                    if (l > 0) {
                        newConsts = new ConstObj[l];
                        if (i > 0) {
                            System.arraycopy(this.consts, 0, newConsts, 0, i);
                        }
                        if (i < l) {
                            System.arraycopy(this.consts, i + 1, newConsts, i, l - i);
                        }
                    } else {
                        newConsts = new ConstObj[]{};
                    }
                }
                return new ConstContext(newConsts);
            }
            return this;
        }

        ConstContext incRefs(int ref1, int ref2) {
            ConstContext c = this;
            if (ref1 != -1) {
                c = c.incRef(ref1);
            }
            if (ref2 != -1) {
                c = c.incRef(ref2);
            }
            return c;
        }

        ConstContext decRefs(int ref1, int ref2) {
            ConstContext c = this;
            if (ref1 != -1) {
                c = c.decRef(ref1);
            }
            if (ref2 != -1) {
                c = c.decRef(ref2);
            }
            return c;
        }

        boolean includes(int ref) {
            for (int i = this.consts.length - 1; i >= 0; --i) {
                if (this.consts[i].ref != ref) continue;
                return true;
            }
            return false;
        }
    }

    static class ConstObj {
        int ref;
        int count;

        ConstObj(int r, int c) {
            this.ref = r;
            this.count = c;
        }

        ConstObj inc() {
            return new ConstObj(this.ref, this.count + 1);
        }

        ConstObj dec() {
            assert (this.count > 0);
            return new ConstObj(this.ref, this.count - 1);
        }
    }
}

