/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ChoicePoint;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.StringSetMatcher;
import java.util.Random;

public class ChoiceSelector
extends ListenerAdapter {
    Random random;
    boolean singleChoice = true;
    StringSetMatcher threadSet;
    boolean threadsAlive = true;
    StringSetMatcher calls;
    boolean callSeen = true;
    int startDepth;
    boolean depthReached = true;
    ChoicePoint trace;
    boolean searchAfterTrace;

    public ChoiceSelector(Config config, JPF jpf) {
        this.random = new Random(config.getInt("choice.seed", 42));
        this.threadSet = StringSetMatcher.getNonEmpty(config.getStringArray("choice.threads"));
        if (this.threadSet != null) {
            this.threadsAlive = false;
        }
        this.calls = StringSetMatcher.getNonEmpty(config.getStringArray("choice.calls"));
        this.callSeen = false;
        this.startDepth = config.getInt("choice.depth", -1);
        if (this.startDepth != -1) {
            this.depthReached = false;
        }
        if (this.threadSet == null && this.calls == null && this.startDepth == -1) {
            this.threadsAlive = false;
            this.callSeen = false;
            this.depthReached = false;
        }
        JVM vm = jpf.getVM();
        this.trace = ChoicePoint.readTrace(config.getString("choice.use_trace"), vm.getMainClassName(), vm.getArgs());
        this.searchAfterTrace = config.getBoolean("choice.search_after_trace", true);
        vm.setTraceReplay(this.trace != null);
    }

    void checkSingleChoiceCond() {
        this.singleChoice = !this.depthReached || !this.callSeen || !this.threadsAlive;
    }

    @Override
    public void choiceGeneratorAdvanced(JVM vm) {
        ChoiceGenerator cg = vm.getLastChoiceGenerator();
        int n = cg.getTotalNumberOfChoices();
        if (this.trace != null) {
            assert (cg.getClass().getName().equals(this.trace.getCgClassName())) : "wrong choice generator class, expecting: " + this.trace.getCgClassName() + ", read: " + cg.getClass().getName();
            cg.select(this.trace.getChoice());
        } else if (this.singleChoice && n > 1) {
            int r = this.random.nextInt(n);
            cg.select(r);
        }
    }

    @Override
    public void threadStarted(JVM vm) {
        ThreadInfo ti;
        String tname;
        if (this.singleChoice && this.threadSet != null && this.threadSet.matchesAny(tname = (ti = vm.getLastThreadInfo()).getName())) {
            this.threadsAlive = true;
            this.checkSingleChoiceCond();
        }
    }

    @Override
    public void executeInstruction(JVM vm) {
        if (this.singleChoice && !this.callSeen && this.calls != null) {
            String mthName;
            Instruction insn = vm.getLastInstruction();
            ThreadInfo ti = vm.getLastThreadInfo();
            if (insn instanceof InvokeInstruction && this.calls.matchesAny(mthName = ((InvokeInstruction)insn).getInvokedMethod(ti).getBaseName())) {
                this.callSeen = true;
                this.checkSingleChoiceCond();
            }
        }
    }

    @Override
    public void stateAdvanced(Search search) {
        if (this.trace != null) {
            this.trace = this.trace.getNext();
            if (this.trace == null) {
                search.getVM().setTraceReplay(false);
                if (this.searchAfterTrace) {
                    this.singleChoice = false;
                }
            }
        } else if (this.singleChoice && !this.depthReached && this.startDepth >= 0 && search.getDepth() == this.startDepth) {
            this.depthReached = true;
            this.checkSingleChoiceCond();
        }
    }
}

