/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.search.Search;

public class CGMonitor
extends ListenerAdapter {
    int depth;
    boolean isFirstInsn = true;
    boolean showInsn = false;

    public CGMonitor(Config conf) {
        this.showInsn = conf.getBoolean("cg.show_insn");
    }

    @Override
    public void stateAdvanced(Search search) {
        ++this.depth;
    }

    @Override
    public void stateBacktracked(Search search) {
        --this.depth;
    }

    @Override
    public void stateRestored(Search search) {
        this.depth = search.getDepth();
    }

    void printPrefix(char c) {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(c);
        }
    }

    @Override
    public void choiceGeneratorAdvanced(JVM vm) {
        ChoiceGenerator cg = vm.getChoiceGenerator();
        this.printPrefix('.');
        System.out.print(cg);
        if (!this.showInsn) {
            System.out.println();
        }
        this.isFirstInsn = true;
    }

    @Override
    public void instructionExecuted(JVM vm) {
        if (this.showInsn && this.isFirstInsn) {
            ThreadInfo ti = vm.getCurrentThread();
            Instruction insn = vm.getLastInstruction();
            System.out.print(" : [");
            System.out.print(ti.getIndex());
            System.out.print("] ");
            System.out.print(insn);
            System.out.print(" (in ");
            System.out.print(insn.getMethodInfo().getFullName());
            System.out.print(":");
            System.out.print(insn.getOffset());
            System.out.println(')');
            this.isFirstInsn = false;
        }
    }
}

