/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.tools;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.report.ConsolePublisher;
import gov.nasa.jpf.report.Publisher;
import gov.nasa.jpf.report.PublisherExtensionAdapter;
import gov.nasa.jpf.search.Search;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class BudgetChecker
extends ListenerAdapter {
    static final int CHECK_INTERVAL = 10000;
    static final int CHECK_INTERVAL1 = 9999;
    long tStart;
    MemoryUsage muStart;
    long mStart;
    MemoryMXBean mxb;
    JVM vm;
    Search search;
    long insnCount;
    long maxTime;
    long maxState;
    long maxDepth;
    long maxInsn;
    long maxHeap;
    String message;

    public BudgetChecker(Config conf, JPF jpf) {
        this.maxTime = conf.getDuration("jpf.budget.max_time", -1L);
        this.maxHeap = conf.getMemorySize("jpf.budget.max_heap", -1L);
        this.maxDepth = conf.getLong("jpf.budget.max_depth", -1L);
        this.maxInsn = conf.getLong("jpf.budget.max_insn", -1L);
        this.maxState = conf.getLong("jpf.budget.max_state", -1L);
        this.tStart = System.currentTimeMillis();
        if (this.maxHeap > 0L) {
            this.mxb = ManagementFactory.getMemoryMXBean();
            this.muStart = this.mxb.getHeapMemoryUsage();
            this.mStart = this.muStart.getUsed();
        }
        this.search = jpf.getSearch();
        this.vm = jpf.getVM();
        jpf.addPublisherExtension(ConsolePublisher.class, new ConsolePublisherExtension());
    }

    public boolean timeExceeded() {
        long dur;
        if (this.maxTime > 0L && (dur = System.currentTimeMillis() - this.tStart) > this.maxTime) {
            this.message = "max time exceeded: " + Publisher.formatHMS(dur) + " >= " + Publisher.formatHMS(this.maxTime);
            return true;
        }
        return false;
    }

    public boolean heapExceeded() {
        MemoryUsage mu;
        long used;
        if (this.maxHeap > 0L && (used = (mu = this.mxb.getHeapMemoryUsage()).getUsed() - this.mStart) > this.maxHeap) {
            this.message = "max heap exceeded: " + used / 0x100000L + "MB" + " >= " + this.maxHeap / 0x100000L + "MB";
            return true;
        }
        return false;
    }

    public boolean depthExceeded() {
        int d;
        if (this.maxDepth > 0L && (long)(d = this.search.getDepth()) > this.maxDepth) {
            this.message = "max search depth exceeded: " + d + " >= " + this.maxDepth;
            return true;
        }
        return false;
    }

    public boolean statesExceeded() {
        int stateId;
        if (this.maxState > 0L && (long)(stateId = this.vm.getStateId()) > this.maxState) {
            this.message = "max states exceeded: " + stateId + " >= " + this.maxState;
            return true;
        }
        return false;
    }

    public boolean insnExceeded() {
        if (this.maxInsn > 0L && this.insnCount > this.maxInsn) {
            this.message = "max instruction count exceeded: " + this.insnCount + " >= " + this.maxInsn;
            return true;
        }
        return false;
    }

    @Override
    public void stateAdvanced(Search search) {
        if (this.timeExceeded() || this.heapExceeded()) {
            search.terminate();
        }
    }

    @Override
    public void instructionExecuted(JVM vm) {
        if (this.insnCount++ % 10000L == 9999L && (this.timeExceeded() || this.heapExceeded() || this.insnExceeded())) {
            vm.getCurrentThread().breakTransition();
            this.search.terminate();
        }
    }

    class ConsolePublisherExtension
    extends PublisherExtensionAdapter {
        ConsolePublisherExtension() {
        }

        @Override
        public void publishFinished(Publisher publisher) {
            if (BudgetChecker.this.message != null) {
                PrintWriter pw = publisher.getOut();
                publisher.publishTopicStart("budget exceeded");
                pw.println(BudgetChecker.this.message);
            }
        }
    }
}

