/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test.predicate;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.test.ContractException;
import gov.nasa.jpf.test.NativePredicate;
import java.util.ArrayList;

public class IsMonotonicDecreasing
implements NativePredicate {
    int lastStateId;
    Number lastNumber;

    public IsMonotonicDecreasing() {
        Listener l = Listener.getSingleton();
        l.add(this);
    }

    public String evaluate(Object testObj, Object[] args) {
        if (!(testObj instanceof Number)) {
            throw new ContractException("IsMonotonicDecreasing test object not a Number: " + testObj);
        }
        Number num = (Number)testObj;
        JVM vm = JVM.getVM();
        int sid = vm.getStateId();
        if (this.lastNumber != null && this.lastNumber.doubleValue() < num.doubleValue()) {
            return "IsMonotonicDecreasing failed: " + this.lastNumber + ", " + num;
        }
        this.lastStateId = sid;
        this.lastNumber = num;
        return null;
    }

    static class Listener
    extends ListenerAdapter {
        static Listener singleton;
        ArrayList<IsMonotonicDecreasing> watchList = new ArrayList();

        Listener() {
        }

        static Listener getSingleton() {
            if (singleton == null) {
                singleton = new Listener();
                JVM vm = JVM.getVM();
                JPF jpf = vm.getJPF();
                jpf.addListener(singleton);
            }
            return singleton;
        }

        void add(IsMonotonicDecreasing pred) {
            this.watchList.add(pred);
        }

        @Override
        public void stateBacktracked(Search search) {
            int sid = search.getStateNumber();
            for (IsMonotonicDecreasing pred : this.watchList) {
                if (pred.lastStateId < sid) continue;
                pred.lastNumber = null;
            }
        }
    }
}

