/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.ArgList;
import gov.nasa.jpf.test.FieldReference;
import gov.nasa.jpf.test.Goal;
import gov.nasa.jpf.test.MemoryGoal;
import gov.nasa.jpf.test.TestException;
import gov.nasa.jpf.util.Misc;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class TestContext {
    static final Object[] NO_ARGS = new Object[0];
    static final Class<?>[] NO_ARG_TYPES = new Class[0];
    static HashMap<String, Class<? extends Goal>> goalMap = new HashMap();
    Class<?> tgtClass;
    String pkgPrefix;
    PrintWriter log;
    PrintWriter err;
    Object tgtObject;

    public TestContext(Class<?> tgtClass, PrintWriter log, PrintWriter err) {
        Package pkg = tgtClass.getPackage();
        this.pkgPrefix = pkg != null ? pkg.getName() : null;
        this.tgtClass = tgtClass;
        this.log = log;
        this.err = err;
    }

    public Goal createGoal(String id, ArgList args) {
        Class<Goal> goalCls = goalMap.get(id);
        if (goalCls == null) {
            try {
                Class<?> cls = Class.forName(id);
                if (!Goal.class.isAssignableFrom(cls)) {
                    this.error("not a goal class: " + cls.getName());
                    return null;
                }
                goalCls = cls;
            }
            catch (ClassNotFoundException cnfx) {
                this.error("goal class not found: " + id);
            }
        }
        Class[] at = new Class[]{TestContext.class, ArgList.class};
        Object[] a = new Object[]{this, args};
        Goal g = Misc.createObject(goalCls, at, a);
        if (g == null) {
            this.error("cannot instantiate goal class: " + goalCls.getName());
        }
        return g;
    }

    public void setTargetObject(Object o) {
        this.tgtObject = o;
    }

    public Object getTargetObject() {
        return this.tgtObject;
    }

    public Class<?> getTargetClass() {
        return this.tgtClass;
    }

    public void error(String msg) {
        this.err.print("@ ERROR ");
        this.err.println(msg);
    }

    public void log(String msg) {
        this.log.print("@ ");
        this.log.println(msg);
    }

    public static Class<?> resolveClass(String pkgPrefix, String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            return cls;
        }
        catch (ClassNotFoundException cnfx1) {
            if (clsName.indexOf(46) < 0) {
                if (pkgPrefix != null) {
                    try {
                        Class<?> cls = Class.forName(pkgPrefix + '.' + clsName);
                        return cls;
                    }
                    catch (ClassNotFoundException cnfx2) {
                        // empty catch block
                    }
                }
                try {
                    Class<?> cls = Class.forName("java.lang." + clsName);
                    return cls;
                }
                catch (ClassNotFoundException cfnx3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public Object create(String clsName) throws TestException {
        return this.create(clsName, NO_ARGS);
    }

    public Object create(String clsName, Object[] args) throws TestException {
        try {
            Class<?> cls = TestContext.resolveClass(this.pkgPrefix, clsName);
            if (cls == null) {
                throw new TestException("class not found: " + clsName);
            }
            for (Constructor<?> ctor : cls.getDeclaredConstructors()) {
                Object[] compatibleArgs = TestContext.getCompatibleArgs(args, ctor.getParameterTypes());
                if (compatibleArgs == null) continue;
                return ctor.newInstance(compatibleArgs);
            }
            throw new TestException("no compatible constructor found: " + clsName);
        }
        catch (IllegalAccessException iax) {
            throw new TestException("default constructor not accessible: " + clsName);
        }
        catch (InstantiationException ix) {
            throw new TestException("class not instantiable: " + clsName);
        }
        catch (SecurityException sx) {
            throw new TestException("security exception");
        }
        catch (InvocationTargetException e) {
            throw new TestException("exception during instantiation: " + e.getCause(), e.getCause());
        }
    }

    public static Object[] getCompatibleArgs(Object[] args, Class<?>[] pTypes) {
        if (args == null && pTypes.length == 0) {
            return NO_ARGS;
        }
        if (args.length != pTypes.length) {
            return null;
        }
        Object[] cArgs = new Object[args.length];
        for (int i = 0; i < cArgs.length; ++i) {
            Object a = TestContext.getCompatibleObject(args[i], pTypes[i]);
            if (a == null) {
                return null;
            }
            cArgs[i] = a;
        }
        return cArgs;
    }

    public static Object getCompatibleObject(Object a, Class<?> pType) {
        Class<?> aCls = a.getClass();
        if (pType.isAssignableFrom(aCls)) {
            return a;
        }
        if (pType == TestContext.getPrimitiveType(aCls)) {
            return a;
        }
        Object casted = TestContext.getCastedObject(a, pType);
        if (casted != null) {
            return casted;
        }
        return null;
    }

    public Object getFieldValue(FieldReference fr) {
        return fr.getValue(this.tgtClass, this.tgtObject);
    }

    public static Class<?> getPrimitiveType(Class<?> cls) {
        if (cls == Integer.class) {
            return Integer.TYPE;
        }
        if (cls == Boolean.class) {
            return Boolean.TYPE;
        }
        if (cls == Long.class) {
            return Long.TYPE;
        }
        if (cls == Double.class) {
            return Double.TYPE;
        }
        if (cls == Byte.class) {
            return Byte.TYPE;
        }
        if (cls == Character.class) {
            return Character.TYPE;
        }
        if (cls == Short.class) {
            return Short.TYPE;
        }
        if (cls == Float.class) {
            return Float.TYPE;
        }
        return null;
    }

    public static Object getCastedObject(Object o, Class<?> type) {
        Class<?> cls = o.getClass();
        if (cls == Integer.class) {
            return TestContext.castInteger((Integer)o, type);
        }
        if (cls == Long.class) {
            return TestContext.castLong((Long)o, type);
        }
        if (cls == Double.class) {
            return TestContext.castDouble((Double)o, type);
        }
        if (cls == Object[].class) {
            return TestContext.castArray((Object[])o, type);
        }
        return null;
    }

    static Object castLong(Long o, Class<?> type) {
        long val = o;
        if ((type == Integer.TYPE || type == Integer.class) && val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
            return new Integer((int)val);
        }
        if ((type == Short.TYPE || type == Short.class) && val <= 32767L && val >= -32768L) {
            return new Short((short)val);
        }
        if ((type == Byte.TYPE || type == Byte.class) && val <= 127L && val >= -128L) {
            return new Byte((byte)val);
        }
        if (type == Double.TYPE || type == Double.class) {
            return new Double(val);
        }
        if (type == Float.TYPE || type == Float.class) {
            return new Float(val);
        }
        return null;
    }

    static Object castInteger(Integer o, Class<?> type) {
        int val = o;
        if ((type == Short.TYPE || type == Short.class) && val <= Short.MAX_VALUE && val >= Short.MIN_VALUE) {
            return new Short((short)val);
        }
        if ((type == Byte.TYPE || type == Byte.class) && val <= 127 && val >= -128) {
            return new Byte((byte)val);
        }
        if (type == Long.TYPE || type == Long.class) {
            return new Long(val);
        }
        if (type == Double.TYPE || type == Double.class) {
            return new Double(val);
        }
        if (type == Float.TYPE || type == Float.class) {
            return new Float(val);
        }
        return null;
    }

    static Object castDouble(Double o, Class<?> type) {
        double val = o;
        if ((type == Float.TYPE || type == Float.class) && val <= 3.4028234663852886E38 && val >= (double)1.4E-45f) {
            return new Float((float)val);
        }
        return null;
    }

    static Object castArray(Object[] o, Class<?> type) {
        if (type == Object[].class) {
            return o;
        }
        if (type == int[].class) {
            int[] a = new int[o.length];
            for (int i = 0; i < a.length; ++i) {
                if (!(o[i] instanceof Number)) {
                    return null;
                }
                a[i] = ((Number)o[i]).intValue();
            }
            return a;
        }
        if (type == String[].class) {
            String[] a = new String[o.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = o[i].toString();
            }
            return a;
        }
        if (type == double[].class) {
            double[] a = new double[o.length];
            for (int i = 0; i < a.length; ++i) {
                if (!(o[i] instanceof Number)) {
                    return null;
                }
                a[i] = ((Number)o[i]).doubleValue();
            }
            return a;
        }
        if (type == List.class || type == ArrayList.class) {
            ArrayList<Object> list = new ArrayList<Object>(o.length);
            for (int i = 0; i < o.length; ++i) {
                list.add(o[i]);
            }
            return list;
        }
        if (type == Vector.class) {
            Vector<Object> v = new Vector<Object>(o.length);
            for (int i = 0; i < o.length; ++i) {
                v.add(o[i]);
            }
            return v;
        }
        return null;
    }

    static {
        goalMap.put("AllocLimit", MemoryGoal.class);
        goalMap.put("NoAlloc", MemoryGoal.class);
    }
}

