/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.SequenceProcessor;

public abstract class SequenceOp {
    String sequenceId;

    public abstract void accept(SequenceProcessor var1);

    protected SequenceOp(String id) {
        this.sequenceId = id;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public static class End
    extends SequenceOp {
        public End(String sequenceId) {
            super(sequenceId);
        }

        @Override
        public void accept(SequenceProcessor proc) {
            proc.visit(this);
        }
    }

    public static class Exit
    extends Event {
        String res;

        public Exit(String sequenceId, String scope, String src, String tgt, String res) {
            super(sequenceId, src, tgt, scope);
            this.res = res;
        }

        public String getResult() {
            return this.res;
        }

        public String toString() {
            return "exit " + this.scope;
        }

        @Override
        public void accept(SequenceProcessor proc) {
            proc.visit(this);
        }
    }

    public static class Enter
    extends Event {
        String res;

        public Enter(String sequenceId, String scope, String src, String tgt, String res) {
            super(sequenceId, src, tgt, scope);
            this.res = res;
        }

        public String getResult() {
            return this.res;
        }

        public String toString() {
            return "enter " + this.scope;
        }

        @Override
        public void accept(SequenceProcessor proc) {
            proc.visit(this);
        }
    }

    public static class Event
    extends SequenceOp {
        String src;
        String tgt;
        String scope;

        protected Event(String sequenceId, String src, String tgt, String scope) {
            super(sequenceId);
            this.src = src;
            this.tgt = tgt;
            this.scope = scope;
        }

        public String getScope() {
            return this.scope;
        }

        public String getSrc() {
            return this.src;
        }

        public String getTgt() {
            return this.tgt;
        }

        @Override
        public void accept(SequenceProcessor proc) {
            proc.visit(this);
        }
    }

    public static class Start
    extends SequenceOp {
        public Start(String sequenceId) {
            super(sequenceId);
        }

        @Override
        public void accept(SequenceProcessor proc) {
            proc.visit(this);
        }
    }
}

