/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.Predicate;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.test.Contract;
import gov.nasa.jpf.test.ContractContext;
import gov.nasa.jpf.test.NativePredicate;
import gov.nasa.jpf.test.Operand;
import gov.nasa.jpf.test.VarLookup;
import java.util.ArrayList;
import java.util.HashMap;

public class Satisfies
extends Contract {
    static HashMap<ClassInfo, ForwardingPredicate> predicates = new HashMap();
    ContractContext ctx;
    Operand testObj;
    Operand[] args;
    Predicate pred;
    String violation;

    public Satisfies(ContractContext ctx, String id, Operand testObj, ArrayList<Operand> args) {
        int n;
        this.testObj = testObj;
        this.ctx = ctx;
        if (args != null && (n = args.size()) > 0) {
            this.args = new Operand[n];
            args.toArray(this.args);
        }
        this.pred = this.getPredicate(id);
    }

    Predicate getPredicate(String id) {
        try {
            Class<?> cls = Class.forName(id);
            if (NativePredicate.class.isAssignableFrom(cls)) {
                return (Predicate)cls.newInstance();
            }
        }
        catch (IllegalAccessException iax) {
            log.warning("no public constructor: " + id);
        }
        catch (InstantiationException iex) {
            log.warning("error intantiating Predicate object: " + id);
        }
        catch (ClassNotFoundException cfnx) {
            // empty catch block
        }
        Predicate p = this.getModelPredicate(id);
        if (p == null) {
            log.warning("could not find predicate: " + id);
            return null;
        }
        return p;
    }

    Predicate getModelPredicate(String id) {
        ClassInfo ci = this.ctx.resolveClassInfo(id);
        if (ci != null) {
            if (!ci.isInstanceOf("gov.nasa.jpf.Predicate")) {
                log.warning("not a predicate instance: " + id);
                return null;
            }
            ForwardingPredicate p = predicates.get(ci);
            if (p == null) {
                p = new ForwardingPredicate(ci);
                predicates.put(ci, p);
            }
            return p;
        }
        return null;
    }

    @Override
    public boolean holds(VarLookup lookup) {
        if (this.pred != null) {
            Object testObjVal = this.testObj.getValue(lookup);
            Object[] argVals = null;
            if (this.args != null) {
                argVals = new Object[this.args.length];
                for (int i = 0; i < this.args.length; ++i) {
                    argVals[i] = this.args[i].getValue(lookup);
                }
            }
            this.violation = this.pred.evaluate(testObjVal, argVals);
        }
        return this.violation == null;
    }

    @Override
    protected void saveOldOperandValues(VarLookup lookup) {
        if (this.pred != null) {
            this.testObj.saveOldOperandValue(lookup);
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    this.args[i].saveOldOperandValue(lookup);
                }
            }
        }
    }

    public String toString() {
        if (this.violation != null) {
            return this.violation;
        }
        return this.testObj.toString() + " satisfies " + this.pred;
    }

    class ForwardingPredicate
    implements Predicate {
        MethodInfo miPred;
        int predRef;

        ForwardingPredicate(ClassInfo ciPred) {
            MethodInfo mi = ciPred.getMethod("evaluate(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/String;", true);
            if (mi != null) {
                this.miPred = mi.createDirectCallStub("[predicate]");
                this.predRef = this.newInstance(ciPred);
            }
        }

        void execClinit(ClassInfo ci) {
            if (!ci.isInitialized()) {
                ClassInfo sci = ci.getSuperClass();
                if (sci != null) {
                    this.execClinit(sci);
                } else {
                    ThreadInfo ti = Satisfies.this.ctx.getThreadInfo();
                    StaticArea sa = ti.getVM().getStaticArea();
                    sa.addClass(ci, ti);
                    MethodInfo clinit = ci.getMethod("<clinit>()V", false);
                    if (clinit != null) {
                        MethodInfo miStub = clinit.createDirectCallStub("[predicate class init]");
                        DirectCallStackFrame frame = new DirectCallStackFrame(miStub);
                        ti.executeMethodAtomic(frame);
                    }
                }
            }
        }

        void execCtor(ClassInfo ci, int ref) {
            ClassInfo sci = ci.getSuperClass();
            if (sci != null) {
                this.execCtor(sci, ref);
            } else {
                MethodInfo miCtor = ci.getMethod("init()V", false);
                if (miCtor != null) {
                    MethodInfo miStub = miCtor.createDirectCallStub("[predicate init]");
                    DirectCallStackFrame frame = new DirectCallStackFrame(miStub);
                    frame.pushRef(ref);
                    Satisfies.this.ctx.getThreadInfo().executeMethodAtomic(frame);
                }
            }
        }

        public int newInstance(ClassInfo ci) {
            ThreadInfo ti = Satisfies.this.ctx.getThreadInfo();
            JVM vm = ti.getVM();
            DynamicArea da = vm.getDynamicArea();
            if (!ci.isInitialized()) {
                this.execClinit(ci);
            }
            int r = da.newObject(ci, ti);
            ((DynamicElementInfo)da.get(r)).pinDown(true);
            this.execCtor(ci, r);
            return r;
        }

        int getRef(ThreadInfo ti, Object o) {
            if (o instanceof ElementInfo) {
                return ((ElementInfo)o).getIndex();
            }
            MJIEnv env = ti.getEnv();
            if (o instanceof Integer) {
                return env.newInteger((Integer)o);
            }
            if (o instanceof Long) {
                return env.newLong((Long)o);
            }
            if (o instanceof Boolean) {
                return env.newBoolean((Boolean)o);
            }
            if (o instanceof Double) {
                return env.newDouble((Double)o);
            }
            if (o instanceof Float) {
                return env.newFloat(((Float)o).floatValue());
            }
            return env.newString(o.toString());
        }

        int getArrayRef(ThreadInfo ti, Object[] args) {
            if (args != null) {
                MJIEnv env = ti.getEnv();
                int ref = env.newObjectArray("Ljava/lang/Object;", args.length);
                for (int i = 0; i < args.length; ++i) {
                    env.setReferenceArrayElement(ref, i, this.getRef(ti, args[i]));
                }
                return ref;
            }
            return -1;
        }

        public String evaluate(Object testObj, Object[] args) {
            if (this.predRef != -1) {
                ThreadInfo ti = Satisfies.this.ctx.getThreadInfo();
                MJIEnv env = ti.getEnv();
                DirectCallStackFrame frame = new DirectCallStackFrame(this.miPred);
                frame.pushRef(this.predRef);
                frame.pushRef(this.getRef(ti, testObj));
                frame.pushRef(this.getArrayRef(ti, args));
                Satisfies.this.ctx.getThreadInfo().executeMethodAtomic(frame);
                int errRef = frame.pop();
                if (errRef != -1) {
                    return env.getStringObject(errRef);
                }
            }
            return null;
        }
    }
}

