/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.TestContext;
import gov.nasa.jpf.test.TestException;
import gov.nasa.jpf.tools.MethodTester;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Goal {
    public boolean preCheck(TestContext tctx, Method m) throws TestException {
        return true;
    }

    public boolean postCheck(TestContext tctx, Method m, Object res, Throwable t) throws TestException {
        return true;
    }

    public Class<?> getGoalType() {
        return null;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printOn(pw);
        return sw.toString();
    }

    public void printOn(PrintWriter pw) {
        pw.print("goal ");
        pw.print(this.getClass().getName());
    }

    public Object execute(MethodTester tester, Method m, Object tgt, Object[] mthArgs) throws InvocationTargetException, IllegalAccessException {
        return m.invoke(tgt, mthArgs);
    }
}

