/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.TestContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldReference {
    String id;
    boolean isStatic;

    public FieldReference(String id) {
        this.id = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Field getField(Class<?> tgtClass, Object tgtObject, String id) {
        Class<?> cls;
        String fName;
        int idx = id.lastIndexOf(46);
        if (idx >= 0) {
            String clsName = id.substring(0, idx);
            fName = id.substring(idx + 1);
            cls = TestContext.resolveClass(tgtClass.getPackage().getName(), clsName);
            if (cls == null) {
                return null;
            }
        } else {
            fName = id;
            if (tgtClass == null) {
                if (tgtObject == null) return null;
                cls = tgtObject.getClass();
            } else {
                cls = tgtClass;
            }
        }
        try {
            return cls.getDeclaredField(fName);
        }
        catch (NoSuchFieldException nsfx) {
            return null;
        }
        catch (SecurityException sx) {
            return null;
        }
    }

    public Object getValue(Class<?> tgtClass, Object tgtObject) {
        Field fi = FieldReference.getField(tgtClass, tgtObject, this.id);
        if (fi != null) {
            fi.setAccessible(true);
            if (Modifier.isStatic(fi.getModifiers()) || tgtObject != null) {
                try {
                    Object v = fi.get(tgtObject);
                    return v;
                }
                catch (IllegalAccessException iacx) {
                    return null;
                }
                catch (IllegalArgumentException iarx) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "field " + this.id;
    }
}

