/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.test;

import gov.nasa.jpf.test.Operand;
import gov.nasa.jpf.test.VarLookup;
import java.util.List;

public abstract class Expr
extends Operand {

    public static class Func
    extends Expr {
        String id;
        List<Operand> args;

        public Func(String id, List<Operand> args) {
            this.id = id;
            this.args = args;
        }

        @Override
        public Object getValue(VarLookup lookup) {
            return null;
        }

        @Override
        public void saveOldOperandValue(VarLookup lookup) {
            for (Operand a : this.args) {
                a.saveOldOperandValue(lookup);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append(this.id);
            sb.append('(');
            for (Operand a : this.args) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(a);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static class Old
    extends Expr {
        Operand o;

        public Old(Operand o) {
            this.o = o;
        }

        @Override
        public Object getValue(VarLookup lookup) {
            return lookup.lookup(this);
        }

        @Override
        public void saveOldOperandValue(VarLookup lookup) {
            if (!lookup.containsKey(this)) {
                Object v = this.o.getValue(lookup);
                lookup.put(this, v);
            }
        }

        public String toString() {
            return "old(" + this.o + ")";
        }
    }

    public static class Pow
    extends BinaryExpr {
        public Pow(Operand base, Operand exponent) {
            super(base, exponent);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number na = this.a.getNumberValue(lookup);
            Number nb = this.b.getNumberValue(lookup);
            if (na instanceof Double || nb instanceof Double || na instanceof Float || nb instanceof Float) {
                return new Double(Math.pow(na.doubleValue(), nb.doubleValue()));
            }
            return new Integer((int)Math.pow(na.doubleValue(), nb.doubleValue()));
        }

        public String toString() {
            return "pow(" + this.a + "," + this.b + ")";
        }
    }

    public static class Log10
    extends UnaryExpr {
        public Log10(Operand x) {
            super(x);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number no = this.o.getNumberValue(lookup);
            return new Double(Math.log10(no.doubleValue()));
        }

        public String toString() {
            return "log10(" + this.o + ")";
        }
    }

    public static class Log
    extends UnaryExpr {
        public Log(Operand x) {
            super(x);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number no = this.o.getNumberValue(lookup);
            return new Double(Math.log(no.doubleValue()));
        }

        public String toString() {
            return "log(" + this.o + ")";
        }
    }

    public static class Minus
    extends BinaryExpr {
        public Minus(Operand a, Operand b) {
            super(a, b);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number na = this.a.getNumberValue(lookup);
            Number nb = this.b.getNumberValue(lookup);
            if (na instanceof Double || nb instanceof Double || na instanceof Float || nb instanceof Float) {
                return new Double(na.doubleValue() - nb.doubleValue());
            }
            return new Integer(na.intValue() - nb.intValue());
        }

        public String toString() {
            return "(" + this.a + "-" + this.b + ")";
        }
    }

    public static class Plus
    extends BinaryExpr {
        public Plus(Operand a, Operand b) {
            super(a, b);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number na = this.a.getNumberValue(lookup);
            Number nb = this.b.getNumberValue(lookup);
            if (na instanceof Double || nb instanceof Double || na instanceof Float || nb instanceof Float) {
                return new Double(na.doubleValue() + nb.doubleValue());
            }
            return new Integer(na.intValue() + nb.intValue());
        }

        public String toString() {
            return "(" + this.a + "+" + this.b + ")";
        }
    }

    public static class Div
    extends BinaryExpr {
        public Div(Operand divident, Operand divisor) {
            super(divident, divisor);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number na = this.a.getNumberValue(lookup);
            Number nb = this.b.getNumberValue(lookup);
            if (na instanceof Double || nb instanceof Double || na instanceof Float || nb instanceof Float) {
                return new Double(na.doubleValue() / nb.doubleValue());
            }
            return new Integer(na.intValue() / nb.intValue());
        }

        public String toString() {
            return "(" + this.a + "/" + this.b + ")";
        }
    }

    public static class Mult
    extends BinaryExpr {
        public Mult(Operand factor1, Operand factor2) {
            super(factor1, factor2);
        }

        @Override
        public Object getValue(VarLookup lookup) {
            Number na = this.a.getNumberValue(lookup);
            Number nb = this.b.getNumberValue(lookup);
            if (na instanceof Double || nb instanceof Double || na instanceof Float || nb instanceof Float) {
                return new Double(na.doubleValue() * nb.doubleValue());
            }
            return new Integer(na.intValue() * nb.intValue());
        }

        public String toString() {
            return "(" + this.a + "*" + this.b + ")";
        }
    }

    static abstract class BinaryExpr
    extends Expr {
        Operand a;
        Operand b;

        BinaryExpr(Operand a, Operand b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void saveOldOperandValue(VarLookup lookup) {
            this.a.saveOldOperandValue(lookup);
            this.b.saveOldOperandValue(lookup);
        }
    }

    static abstract class UnaryExpr
    extends Expr {
        Operand o;

        UnaryExpr(Operand o) {
            this.o = o;
        }

        @Override
        public void saveOldOperandValue(VarLookup lookup) {
            this.o.saveOldOperandValue(lookup);
        }
    }
}

